// This file combines several files together with modifications. Whenever
// possible, functions were made static. The files are:
//
// malloc.h
// taputil_p.h
// tayutil_p.h
// oplate.h
// adalloc.h
//
// taputil.c
// tayutil.c
// adouble.cpp
// avector.cpp
// taputilc.cpp
// adalloc.c
// malloc.c
// fo_rev.c
// fo_rev.c (2) 



#include "adolc.h"








//@@@@@@ taputil_p.h

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     taputil_p.h
 Revision: $Id: taputil_p.h,v 1.2 2004/05/24 10:50:41 kowarz Exp $
 Contents: Preparation & gets & puts & closing of the taping process
           (ADOL-C internal routines)

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20030306 olvo  extracted from taputil.h of ADOL-C 1.8.7
          
----------------------------------------------------------------------------*/

#if !defined(ADOLC_TAPUTIL_P_H)
#define ADOLC_TAPUTIL_P_H 1

//#include "common.h"

BEGIN_C_DECLS

/****************************************************************************/
/*                                                         GLOBAL VARIABLES */

/*--------------------------------------------------------------------------*/
/* Statistic stuff. */
//extern int ind_ptr;
//extern int dep_ptr;
//extern int vs_ptr;
//extern int revalso;
static int ind_ptr;
static int dep_ptr;
static int vs_ptr;
static int revalso;

/*--------------------------------------------------------------------------*/
/* File Name */
//extern char vs_file_name[20];

#if !defined(ADOLC_HARDDEBUG)
/*--------------------------------------------------------------------------*/
/* Buffers for the operation tape, location tape, real tape. */
//extern unsigned char *op_codes;
//extern locint        *loc_tape;
//extern double        *real_tape;

/*--------------------------------------------------------------------------*/
/* Pointers into the operation tape, location tape, real tape */
//extern unsigned char *g_op_ptr;
//extern locint        *g_loc_ptr;
//extern double        *g_real_ptr;

//extern int op_ptr;
//extern int loc_ptr;
//extern int real_ptr;

/*--------------------------------------------------------------------------*/
/*                                                        MACRO or FUNCTION */
#define get_op_f() *g_op_ptr++ 
#define get_op_r() *(--g_op_ptr)

#define get_locint_f() *g_loc_ptr++
#define get_locint_r() *(--g_loc_ptr)

#define get_val_f() *g_real_ptr++
#define get_val_r() *(--g_real_ptr)

#else /* HARDDEBUG */
static unsigned char get_op_f(void);
static unsigned char get_op_r(void);

static locint get_locint_f(void);
static locint get_locint_r(void);

static double get_val_f(void);
static double get_val_r(void);
#endif 

/****************************************************************************/
/*                                        CONTROL STUFF (inits, ends, etc.) */
static void init_for_sweep(int);
static void init_rev_sweep(int);
static void set_buf_size(int);
static void set_buffers(char*,unsigned char*,char*, locint*,char*, double *);
static void close_tape(int*, int);
static void end_sweep(void);
static void get_fstr( char*,short,char*);

/****************************************************************************/
/*                                                                     PUTs */

/*--------------------------------------------------------------------------*/
/* Operations */
static void put_op(unsigned char);

/*--------------------------------------------------------------------------*/
/* Locations */
static inline void put_locint(locint);

/*--------------------------------------------------------------------------*/
/* Values */
static inline void put_val(double);
static void put_vals_p(double *,int);
static void put_vals_r(double *,int);

/*--------------------------------------------------------------------------*/
/* Update/correction of values or locations */
static void reset_val_r(void);
static inline int upd_resloc(locint, locint);
static inline int upd_resloc_inc_prod(locint, locint, unsigned char);

/****************************************************************************/
/*                                                                     GETs */

/*--------------------------------------------------------------------------*/
/* Operations */
static void get_op_block_f(void);
static void get_op_block_r(void);

/*--------------------------------------------------------------------------*/
/* Locations */
static void get_loc_block_f(void);
static void get_loc_block_r(void);

/*--------------------------------------------------------------------------*/
/* Values */
static int get_val_space(void);
static void get_val_block_f(void);
static void get_val_block_r(void);
static double * get_val_v_f(locint);
static double * get_val_v_r(locint);

/****************************************************************************/
/*                                                                    UTILs */
static double make_nan(void);
static double make_inf(void);
static void fail(int error);

END_C_DECLS

/****************************************************************************/
#endif



//@@@@@@@ tayutil_p.h

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     tayutil_p.h
 Revision: $Id: tayutil_p.h,v 1.2 2004/05/24 10:50:43 kowarz Exp $
 Contents: Management for the value stack tape (Taylors)
           (ADOL-C internal routines)

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
         20030304 andrea: identify value stack by tag
         20010719 andrea: add write_taylors(..)
                          add get_taylors_p(..)
         19991122 olvo:   new op_codes eq_plus_prod eq_min_prod
                          for  y += x1 * x2
                          and  y -= x1 * x2
                          --> new: delete_scaylor(..)  
         19981130 olvo:   automatic cleanup from utils.C moved here
         19980921 olvo:   new interface of void overwrite_scaylor(..) to
                          allow correction of old overwrite in store
         19980708 olvo:   new:  void overwrite_scaylor(..)
         
----------------------------------------------------------------------------*/

#if !defined(ADOLC_TAYUTIL_P_H)
#define ADOLC_TAYUTIL_P_H 1

//#include "common.h"

BEGIN_C_DECLS

/****************************************************************************/
/*                                                         GLOBAL VARIABLES */

/*--------------------------------------------------------------------------*/
/* File Name */
//extern char vs_file_name[20];

/****************************************************************************/
#if !defined(__STDC__)
   static int unlink(char *); 
#endif

/****************************************************************************/
/*                                                            CONTROL STUFF */
static int taylor_access();
static void close_taylor();
static void taylor_begin( short, int, double**,int );
static void taylor_close( int, int, int );
static void taylor_back ( int, revreal*, int*, int*, int* );
static void taylor_back2( int, revreal**, int*, int*, int* );

/****************************************************************************/
/*                                                                   WRITEs */
static inline void write_taylor( locint, int );
static void write_taylors( locint, int, int, int );
static inline void write_scaylor( revreal );
/* olvo 980708 new nl */
static void overwrite_scaylor( revreal, revreal* );
/* olvo 991122 new nl */
static void delete_scaylor( revreal* );
static inline void write_scaylors( double*, int );

/****************************************************************************/
/*                                                                     GETs */
static inline void get_taylor( locint );
static void get_taylors( locint, int );
static void get_taylors_p( locint, int, int );

END_C_DECLS

/****************************************************************************/
#endif






//@@@@@@@ oplate.h


/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     oplate.h
 Revision: $Id: oplate.h,v 1.2 2004/05/24 10:50:40 kowarz Exp $
 Contents: Numeric values for the various opcodes used by ADOL-C.

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:  
          19991122 olvo  new op_codes:       eq_plus_prod
                                             eq_min_prod
                         for  y += x1 * x2  and   y -= x1 * x2  
          19980924 olvo: deleted all int_* opcodes
          19980820 olvo: new comparison strategy (opcodes changed)
          19980714 olvo: removed operation code: mult_av_a
          19980708 olvo: new operation code: neg_sign_a
                                             pos_sign_a
          19980706 olvo: new operation code: int_adb_d_one
                                             int_adb_d_zero
                                             incr_a
                                             decr_a
          19980703 olvo: new operation code: assign_d_one
                                             assign_d_zero
          19980623 olvo: new operation code: take_stock_op
          
----------------------------------------------------------------------------*/

#if !defined(ADOLC_OPLATE_P_H)
#define ADOLC_OPLATE_P_H 1

//#include "common.h"

/****************************************************************************/
/* opcodes */
#define death_not 1
#define assign_ind 2
#define assign_dep 3
#define assign_a 4
#define assign_d 5
#define eq_plus_d 6
#define eq_plus_a 7
#define eq_min_d 8
#define eq_min_a 9
#define eq_mult_d 10
#define eq_mult_a 11
#define plus_a_a 12
#define plus_d_a 13
#define min_a_a 14
#define min_d_a 15
#define mult_a_a 16
#define mult_d_a 17
#define div_a_a 18
#define div_d_a 19
#define exp_op 20
#define cos_op 21
#define sin_op 22
#define atan_op 23
#define log_op 24
#define pow_op 25

/* New as of 4/9/90 */

#define asin_op 26
#define acos_op 27
#define sqrt_op 28
/* removed 1/95
#define eq_div_a 29
#define eq_div_d 30
#define tan_op 31
*/
/* New as of 11/17/95 */
#define asinh_op 29
#define acosh_op 30
#define atanh_op 31


/* New as of 7/3/90 */

#define ignore_me 0
#define gen_quad 32 /* A General Quadrature */

/* New as of 6/10/93 */

/* olvo 980924 removed n2l */
/* #define int_adb_a 33 */ /* Initialize an adouble with another adouble */
/* #define int_adb_d 34 */ /* Initialize an adouble with a double value  */

/* New as of 7/13/93 */

/* Opcodes for tape delimiters. */

#define end_of_tape 35
#define start_of_tape 36

#define end_of_op 37
#define end_of_int 38
#define end_of_val 39

/* vector operations */

#define plus_av_av    40
/* removed 1/95
#define plus_dv_av    41
*/
#define sub_av_av     42
/* removed 1/95
#define sub_dv_av     43
#define sub_av_dv     44
*/
#define dot_av_av     45
/* removed 1/95
#define dot_dv_av     46
*/
#define mult_a_av     47
#define mult_d_av     48
/* removed 1/95
#define mult_a_dv     49
*/
/* olvo 980924 removed nl */
/* #define int_av_av     50 */
/* removed 1/95
#define int_av_dv     51  
*/
#define assign_av     52
#define assign_dv     53
#define assign_indvec 54
#define assign_depvec 55
/* removed 1/95
#define eq_min_dv     56
*/
#define eq_min_av     57
/* removed 1/95
#define eq_plus_dv    58
*/
#define eq_plus_av    59
#define div_av_a      60
#define eq_mult_av_d  61
#define eq_mult_av_a  62
/* removed 1/95
#define dot_av_dv     63
*/
/* olvo 980714 removed
#define mult_av_a     64
*/

#define cond_assign   70
#define cond_assign_s 71
 
#define m_subscript   72
#define m_subscript_l 73
#define m_subscript_ld 74

#define subscript     75
#define subscript_l   76
#define subscript_ld  77

/* removed 1/95
#define cross_av_av   80
#define mult_cv3_av4  81
*/

/* olvo 980623 */
#define take_stock_op 90

/* olvo 980703 */
#define assign_d_one   91
#define assign_d_zero  92
/* olvo 980924 removed n2l */
/* #define int_adb_d_one  93
   #define int_adb_d_zero 94 */
#define incr_a         95
#define decr_a         96

/* olvo 980703 */
#define neg_sign_a     97
#define pos_sign_a     98

/*New as of 11/14/94 */
#define min_op        100
/*New as of 8/14/94 */
#define abs_val       101

/* olvo 980820 opcodes for comparison changed */
#define eq_zero       102
#define neq_zero      103
#define le_zero       104
#define gt_zero       105
#define ge_zero       106
#define lt_zero       107

/* olvo 991122 new opcodes */
#define eq_plus_prod 110
#define eq_min_prod  111

#define erf_op  114
#define ceil_op 115
#define floor_op 116

/* kowarz 20040614 */
#define ext_diff 117

/****************************************************************************/
#endif



//@@@@@@@ adalloc.h

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     adalloc.h
 Revision: $Id: adalloc.h,v 1.2 2004/05/24 10:50:27 kowarz Exp $
 Contents: Allocation of arrays of doubles in several dimensions 

 Copyright (c) 2003
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing

 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.
 
 History:
          20040423 kowarz: adapted to configure - make - make install
          20000310 olvo:   removed superflous semicola
          19990622 olvo:   myfree routines & special identity 
                           allocations (2n-1-vectors) 
                           (MOSTLY INLINED)
          19981130 olvo:   newly created.
 
----------------------------------------------------------------------------*/
#if !defined (ADOLC_ADALLOC_H)
#define ADOLC_ADALLOC_H 1

//#include "common.h"

/****************************************************************************/
/*                                                         Now the C THINGS */
BEGIN_C_DECLS

/*--------------------------------------------------------------------------*/
/*                                              MEMORY MANAGEMENT UTILITIES */
static double    *myalloc1(int);
static double   **myalloc2(int, int);
static double  ***myalloc3(int, int, int);

static void myfree1(double   *);
static void myfree2(double  **);
static void myfree3(double ***);

/*--------------------------------------------------------------------------*/
/*                                          SPECIAL IDENTITY REPRESENTATION */
static double   **myallocI2(int);
static void myfreeI2(int, double**);

END_C_DECLS

/****************************************************************************/
/*                                                       Now the C++ THINGS */
#if defined(__cplusplus)

/*--------------------------------------------------------------------------*/
/*                                              MEMORY MANAGEMENT UTILITIES */
inline double   * myalloc(int n) { return myalloc1(n); }
inline double  ** myalloc(int m, int n) { return myalloc2(m,n); }
inline double *** myalloc(int m, int n, int p) { return myalloc3(m,n,p); }

inline void myfree(double   *A) { myfree1(A); }
inline void myfree(double  **A) { myfree2(A); }
inline void myfree(double ***A) { myfree3(A); }

#endif

/****************************************************************************/
#endif




//@@@@@@ taputil.c

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     taputil.c
 Revision: $Id: taputil.c,v 1.2 2004/05/24 10:50:40 kowarz Exp $
 Contents: Initialization, stopage, and gets&puts of the taping process;
           as well as statistic gathering functions

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing

 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20040422 kowarz: adapted to configure - make - make install
          20030304 andrea: new global variable vs_file_name
          19991122 olvo:   new op_codes eq_plus_prod eq_min_prod
                           for  y += x1 * x2
                           and  y -= x1 * x2
                           --> new: upd_resloc_inc_prod(..)  
          19981130 olvo:   newly created by unification of taputil?.c
                           and all tape stuff
 History of taputil1.c:
          19981030 olvo:   bufsize --> BUFSIZE & TBUFSIZE
          19981019 olvo:   don't check sizeof(revreal)
          19980914 olvo:   unique size of stats block
          19980825 olvo:   #defines instead of const (C-Code!)
          19980820 olvo:   modification of statistic stuff
          19980723 olvo:   taputil3.* moved here
          19980713 olvo:   (1) no write_... routines anymore!
                           (2) statistic stuff kept here only
          19980709 olvo:   void write_pos_sign_a(..)
                           void write_neg_sign_a(..)
          19980708 olvo:   void write_upd(..)
          19980707 olvo:   void write_dot_av_av(..)
          19980706 olvo:   new operation code: incr_a
                                               decr_a
                           (void write_incr_decr_a(..) )
                                               int_adb_d_one
                                               int_adb_d_zero 
          19980703 olvo:   new operation code: assign_d_one
                                               assign_d_zero 
          19980623 olvo:   new operation code: take_stock_op

 History of taputil2.c:
          19980914 olvo:   unique size of stats block
          19980517 olvo:   griewank's idea:
                           int upd_resloc(locint, locint);

----------------------------------------------------------------------------*/
//#include "taputil.h"
//#include "taputil_p.h"
//#include "tayutil.h"
//#include "tayutil_p.h"
//#include "oplate.h"

//#include <string.h>
#include <errno.h>

BEGIN_C_DECLS

/****************************************************************************/
/*                                      GLOBAL VARIABLES (external linkage) */
/* EGK (some external variables changed to static) */

/*--------------------------------------------------------------------------*/
/* Buffers for the operation tape, location tape, real tape. */
static unsigned char *op_codes;
static locint        *loc_tape;
static double        *real_tape;

/*--------------------------------------------------------------------------*/
/* Pointers into the operation tape, location tape, real tape */
static unsigned char *g_op_ptr;
static locint        *g_loc_ptr;
static double        *g_real_ptr;

static int op_ptr;
static int loc_ptr;
static int real_ptr;

/*--------------------------------------------------------------------------*/
/* Statistic stuff */ //EGK moved above
//int ind_ptr;
//int dep_ptr;
//int vs_ptr;
//int revalso;

/****************************************************************************/
/*                                       LOCAL VARIABLES (internal linkage) */

/*--------------------------------------------------------------------------*/
/* Max number of tapes currently in use */ 
static int maxtapes = 0;

/*--------------------------------------------------------------------------*/
/* File Names */
static char op_file_name[20];
static char int_file_name[20];
static char val_file_name[20];

/*--------------------------------------------------------------------------*/
/* Arrays of pointers to the various tape buffers */
static unsigned char **op_tape;
static locint        **int_tape;
static double        **val_tape;

/*--------------------------------------------------------------------------*/
/* Array of pointers to the stats arrays (of size statSize) */
static int **stats;

/*--------------------------------------------------------------------------*/
static int tag;

/*--------------------------------------------------------------------------*/
/* Tape identification (ADOLC & version check) */

/* ADOL-C Patchlevel */
#define ADOLC_PATCHLEVEL 1

/* ADOL-C Subversion */
#define ADOLC_SUBVERSION 10

/* ADOL-C Version */
#define ADOLC_VERSION 1


static int adolcID[]    = { ADOLC_VERSION,
                     ADOLC_SUBVERSION,
                     ADOLC_PATCHLEVEL,
                     sizeof(locint),
                     sizeof(revreal)
                   }; 

/*--------------------------------------------------------------------------*/
/* File pointers to the operation tape, location tape, real tape */ 
static FILE *op_file_out;
static FILE *int_file_out;
static FILE *val_file_out;

/*--------------------------------------------------------------------------*/
/* Stats on operation tape, location tape, real tape */
static int op_access_ptr,
           int_access_ptr,
           val_access_ptr;

static int op_len_ptr,
           int_len_ptr,
           val_len_ptr;

/*--------------------------------------------------------------------------*/
/* Strings for the tape names (actual file names) */
static char *op_file,
            *int_file,
            *val_file;

/*--------------------------------------------------------------------------*/
/* File counts */
static long op_file_cnt,
            int_file_cnt,
            val_file_cnt;

/*--------------------------------------------------------------------------*/
/* Current buffer size */
static int buff_size;

/****************************************************************************/
/*                                                         GLOBAL VARIABLES */

/* File Name */
static char vs_file_name[20];

/****************************************************************************/
/*                                                       INTERNAL FUNCTIONS */

/*--------------------------------------------------------------------------*/
static void fail( int error )
{ switch (error) {
    case -1:
      fprintf(DIAG_OUT,"ADOL-C error: Malloc of memory failed!\n");
      exit (error);
      break;
    case -2:
      fprintf(DIAG_OUT,
              "ADOL-C error: Got NULL pointer as extern function pointer!\n");
      exit (error);
      break;
    case -3:
      fprintf(DIAG_OUT,
              "ADOL-C error: No function for extern differentiation found to work with (null pointer)\n!");
      exit (error);
      break;
    case -4:
      fprintf(DIAG_OUT,
              "ADOL-C error: Number of independents/dependents recorded on tape differ from number suplied by user!\n");
      exit (error);
      break;
    case -5:
      fprintf(DIAG_OUT,
              "ADOL-C error: Got at least one null pointer as argument to extern differnetiated function!\n");
      exit (error);
      break;
    case -6:
      fprintf(DIAG_OUT,
              "ADOL-C error: Function with specified index not found!\n");
      exit (error);
      break;
    default:
      fprintf(DIAG_OUT,"ADOL-C error => unknown error type!\n");
      exit (-1);
  }
}

/*--------------------------------------------------------------------------*/
/* int2asc converts the integer num to a string, places it
   in the array string, and returns the pointer to the 
   string.  (I now that this is rather redundant, but I
   didn't write the original code for this.-- DWJ ;-)    */
static char* int2asc( int num, char string[] )
{ sprintf(string,"%d",num);
  return(string);
}


/*--------------------------------------------------------------------------*/
/* The subroutine get_fstr appends to the filename fname             
   the number fnum, and puts the resulting    
   string in fstr.  */
static void  get_fstr( char *fstr, short fnum, char *fname )
/**** 
  The caller of this function is responsible for allocating the appropriate 
  amount of storage for fstr [strlen(FNAME)+1 <= strlen(fstr) 
                                              <= strlen(FNAME)+5] 
****/
{ char tstr[10];

  if (fnum)
  { strcpy (fstr,fname);
    int2asc (fnum,tstr);
    strcat (fstr,tstr);
  }
  else
  { strcpy (fstr,fname);
    fstr[strlen(fstr)-1] = '\0';
  }
}

/****************************************************************************/
/*                                                           HELPFUL LOCALs */

/*--------------------------------------------------------------------------*/
static void init_stat_space( short tnum )
{ unsigned char **t1;          /* t1,t2,t3 and t4 are temporaries */
  double **t2;
  locint **t3;
  int    **t4;
  int jj;

  /* Set up space for */ 
  if (maxtapes == 0) /*this is only done at first call to start_trace or
                       init_stat_space */
  { maxtapes = 10;
    if (tnum >= maxtapes)
      maxtapes = tnum + 10;
    if ((op_tape = (unsigned char **)malloc(maxtapes*sizeof(unsigned char*))) == 0) 
      fail(-1);
    if ((int_tape = (locint **)malloc(maxtapes*sizeof(locint *))) == 0)
      fail(-1);
    if ((val_tape = (double **)malloc(maxtapes*sizeof(double *))) == 0)
      fail(-1);
      
    if ((stats = (int**)malloc(maxtapes*sizeof(int*))) == 0)
      fail(-1);
    for (jj=0; jj<maxtapes; jj++)
    { op_tape[jj]  = 0;
      int_tape[jj] = 0;
      val_tape[jj] = 0;
      stats[jj]    = 0;
    }
  }
  
  if (tnum >= maxtapes)
  { int newtapes = tnum + 10;
    t1 = op_tape;
    t3 = int_tape;
    t2 = val_tape;
    t4 = stats;
    if ((op_tape =(unsigned char**)malloc(newtapes*sizeof(unsigned char*))) == 0) 
      fail(-1);
    if ((int_tape = (locint **)malloc(newtapes*sizeof(locint *))) == 0)
      fail(-1);
    if ((val_tape = (double **)malloc(newtapes*sizeof(double *))) == 0)
      fail(-1);
    if ((stats = (int**)malloc(newtapes*sizeof(int*))) == 0)
      fail(-1);
      
    for (jj=0; jj<maxtapes; jj++)
    { op_tape[jj]  = t1[jj];
      int_tape[jj] = t3[jj];
      val_tape[jj] = t2[jj];
      stats[jj]    = t4[jj];
    }
    free((char *)t1);free((char *)t2);free((char *)t3);free((char *)t4);

    for(jj=maxtapes; jj<newtapes; jj++)
    { op_tape[jj]  = 0;
      int_tape[jj] = 0;
      val_tape[jj] = 0;
      stats[jj]    = 0;
    }
    maxtapes = newtapes;
  }
}

/*--------------------------------------------------------------------------*/
static void set_up_buffers( short tag, int buffer_size )
{ /* Return old memory ... if used */
  if (op_tape[tag]) 
    free((char*)op_tape[tag]);
  if (int_tape[tag])
    free((char*)int_tape[tag]);
  if (val_tape[tag])
    free((char*)val_tape[tag]);
  if (stats[tag])
    free((char*)stats[tag]);
  
  op_tape[tag]  = (unsigned char *)malloc(buffer_size*sizeof(unsigned char));
  int_tape[tag] = (locint *)malloc(buffer_size*sizeof(locint));
  val_tape[tag] = (double *)malloc(buffer_size*sizeof(double));
  stats[tag]    = (int*)malloc(statSize*sizeof(int));
  if ((op_tape[tag] == NULL) || (int_tape[tag]==NULL) 
      || (val_tape[tag] == NULL) || (stats[tag] == NULL)) 
  { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate tape buffers!\n");
    exit (-1);
  }
}

/*--------------------------------------------------------------------------*/
static void read_tape_stats( short tag, int *stats )
{ char int_file[20];
  FILE *int_file_in;
  int version[adolcIDSize];

  get_fstr(int_file,tag,FNAME1);
  
  if ((int_file_in = fopen(int_file,"rb")) == 0) 
  { fprintf(DIAG_OUT,"ADOL-C error: Error reading integer tape number %d \n",
                   tag);
    fprintf(DIAG_OUT,"Fopen returned error number %d \n",tag);
    exit(-1);
  }
  if (fread((char *)stats,statSize*sizeof(int),1,int_file_in) != 1)
  { fprintf(DIAG_OUT,"ADOL-C error: Error reading integer tape number %d \n",
                   tag);
    fprintf(DIAG_OUT,"Fread returned error number %d \n",tag);
    exit(-1);
  }
  /* olvo 980820 version check */ 
  if (fread((char *)version,adolcIDSize*sizeof(int),1,int_file_in) != 1)
  { fprintf(DIAG_OUT,"ADOL-C error: Error reading integer tape number %d \n",
                   tag);
    fprintf(DIAG_OUT,"Fread returned error number %d \n",tag);
    exit(-1);
  }
  if (   (version[0] < adolcID[0]) 
      || ((version[0] == adolcID[0]) &&  (version[1] < adolcID[1])))
  { fprintf(DIAG_OUT,"ADOL-C error: Used tape (%d) was written with ADOL-C"
                     " version older than %d.%d\n",
                   tag,ADOLC_VERSION, ADOLC_SUBVERSION);
    fprintf(DIAG_OUT,"This is ADOL-C %d.%d.%d\n", ADOLC_VERSION,
                      ADOLC_SUBVERSION, ADOLC_PATCHLEVEL);
    exit(-1); 
  }
  if (version[3] != adolcID[3]) 
  { fprintf(DIAG_OUT,"ADOL-C error: Used tape (%d) was written with locints"
                     " of size %d, size %d required.\n",
                   tag, version[3], adolcID[3]);
    exit(-1); 
  }
  /* 981019 olvo: don't check sizeof(revreal)
  if (version[4] != adolcID[4]) 
  { fprintf(DIAG_OUT,"ADOL-C error: Used tape (%d) was written with revreals"
                     " of size %d, size %d required.\n",
                   tag, version[4], adolcID[4]);
    exit(-1); 
  } */
  fclose(int_file_in);
}

/****************************************************************************/
/*                                                          STATS functions */

/*--------------------------------------------------------------------------*/
/* Tapestats:                                                               */
/* Returns statistics on the tape tag.  The array tape_stat is assumed to   */
/* contain at least 11 elements.  The elements of the array are the         */
/* following.                                                               */
/* tape_stat[0] = # of independent variables.                               */
/* tape_stat[1] = # of dependent variables.                                 */
/* tape_stat[2] = max # of live variables.                                  */
/* tape_stat[3] = value stack size.                                         */
/* tape_stat[4] = buffer size (# of chars, # of doubles, # of locints)      */
/* tape_stat[5] = # of operations.                                          */ 
/* tape_stat[6] = operation file access flag (1 = file in use, 0 otherwise) */
/* tape_stat[7] = # of saved locations.                                     */ 
/* tape_stat[8] = location file access flag (1 = file in use, 0 otherwise)  */
/* tape_stat[9] = # of saved constant values.                               */ 
/* tape_stat[10]= value file access flag (1 = file in use, 0 otherwise)     */
/*                                                                          */
/*--------------------------------------------------------------------------*/
void tapestats( short tag,int *tape_stat )
{ int i;

  /* Make sure that there is tape access */
  init_stat_space(tag);

  if (stats[tag] == 0) 
  { /* Tape number does not exist , so read in tape data */
    read_tape_stats(tag,tape_stat);
    set_up_buffers(tag,tape_stat[4]);

    /* Copy data to stats for future use */

    for (i=0; i<statSize; i++)
      stats[tag][i] = tape_stat[i];
  }
  else
    for (i=0; i<statSize; i++)
      tape_stat[i] = stats[tag][i];
}
 
/*--------------------------------------------------------------------------*/
static void get_op_stats( int tag, char **ret_op_file, int *ret_op_len, 
                   int *ret_op_access, unsigned char **ret_op_tape )
{ get_fstr(op_file_name,tag,FNAME);
  *ret_op_file   = op_file_name;
  *ret_op_len    = stats[tag][5];
  *ret_op_access = stats[tag][6];
  *ret_op_tape   = op_tape[tag];
}

/*--------------------------------------------------------------------------*/
static void get_int_stats( int tag, char **ret_int_file, int *ret_int_len, 
                    int *ret_int_access, locint **ret_int_tape )
{ get_fstr(int_file_name,tag,FNAME1);
  *ret_int_file   = int_file_name;
  *ret_int_len    = stats[tag][7];
  *ret_int_access = stats[tag][8];
  *ret_int_tape   = int_tape[tag];
}

/*--------------------------------------------------------------------------*/
static void get_val_stats( int tag, char **ret_val_file, int *ret_val_len, 
                    int *ret_val_access,double **ret_val_tape)
{ get_fstr(val_file_name,tag,FNAME2);
  *ret_val_file   = val_file_name;
  *ret_val_len    = stats[tag][9];
  *ret_val_access = stats[tag][10];
  *ret_val_tape   = val_tape[tag];
}


/****************************************************************************/
/*                                                                  TRACING */

/****************************************************************************/
/* start_trace: (part of trace_on)                                          */
/* Initialization for the taping process.  Sets up the arrays op_tape,      */
/* int_tape, val_tape, and stats.  Op_tape, int_tape, val_tape are arrays   */
/* of pointers to individual buffers for operations, integers (locints),    */
/* and values (doubles).  Also initializes buffers for this tape, sets      */
/* files names, and calls appropriate setup routines.                       */
/****************************************************************************/
bool first_time = true; // added by EGK to prevent repeated calls to free and
			// malloc
void start_trace( short tnum, int revals )
{ unsigned int kk; // EGK: changed type from int to unsigned int to prevent
		   // compiler warning
  double** dum = 0;
  int degree = 0;
  
// EGK: modified so that we always assume we will be followed
// by a reverse sweep
//  revalso = revals;
  revalso = 1;

  tag     = tnum;
  
  /* Set buffer size to be the default in usrparms.h */
  set_buf_size(BUFSIZE);

  get_fstr(op_file_name,tag,FNAME);
  get_fstr(int_file_name,tag,FNAME1);
  get_fstr(val_file_name,tag,FNAME2);
  get_fstr(vs_file_name,tag,FNAME3);
  
  init_stat_space(tag);

  /* Return old memory ... if used */
// EGK modified to allocate only once
  if(first_time)
  {
  if(op_tape[tag])  free((char*)op_tape[tag]);
  if(int_tape[tag]) free((char*)int_tape[tag]);
  if(val_tape[tag]) free((char*)val_tape[tag]);
  if(stats[tag])    free((char*)stats[tag]);
  }
  
  if(first_time)
  {
  op_tape[tag]  = (unsigned char *)malloc(BUFSIZE*sizeof(unsigned char));
  int_tape[tag] = (locint *)malloc(BUFSIZE*sizeof(locint));
  val_tape[tag] = (double *)malloc(BUFSIZE*sizeof(double));
  stats[tag]    = (int*)malloc(statSize*sizeof(int));
  }
  if ((op_tape[tag]  == NULL) || 
      (int_tape[tag] == NULL) || 
      (val_tape[tag] == NULL) ||
      (stats[tag]    == NULL)) 
  { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate tape buffers!\n");
    exit (-1);
  }
  
  ind_ptr   = 0;
  dep_ptr   = 0;
  vs_ptr = 0;      
 
  /* Initialize Tapes */
  set_buffers(op_file_name,op_tape[tag],
	      int_file_name,int_tape[tag],
	      val_file_name,val_tape[tag]);
  
  /* Put operation denoting the start_of_the tape */ 
  put_op(start_of_tape);
  /* Leave space for the stats */
  /* olvo 980914 unique size of stats block */
  for (kk=0; kk<sizeof(int)/sizeof(locint)*statSpace; kk++)
    put_locint(0);
   
  //if (revalso)
    taylor_begin(tag,TBUFSIZE,dum,degree);

    first_time = false;
}


/*************************************************************************/
/* Stop Tracing.  Clean up, and turn off trace_flag.                    **/
/*************************************************************************/
void stop_trace(int locations, int flag)
{ int tape_stats[statSize];
  int i,sizer;

  int loc_ptr;
  /* int op_cnt,loc_cnt,val_cnt,access_ptr; */

  loc_ptr = locations;     
  put_op(end_of_tape);        /* Mark end of tape. */

  tape_stats[0] = ind_ptr;
  tape_stats[1] = dep_ptr;
  tape_stats[2] = loc_ptr;
  tape_stats[3] = vs_ptr;
  tape_stats[4] = BUFSIZE;
  close_tape(tape_stats,flag); /** closes the tape, files up stats, and
                                   writes the tape stats to the integer
                                   tape. **/
  
  sizer = sizeof(revreal)*(vs_ptr);
  //if (revalso) 
    taylor_close(sizer/(1+sizer/TBUFSIZE),dep_ptr,ind_ptr);
  for (i=0; i<statSize; i++)
    stats[tag][i]=tape_stats[i];
}


/****************************************************************************/
/*                                                          DEBUG FUNCTIONS */
#if defined(ADOLC_HARDDEBUG)

/*--------------------------------------------------------------------------*/
static unsigned char get_op_f( void )
{ unsigned char temp;
  temp= *g_op_ptr++;
  fprintf(DIAG_OUT,"f_op: %i\n",temp-'\0');
  return temp;
}

/*--------------------------------------------------------------------------*/
static unsigned char get_op_r( void )
{ unsigned char temp;
  temp= *(--g_op_ptr);
  fprintf(DIAG_OUT,"r_op: %i\n",temp-'\0');
  return temp;
}

/*--------------------------------------------------------------------------*/
static locint get_locint_f( void )
{ locint temp;
  temp= *g_loc_ptr++;
  fprintf(DIAG_OUT,"f_loc: %i\n",temp);
  return temp;
}

/*--------------------------------------------------------------------------*/
static locint get_locint_r( void )
{ unsigned char temp;
  temp= *(--g_loc_ptr);
  fprintf(DIAG_OUT,"r_loc: %i\n",temp);
  return temp;
}

/*--------------------------------------------------------------------------*/
static double get_val_f( void )
{ double temp;
  temp= *g_real_ptr++;
  fprintf(DIAG_OUT,"f_val: %e\n",temp);
  return temp;
}

/*--------------------------------------------------------------------------*/
static double get_val_r( void )
{ double temp;
  temp= *(--g_real_ptr);
  fprintf(DIAG_OUT,"r_val: %e\n",temp);
  return temp;
}

#endif


/****************************************************************************/
/*                                                               LOCAL PUTs */
/****************************************************************/
/** Put_Block puts a block of tape to the disk.  I assume this **/
/** is called only during a first forward pass or during the   **/
/** the taping itself. Its purpose is to record all of the     **/
/** computations.                                              **/
/****************************************************************/
static inline void put_op_block( int buffer_size )
{
   // EGK: modified to remove write to disk
#if 0
  int n;
  if (op_access_ptr == 0)
  { op_file_out = fopen(op_file,"rb");
    if (op_file_out != 0)
    {
#if defined(ADOLC_DEBUG)
      fprintf(DIAG_OUT,"ADOL-C debug: old tapefile %s exists and deleted\n",op_file);
#endif
      fclose(op_file_out);
      if (remove(op_file))  /*  Complies with ANSI C standard */
      /* if(unlink(op_file))      works on some UNIX systems */
	fprintf(DIAG_OUT,"ADOL-C error: unable to remove old tapefile\n");
      op_file_out = fopen(op_file,"wb");
    }
    else
    { op_file_out = fopen(op_file,"wb");
      errno =0; /* Clear Out the Error */
    }
    op_access_ptr = 1;
  }
#endif

  op_len_ptr += buffer_size;

#if 0
  if ((n = fwrite((char *)op_codes,buffer_size,1,op_file_out)) !=1 )
  {fprintf(DIAG_OUT,"ADOL-C error: Fatal error-doing a write %d--- error %d\n",n,errno);
    switch (errno) {
      case 28: /* ENOSPC */
	fprintf(DIAG_OUT,"No space left on device-contact sys. manager\n");
	break;
      case 27: /* EFBIG */
	fprintf(DIAG_OUT,"File too big-- tape space exhausted.\n");
	break;
      default:
	fprintf(DIAG_OUT,"Unexpected unix file error-- %d.\n",errno);
	break;
    }
    exit(-3);
  }
#endif

  op_ptr = 0;
//  errno  = 0;
}

static inline void put_locint_block( int buffer_size )
{ 
   // EGK: modified to remove write to disk
#if 0
  int n;
  if (int_access_ptr == 0)
  { int_file_out = fopen(int_file,"rb");
    if (int_file_out != 0)
    { 
#if defined(ADOLC_DEBUG)
      fprintf(DIAG_OUT,"ADOL-C debug: old tapefile %s exists and deleted\n",int_file);
#endif
      fclose(int_file_out);
      if (remove(int_file))  /*    Complies with ANSI C standard */
      /* if(unlink(int_file))        works on some UNIX systems    */
	fprintf(DIAG_OUT,"ADOL-C error: unable to remove old tapefile\n");
      int_file_out = fopen(int_file,"wb");
    }
    else
    { int_file_out = fopen(int_file,"wb");
      errno =0; /* Clear Out the Error */
    }
    int_access_ptr = 1;
  }
#endif 

  int_len_ptr += buffer_size;

#if 0
  if ((n = fwrite((locint *)loc_tape,buffer_size*sizeof(locint),1,int_file_out)) != 1)
  {fprintf(DIAG_OUT,"ADOL-C error: Fatal error-doing a write %d--- error %d\n",n,errno);
    switch (errno) {
      case 28: /* ENOSPC */
	fprintf(DIAG_OUT,"No space left on device-contact sys. manager\n");
	break;
      case 27: /* EFBIG */
	fprintf(DIAG_OUT,"File too big-- tape space exhausted.\n");
	break;
      default:
	fprintf(DIAG_OUT,"Unexpected unix file error-- %d.\n",errno);
	break;
    }
    exit(-3);
  }
#endif

  loc_ptr = 0;
//  errno   = 0;
}

static inline void put_val_block( int buffer_size )
{
   // EGK: modified to remove write to disk
#if 0
  int n;
  if (val_access_ptr == 0)
  { val_file_out = fopen(val_file,"rb");
    if (val_file_out != 0)
    {
#if defined(ADOLC_DEBUG)
      fprintf(DIAG_OUT,"ADOL-C debug: old tapefile %s exists and deleted\n",val_file);
#endif
      fclose(val_file_out);
      if (remove(val_file))   /* Complies with ANSI C standard */
      /* if(unlink(val_file))      works on some UNIX systems    */
	fprintf(DIAG_OUT,"ADOL-C error: unable to remove old tapefile\n");
      val_file_out = fopen(val_file,"wb");
    }
    else
    { val_file_out = fopen(val_file,"wb");
      errno =0; /* Clear Out the Error */
    }
    val_access_ptr = 1;
  }
#endif

  val_len_ptr += buffer_size;

#if 0
  if ((n = fwrite((double *)real_tape,buffer_size*sizeof(double),1,val_file_out)) != 1)
  {fprintf(DIAG_OUT,"ADOL-C error: Fatal error-doing a write %d--- error %d\n",n,errno);
    switch (errno) {
      case 28: /* ENOSPC */
	fprintf(DIAG_OUT,"No space left on device-contact sys. manager\n");
	break;
      case 27: /* EFBIG */
	fprintf(DIAG_OUT,"File too big-- tape space exhausted.\n");
	break;
      default:
	fprintf(DIAG_OUT,"Unexpected unix file error-- %d.\n",errno);
	break;
    }
    exit(-3);
  }
#endif 

  real_ptr = 0;
//  errno    = 0;
}


/****************************************************************************/
/*                                        CONTROL STUFF (inits, ends, etc.) */

static void init_for_sweep( int tag )
{ get_op_stats(tag,&op_file,&op_len_ptr,&op_access_ptr,&op_codes);
  if (op_access_ptr)
  { op_file_out = fopen(op_file,"rb");
    op_ptr = MIN_ADOLC(buff_size,op_len_ptr); 
    fread((char *)op_codes,op_ptr,1,op_file_out);
    op_len_ptr -= op_ptr;
  } 
  g_op_ptr = op_codes;

  get_int_stats(tag,&int_file,&int_len_ptr,&int_access_ptr,&loc_tape);
  if (int_access_ptr)
  { int_file_out = fopen(int_file,"rb");
    loc_ptr = MIN_ADOLC(buff_size,int_len_ptr);
    fread((locint *)loc_tape,sizeof(locint),loc_ptr,int_file_out);
    int_len_ptr -= loc_ptr;
  } 

  /* olvo 980914 unique size of stats block */
  g_loc_ptr = loc_tape+ sizeof(int)/sizeof(locint)*statSpace; 

  /* loc_tape = (loc_tape+loc_ptr); */
  get_val_stats(tag,&val_file,&val_len_ptr,&val_access_ptr,&real_tape);
  if (val_access_ptr)
  { val_file_out = fopen(val_file,"rb");
    real_ptr = MIN_ADOLC(val_len_ptr,buff_size);
    fread((char *)real_tape,real_ptr*sizeof(double),1,val_file_out);
    val_len_ptr -= real_ptr;
  } 
  g_real_ptr = real_tape;
}

static void init_rev_sweep(int tag)
{ get_op_stats(tag,&op_file,&op_len_ptr,&op_access_ptr,&op_codes);
  if (op_access_ptr)
  { op_file_out = fopen(op_file,"rb");
    op_ptr = op_len_ptr % buff_size;
    fseek(op_file_out,0,2);
    op_file_cnt =  ftell(op_file_out);
    op_file_cnt -= op_ptr*sizeof(unsigned char);
    fseek(op_file_out,op_file_cnt,0);
    fread((char *)op_codes,op_ptr,1,op_file_out);
    op_file_cnt -= buff_size*sizeof(unsigned char);
    g_op_ptr = op_codes + op_ptr;
  } 
  else 
    g_op_ptr = op_codes + op_len_ptr;

  get_int_stats(tag,&int_file,&int_len_ptr,&int_access_ptr,&loc_tape);
  if (int_access_ptr)
  { int_file_out = fopen(int_file,"rb");
    loc_ptr = int_len_ptr % buff_size;
    fseek(int_file_out,0,2);
    int_file_cnt =  ftell(int_file_out);
    int_file_cnt -= loc_ptr*sizeof(locint);
    fseek(int_file_out,int_file_cnt,0);
    fread((char *)loc_tape,loc_ptr*sizeof(locint),1,int_file_out);
    int_file_cnt -= buff_size*sizeof(locint);
    g_loc_ptr = loc_tape + loc_ptr;
  } 
  else 
    g_loc_ptr = loc_tape + int_len_ptr;

  get_val_stats(tag,&val_file,&val_len_ptr,&val_access_ptr,&real_tape);
  if (val_access_ptr)
  { val_file_out = fopen(val_file,"rb");
    real_ptr = val_len_ptr % buff_size;
    fseek(val_file_out,0,2);
    val_file_cnt =  ftell(val_file_out);
    val_file_cnt -= real_ptr*sizeof(double);
    fseek(val_file_out,val_file_cnt,0);
    fread((char *)real_tape,real_ptr*sizeof(double),1,val_file_out);
    val_file_cnt -= buff_size*sizeof(double);
    g_real_ptr = real_tape + real_ptr;
  } 
  else 
    g_real_ptr = real_tape + val_len_ptr;
}

static void set_buf_size( int size )
{ buff_size = size;
}

static void set_buffers( char *file1, unsigned char *op_addr,
		  char *file2, locint *int_addr,
		  char *file3, double *real_addr )
{ op_codes  = op_addr;
  loc_tape  = int_addr;
  real_tape = real_addr;
  op_file  = file1;
  int_file = file2;
  val_file = file3;
  op_ptr        = loc_ptr        = real_ptr       = 0;
  op_access_ptr = int_access_ptr = val_access_ptr = 0;
  op_len_ptr    = int_len_ptr    = val_len_ptr    = 0;
}

static void close_tape( int *stats, int flag )
{ int i;
  int access = (flag || op_access_ptr || int_access_ptr ||val_access_ptr);
  if (access)
  { if (op_ptr != 0)
      put_op_block(op_ptr);
    fclose(op_file_out);
  }
  else 
    op_len_ptr = op_ptr;
  stats[5] = op_len_ptr;
  stats[6] = op_access_ptr;

  if (access)
  { if (real_ptr != 0)
      put_val_block(real_ptr);
      if (val_file_out!=NULL) fclose(val_file_out);
  }
  else
    val_len_ptr = real_ptr;
  stats[9]  = val_len_ptr;
  stats[10] = val_access_ptr;

  if (access)
  { if (loc_ptr != 0)
      put_locint_block(loc_ptr);
    stats[7] = int_len_ptr;
    stats[8] = int_access_ptr;
    fseek(int_file_out,0,0);
    fwrite(stats,statSize*sizeof(int),1,int_file_out);
    /* olvo 980820 new: write ADOL-C version */
    fwrite(adolcID,adolcIDSize*sizeof(int),1,int_file_out); 
    fclose(int_file_out);
  }
  else
  { int_len_ptr = loc_ptr;
    stats[7] = int_len_ptr;
    stats[8] = int_access_ptr;
    for(i=0; i<statSize; i++)
      loc_tape[i] = stats[i];
  }
}

static void end_sweep(void)
{ if (op_access_ptr)
    fclose(op_file_out); 
  if (int_access_ptr)
    fclose(int_file_out);
  if (val_access_ptr)
    fclose(val_file_out);
}


/****************************************************************************/
/*                                                                     PUTs */

/*--------------------------------------------------------------------------*/
/* Locations */
//#define PUT_LOCINT_MACRO(LOC) loc_tape[loc_ptr++] = LOC;
static inline void put_locint( locint loc )
{ /*if (loc_ptr == buff_size) put_locint_block(buff_size); */
  loc_tape[loc_ptr++] = loc;
}

/*--------------------------------------------------------------------------*/
/* Operations */
//#define PUT_OP_MACRO(OP) op_codes[op_ptr++] = OP;
static void put_op( unsigned char op )
{
   //EGK I commented all this out since I disabled writing to disk.
#if 0
 if (loc_ptr > buff_size-5) /* every operation writes <5 locations */
  { loc_tape[buff_size-1]=buff_size-loc_ptr;
    put_locint_block(buff_size);
    /* olvo 980720 old: put_to_op(end_of_int); */
    if (op_ptr == buff_size-1) /* every operation writes 1 opcode */
    { op_codes[op_ptr] = end_of_op;
      put_op_block(buff_size);
      op_codes[op_ptr++] = end_of_op;
    }
    op_codes[op_ptr++] = end_of_int;
  }
  if (real_ptr > buff_size-5) /* every operation writes <5 constants */
  {                           /*  3 should be sufficient */
    put_locint(buff_size-real_ptr);
    put_val_block(buff_size);
    /* olvo 980720 old: put_to_op(end_of_val); */
    if (op_ptr == buff_size-1) /* every operation writes 1 opcode */
    { op_codes[op_ptr] = end_of_op;
      put_op_block(buff_size);
      op_codes[op_ptr++] = end_of_op;
    }
    op_codes[op_ptr++] = end_of_val;
  }
  /* olvo 980720 old: put_to_op(op); */
  if (op_ptr == buff_size-1) /* every operation writes 1 opcode */
  { op_codes[op_ptr] = end_of_op;
    put_op_block(buff_size);
    op_codes[op_ptr++] = end_of_op;
  }
#endif
  op_codes[op_ptr++] = op;
}

/*--------------------------------------------------------------------------*/
/* Values */
//#define PUT_VAL_MACRO(VAL) real_tape[real_ptr++] = VAL;
static inline void put_val( double r_val )
{ /* if (real_ptr == buff_size) put_val_block(buff_size); */
  real_tape[real_ptr++] = r_val;
}

static void put_vals_p( double *r_val, int size )
{ int j;
  for (j=0; j<size; j++)
    real_tape[real_ptr++] = r_val[j];
  put_locint(buff_size-real_ptr);
  put_val_block(buff_size);
  /* olvo 980720 old: put_to_op(end_of_val); */
  if (op_ptr == buff_size-1) /* every operation writes 1 opcode */
  { op_codes[op_ptr] = end_of_op;
    put_op_block(buff_size);
    op_codes[op_ptr++] = end_of_op;
  }
  op_codes[op_ptr++] = end_of_val;
}

static void put_vals_r( double *r_val, int size )
{ int j;
  for (j=0; j<size; j++)
    real_tape[real_ptr++] = r_val[j];
}

/*--------------------------------------------------------------------------*/
/* Update/correction of values or locations */
static void reset_val_r( void )
{ if (g_real_ptr == real_tape)
    get_val_block_r();
}

static inline int upd_resloc( locint temp, locint lhs )
{ int ret = 0;
  if (temp == loc_tape[loc_ptr-1])
  { loc_tape[loc_ptr-1]= lhs;
    ret = 1;
  }
  return ret;
}

/* olvo 991122: new routine */
static inline int upd_resloc_inc_prod( locint temp, locint newlhs, unsigned char newop )
{ int ret = 0;
  if (   (temp == loc_tape[loc_ptr-1]) 
      && (mult_a_a == op_codes[op_ptr-1]) 
      && (newlhs != loc_tape[loc_ptr-2])   /* skipping recursive case */
      && (newlhs != loc_tape[loc_ptr-3]))
  { loc_tape[loc_ptr-1]= newlhs;
    op_codes[op_ptr-1] = newop;
    ret = 1;
  }
  return ret;
}


/****************************************************************************/
/*                                                                    GETs  */

/*--------------------------------------------------------------------------*/
/* Operations */
static void get_op_block_f( void )
{ op_ptr = MIN_ADOLC(buff_size,op_len_ptr); 
  fread((char *)op_codes,op_ptr,1,op_file_out);
  op_len_ptr-= op_ptr;
  g_op_ptr = op_codes;
}

static void get_op_block_r( void )
{ fseek(op_file_out,op_file_cnt,0);
  fread((char *)op_codes,buff_size,1,op_file_out);
  op_file_cnt -= buff_size*sizeof(unsigned char);
  g_op_ptr = op_codes + buff_size;
}

/*--------------------------------------------------------------------------*/
/* Locations */
static void get_loc_block_f( void )
{ loc_ptr = MIN_ADOLC(buff_size,int_len_ptr);
  fread((char *)loc_tape,loc_ptr*sizeof(locint),1,int_file_out);
  int_len_ptr -= loc_ptr;
  g_loc_ptr = loc_tape;
}

static void get_loc_block_r( void )
{ fseek(int_file_out,int_file_cnt,0);
  fread((char *)loc_tape,buff_size*sizeof(locint),1,int_file_out);
  int_file_cnt -= buff_size*sizeof(locint);
  g_loc_ptr = loc_tape + buff_size-loc_tape[buff_size-1];
}

/*--------------------------------------------------------------------------*/
/* Values */
static int get_val_space( void )
{ if ((buff_size-real_ptr-5) < 0) 
  { put_locint(buff_size-real_ptr);
    put_val_block(buff_size);
    /* olvo980720 old: put_to_op(end_of_val); */
    if (op_ptr == buff_size-1) /* every operation writes 1 opcode */
    { op_codes[op_ptr] = end_of_op;
      put_op_block(buff_size);
      op_codes[op_ptr++] = end_of_op;
    }
    op_codes[op_ptr++] = end_of_val;
  } 
  return (buff_size - real_ptr - 5);
}

static void get_val_block_f( void )
{ real_ptr = MIN_ADOLC(val_len_ptr,buff_size);
  fread((char *)real_tape,real_ptr*sizeof(double),1,val_file_out);
  val_len_ptr -= real_ptr;
  g_real_ptr = real_tape;
  g_loc_ptr++; /* get_locint_f(); value used in reverse only */
}
    
static void get_val_block_r( void )
{ locint temp;
  fseek(val_file_out,val_file_cnt,0);
  fread((char *)real_tape,buff_size*sizeof(double),1,val_file_out);
  val_file_cnt -= buff_size*sizeof(double);
  temp = *(--g_loc_ptr);   /*get_locint_r();*/ 
  g_real_ptr = real_tape+buff_size-temp;
}

static double *get_val_v_f( locint size )
{ double *temp = g_real_ptr;
  g_real_ptr += size;
  return temp;
}

static double *get_val_v_r( locint size )
{ g_real_ptr -= size;
  return g_real_ptr;
}

/****************************************************************************/
/*                                                                    UTILs */
static double make_nan( void )
{ double a,b;
#ifdef inf_num
  a = non_num;
  b = non_den;
#endif 
  return a/b;
} 

static double make_inf( void )
{ double a,b;
#ifdef inf_num
  a = inf_num;
  b = inf_den;
#endif 
  return a/b;
}

/****************************************************************************/

END_C_DECLS



//@@@@@@ tayutil.c

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     drivers/drivers.h
 Revision: $Id: tayutil.c,v 1.6 2004/09/01 10:23:41 kowarz Exp $
 Contents: Taylor series utilities - primarily called from the module
           hos_forward.c (--- a forward pass generates taylor 
           coefficients which need to be saved when a variable dies, or 
           is overwritten) and the reverse modules (-- to retrieve these 
           taylor coefficients to calculate the adjoints.

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
   20040717 kowarz: "to many opened files" bug fixed (taylor_begin)
   20040607 kowarz: bug fixed in begin_taylor => ChangeLog
   20040417 kowarz: adapted to configure - make - make install
   20030317 andrea: pointer to current vs_data
   20030305 andrea: clean up for vs_data
   20030304 andrea: identify value stack by tag
   20010720 andrea: corrections is get_taylors_p(..) and write_taylors(..)
   20010715 andrea: add get_taylors_p(..)
   20010706 andrea: add write_taylors(..)
   19991122 olvo:   new op_codes eq_plus_prod eq_min_prod
                    for  y += x1 * x2
                    and  y -= x1 * x2
                    --> new: delete_scaylor(..)  
   19990816 olvo:   ec in get_taylors
   19990714 olvo:   performance tuning (get_taylors)
   19981201 olvo:   changed file name to tayutilc.c
   19980921 olvo:   new interface of void overwrite_scaylor(..) to
                    allow correction of old overwrite in store
   19980708 olvo:   (1) changed order in write_scaylor(..)
                        and              write_taylor(..)
                    (2) new:  void overwrite_scaylor(..)

----------------------------------------------------------------------------*/

//#include "taputil.h"
//#include "tayutil.h"
//#include "taputil_p.h"
//#include "tayutil_p.h"

//#include <errno.h>

BEGIN_C_DECLS

typedef struct{
 int tag;
 int numdep;
 int numind;
 int T_file_access;
 FILE* temp2_file;
 char vs_file_name[20];
 int taylor_cnt;
 revreal * save_taylor;
 int T_write_cnt;
 int T_blocks, 
           T_tail, 
           T_buf_size, 
           T_length; 
 double  **T;
 revreal **Tr;
 revreal  *Trs;
 int degsave;
} data_array;
   

/****************************************************************************/
/*                                       LOCAL VARIABLES (internal linkage) */

static data_array vs_data[TBUFNUM];
static data_array *cur_vs_data;
static int num_vs_data=0;

// EGK changed index to index__ so does not conflict
//static int index;
static int index__;

/****************************************************************************/
/*                                                          ACCESS ROUTINES */

/*--------------------------------------------------------------------------*/
/* Has a taylor file been written? */
static int taylor_access()
{ 
   if (cur_vs_data!=NULL) return cur_vs_data->T_file_access;
   else return 0;
}

/*--------------------------------------------------------------------------*/
/* Close any open taylor file. */
static void close_taylor()
{ fclose(cur_vs_data->temp2_file);
}

/****************************************************************************/
/*                                                           LOCAL ROUTINES */

/*--------------------------------------------------------------------------*/
/* T_Put_Block puts a block of tape to the disk.  I assume this 
   is called only during a successive forward pass, computation. */
static void T_put_block( int nitems )
{ int n;
  if (cur_vs_data->T_file_access == 0)
    cur_vs_data->temp2_file = fopen(cur_vs_data->vs_file_name,"w+b");
  if (cur_vs_data->T_write_cnt == 0)
    fseek(cur_vs_data->temp2_file,0,0); 
  cur_vs_data->T_file_access = 1;
  cur_vs_data->taylor_cnt = 0;
  if ((n=fwrite((char *)cur_vs_data->save_taylor,sizeof(revreal)*nitems,
                                         1,cur_vs_data->temp2_file)) != 1)
  { fprintf(DIAG_OUT,"ADOL-C error: fatal error-doing a write %d--- error %d\n",
                   n,errno);
    switch (errno) {
      case 28: /* ENOSPC */
	fprintf(DIAG_OUT,"No space left on device-contact sys. manager\n");
	break;
      case 27: /* EFBIG */
	fprintf(DIAG_OUT,"File to big-- Taylor-tape space exhausted.\n");
	break;
      default:
	fprintf(DIAG_OUT,"Unexpected error %d .\n",errno);
	break;
    }
    exit(-1);
  }
  cur_vs_data->T_write_cnt++;
}

/*--------------------------------------------------------------------------*/
/* Static function T_prev_block                                          
   called by taylor_back, taylor_back2, get_taylor, get_taylors    
   Gets the next (previous block) of size nitems  */
static int T_prev_block( int nitems )
{ int n;
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug: prev %d =nitems %d T_write_cnt \n",
          nitems, cur_vs_data->T_write_cnt);
#endif
  if (cur_vs_data->T_file_access)
  { if (cur_vs_data->T_write_cnt == 0)
      return 0;
    cur_vs_data->T_write_cnt--;
    fseek(cur_vs_data->temp2_file,cur_vs_data->T_buf_size*
          cur_vs_data->T_write_cnt*sizeof(revreal),0);
    n=fread((char *)cur_vs_data->save_taylor,sizeof(revreal),nitems,
            cur_vs_data->temp2_file);
    if (n != nitems)
    { fprintf(DIAG_OUT,"ADOL-C error: Read error on taylor file n= %d\n",n);
      return 0;
    }
    cur_vs_data->taylor_cnt = nitems;
    return 1;
  }
  return 0;
}


/****************************************************************************/
/*                                                            CONTROL STUFF */

/*--------------------------------------------------------------------------*/
/* Close the taylor file, reset data. */
static void taylor_close( int buffer, int dep, int ind)
{ 
   int n;

   if (buffer == -1)
      cur_vs_data->degsave = -1; /* enforces failure of reverse */
   cur_vs_data->numdep = dep;
   cur_vs_data->numind = ind;
   /* olvo 980708 changed to: ++.. */
   cur_vs_data->T_tail   = ++cur_vs_data->taylor_cnt;
   cur_vs_data->T_length = 
      cur_vs_data->T_buf_size*cur_vs_data->T_write_cnt+cur_vs_data->taylor_cnt;

   if (cur_vs_data->T_write_cnt)
   { 
      if (cur_vs_data->T_tail>0 ) 
	 T_put_block(cur_vs_data->T_tail);
      free((char *)cur_vs_data->save_taylor);
      cur_vs_data->save_taylor = 0;
   }

   cur_vs_data->T_blocks = cur_vs_data->T_write_cnt;

//EGK added static_cast to prevent compiler warning
   if ((cur_vs_data->T_blocks) && 
       (cur_vs_data->T_length*static_cast<int>(sizeof(revreal)) <= buffer)) 
   { 
      cur_vs_data->save_taylor = 
	 (revreal *) malloc(cur_vs_data->T_length*sizeof(revreal));

      if (cur_vs_data->save_taylor == NULL)
      { 
	 fprintf(DIAG_OUT,"ADOL-C error: cannot allocate taylor buffer!\n");
	 std::cout << __LINE__ << std::endl;
	 exit(-1);
      }

      fseek(cur_vs_data->temp2_file,0,0);

      n = fread((char *)cur_vs_data->save_taylor,sizeof(revreal),
		cur_vs_data->T_length,cur_vs_data->temp2_file);

      if ( n != cur_vs_data->T_length)
      { 
	 fprintf(DIAG_OUT,"ADOL-C error: read error in taylor_close n= %d\n",n);
	 exit(-2);
      }

      cur_vs_data->T_tail = cur_vs_data->T_length;
      cur_vs_data->T_blocks = 0;
   }

#if defined(ADOLC_DEBUG)
   if (cur_vs_data->T_blocks)
      fprintf(DIAG_OUT,
	      "\n ADOL-C debug: taylor file of length %d bytes completed\n",
	      (int)(cur_vs_data->T_length*sizeof(revreal)));
   else
      fprintf(DIAG_OUT,
	      "\n ADOL-C debug: taylor array of length %d bytes completed\n",
	      (int)(cur_vs_data->T_length*sizeof(revreal)));
#endif
}

/*--------------------------------------------------------------------------*/
/* Set up statics for writing taylor data */ 
static void taylor_begin( short tag, int buffer, double** Tg, int degree )
{ 
  index__ = 0;
  if (num_vs_data != 0)
   {
     while((vs_data[index__].tag != tag) && (index__<num_vs_data))
       index__++;
   }
  if (index__ >= num_vs_data)
    num_vs_data++;
  if (index__ >= TBUFNUM)
  { fprintf(DIAG_OUT,"ADOL-C error: to many taylor buffers!\n");
    fprintf(DIAG_OUT,"              Increase TBUFNUM\n");
    exit (-1);
  }
  cur_vs_data = &vs_data[index__];
  cur_vs_data->tag = tag;

  if(first_time) //EGK: added this
  {
  if (cur_vs_data->save_taylor)
    free((char *)cur_vs_data->save_taylor);
  }

  cur_vs_data->T_file_access = 0;
  /* 20040717 kowarz: added to fix problem "to many opened files" */
  if (cur_vs_data->temp2_file!=NULL) fclose(cur_vs_data->temp2_file);
  cur_vs_data->temp2_file = NULL;
  if(first_time)  //EGK added this
  {
     cur_vs_data->save_taylor = 0;
  }
  cur_vs_data->T = Tg;
  get_fstr(cur_vs_data->vs_file_name,tag,FNAME3);
  cur_vs_data->T_buf_size = 1+buffer/sizeof(revreal);

  if(first_time) //EGK added this
  {
     cur_vs_data->save_taylor =
	(revreal *)malloc(sizeof(revreal)*cur_vs_data->T_buf_size);
  }

  if (cur_vs_data->save_taylor == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate taylor buffer!\n");
    std::cout << __LINE__ << std::endl;
    exit (-1);
  }
  cur_vs_data->T_write_cnt = 0;
  cur_vs_data->T_length    = 0;
  cur_vs_data->taylor_cnt  = 0; 
  cur_vs_data->degsave     = degree;
}


/*--------------------------------------------------------------------------*/
static void taylor_back2(int tag, revreal** Trg, int* dep, int* ind, int* degree)
{ 
  index__ = 0;
  if (num_vs_data != 0)
   {
     while((vs_data[index__].tag != tag) && (index__<num_vs_data))
       index__++;
   }
  if (index__ >= num_vs_data)
  { fprintf(DIAG_OUT,"ADOL-C error: no taylor buffer for this tag \n");
    exit(-2);
  }
  cur_vs_data = &vs_data[index__];
  *dep    = cur_vs_data->numdep;
  *ind    = cur_vs_data->numind;
  *degree = cur_vs_data->degsave;
  cur_vs_data->Tr = Trg;
  cur_vs_data->T_write_cnt = cur_vs_data->T_blocks;
  cur_vs_data->taylor_cnt  = cur_vs_data->T_tail;
  if (cur_vs_data->T_blocks == 0 && cur_vs_data->save_taylor == 0 )
  { fprintf(DIAG_OUT,"ADOL-C error: no temp file or array for reverse sweep \n");
    exit(-2);
  }
  if (cur_vs_data->T_blocks)
  { if (cur_vs_data->save_taylor)
      free((char*) cur_vs_data->save_taylor);
    cur_vs_data->save_taylor = (revreal*) malloc(cur_vs_data->T_buf_size*sizeof(revreal));
    if (cur_vs_data->save_taylor == NULL)
    { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate taylor buffer!\n");
      std::cout << __LINE__ << std::endl;
      exit (-1);
    } 
    if (T_prev_block(cur_vs_data->T_tail) == 0) 
      fprintf(DIAG_OUT,"ADOL-C error: problems in taylorback2 \n");
  }
}

/*--------------------------------------------------------------------------*/
static void taylor_back( int tag, revreal* Trg, int* dep, int* ind, int* degree)
{ 
   index__ = 0;
   if (num_vs_data != 0)
   {
      while((vs_data[index__].tag != tag) && (index__<num_vs_data))
	 index__++;
   }
   if (index__ >= num_vs_data)
   {
      fprintf(DIAG_OUT,"ADOL-C error: no taylor buffer for this tag \n");
      exit(-2);
   }
   cur_vs_data = &vs_data[index__];
   *dep    = cur_vs_data->numdep;
   *ind    = cur_vs_data->numind;
   *degree = cur_vs_data->degsave;
   cur_vs_data->Trs = Trg;
   cur_vs_data->T_write_cnt = cur_vs_data->T_blocks;
   cur_vs_data->taylor_cnt  = cur_vs_data->T_tail;
   if (cur_vs_data->T_blocks == 0 && cur_vs_data->save_taylor == 0 )
   { 
      fprintf(DIAG_OUT,
	      "ADOL-C error: no temp file or array for reverse sweep \n");
      exit(-2);
   }
   if (cur_vs_data->T_blocks)
   { 
      if (cur_vs_data->save_taylor)
	 free((char*) cur_vs_data->save_taylor);
      cur_vs_data->save_taylor =
	 (revreal*) malloc(cur_vs_data->T_buf_size*sizeof(revreal));
      if (cur_vs_data->save_taylor == NULL)
      { 
	 fprintf(DIAG_OUT,"ADOL-C error: cannot allocate taylor buffer!\n");
	 std::cout << __LINE__ << std::endl;
	 exit (-1);
      } 
      if (T_prev_block(cur_vs_data->T_tail) == 0)
	 fprintf(DIAG_OUT,"ADOL-C error: problems in taylor_back \n");
   }
}


/****************************************************************************/
/*                                                                   WRITEs */

/*--------------------------------------------------------------------------*/
/* Write_taylor writes the block of size depth of taylor coefficients  
   from point loc to the taylor buffer.  If the buffer is filled, then 
   it is written to the taylor tape (T_put_block). */
static void write_taylor( locint loc, int depth )
{ int i;
  double* Tloc = cur_vs_data->T[loc];
  for (i=0;i<depth;i++)
  { /* olvo 980708 changed order */
    if ((++cur_vs_data->taylor_cnt) == cur_vs_data->T_buf_size) 
      T_put_block(cur_vs_data->T_buf_size);
    cur_vs_data->save_taylor[cur_vs_data->taylor_cnt]=*Tloc++;          
                                 /* In this assignment the */
                                 /* precision will be sacrificed if the */
                                 /* type revreal is defined as float.   */
  }
}

/*--------------------------------------------------------------------------*/
/* Write_taylor writes the block of size depth of taylor coefficients  
   from point loc to the taylor buffer.  If the buffer is filled, then 
   it is written to the taylor tape (T_put_block). */
static void write_taylors( locint loc, int depth, int k, int nrows )
{ int i,j;
  double* Tloc = cur_vs_data->T[loc];
  for (j=0;j<nrows;j++)
  {
   for (i=0;i<depth;i++)
   { /* olvo 980708 changed order */
     if ((++cur_vs_data->taylor_cnt) == cur_vs_data->T_buf_size) 
       T_put_block(cur_vs_data->T_buf_size);
     cur_vs_data->save_taylor[cur_vs_data->taylor_cnt]=*Tloc++;          
                                  /* In this assignment the */
                                  /* precision will be sacrificed if the */
                                  /* type revreal is defined as float.   */
   }
   for(i=depth;i<k;i++)
   {  
       *Tloc++;
   }
  }
}

/*--------------------------------------------------------------------------*/
/* Overwrite_scaylor overwrites the last (single) element (x) of the       
   taylor buffer.  New by olvo 980708;
   changed interface since 980921 to allow correction of
   old overwrite in store */
static void overwrite_scaylor( revreal newVal, revreal* oldVal )
{ *oldVal = cur_vs_data->save_taylor[cur_vs_data->taylor_cnt];
  cur_vs_data->save_taylor[cur_vs_data->taylor_cnt] = newVal;
}

/*--------------------------------------------------------------------------*/
/* Delete_scaylor deletes the last (single) element (x) of the
   taylor buffer.  New by olvo 981122 */
static void delete_scaylor( revreal* oldVal )
{ *oldVal = cur_vs_data->save_taylor[cur_vs_data->taylor_cnt--];
}

/*--------------------------------------------------------------------------*/
/* Write_scaylor writes a single element (x) to the taylor buffer.  If full
   the buffer is written out. */
//#define WRITE_SCAYLOR_MACRO(X) cur_vs_data->save_taylor[++cur_vs_data->taylor_cnt]=X;
static inline void write_scaylor( revreal x )
{ /* olvo 980708 changed order */
//  if ((++cur_vs_data->taylor_cnt) == cur_vs_data->T_buf_size) 
//    T_put_block(cur_vs_data->T_buf_size);
//  cur_vs_data->save_taylor[cur_vs_data->taylor_cnt]= x;

   // modified by EGK to avoid writing to disk
  cur_vs_data->save_taylor[++cur_vs_data->taylor_cnt]= x;
}


/*--------------------------------------------------------------------------*/
/* Write_scaylors writes # size elements from x to the taylor buffer.
   If full, the buffer is written out. */
static inline void write_scaylors(double *x, int size)
{ int i;
  for(i=0; i<size; i++)
  { /* olvo 980708 changed order */
   // modified by EGK to avoid writing to disk
//    if ((++cur_vs_data->taylor_cnt) == cur_vs_data->T_buf_size)
//      T_put_block(cur_vs_data->T_buf_size);
//    cur_vs_data->save_taylor[cur_vs_data->taylor_cnt]= x[i];

    cur_vs_data->save_taylor[++cur_vs_data->taylor_cnt]= x[i];
  }
}


/****************************************************************************/
/*                                                                     GETs */

/*--------------------------------------------------------------------------*/
static void get_taylors( locint loc, int depth)
{ int i;
  revreal* Trloc = cur_vs_data->Tr[loc];
  for (i=depth-1;i >= 0;i--)
  { if (cur_vs_data->taylor_cnt == 0)
      if (!T_prev_block(cur_vs_data->T_buf_size))
      { fprintf(stderr,"ADOL-C error: Fatal Error in get_taylors ");
	exit(-1);
      }
    Trloc[i] = cur_vs_data->save_taylor[--cur_vs_data->taylor_cnt];
  }
}

/*--------------------------------------------------------------------------*/
static void get_taylors_p( locint loc, int depth, int p)
{ int i,j,cnt,base;
  revreal* Trloc = cur_vs_data->Tr[loc];
  
  cnt=p*depth-1;
  base = cur_vs_data->taylor_cnt-cnt-1;
  for (j=p;j > 0;j--)
  {
   for (i=depth-1;i > 0;i--)
   { if (cur_vs_data->taylor_cnt == 0)
        if (!T_prev_block(cur_vs_data->T_buf_size))
        { fprintf(stderr,"ADOL-C error: Fatal Error in get_taylors ");
          exit(-1);
        }
    Trloc[cnt--] = cur_vs_data->save_taylor[--cur_vs_data->taylor_cnt];  /* directions */
   }
   cnt--;
  }
  if (cur_vs_data->taylor_cnt == 0)  
    if (!T_prev_block(cur_vs_data->T_buf_size))
     { fprintf(stderr,"ADOL-C error: Fatal Error in get_taylors ");
       exit(-1);
     }
   Trloc[0] = cur_vs_data->save_taylor[--cur_vs_data->taylor_cnt]; /* base point */
   for(j=1;j<p ;j++)
    Trloc[j*depth] = cur_vs_data->save_taylor[cur_vs_data->taylor_cnt];
   
}

/*--------------------------------------------------------------------------*/
static inline void get_taylor( locint loc )
{ 
// EGK: modified so that no writing to disk occurs   
/*  if (cur_vs_data->taylor_cnt == 0)
  { if (!T_prev_block(cur_vs_data->T_buf_size))
    { fprintf(stderr,"ADOL-C error: Fatal Error in get_taylor ");
      exit(-1);
    }
    }*/
  cur_vs_data->Trs[loc] = cur_vs_data->save_taylor[--cur_vs_data->taylor_cnt];
}

/****************************************************************************/
/*                                                       DEALLOCATE VS_DATA */

static void clean_vs_data( int tag )
{
  int i;
  index__ = 0;
  if (num_vs_data != 0)
   {
     while((vs_data[index__].tag != tag) && (index__<num_vs_data))
       index__++;
   }
  if (index__ >= num_vs_data)
  { fprintf(DIAG_OUT,"ADOL-C error: no taylor buffer for this tag \n");
    exit(-2);
  }
  printf(" tag = %d index__ = %d \n",tag,index__);
 free((char*) vs_data[index__].save_taylor);
 for(i=index__;i<num_vs_data-1;i++)
   vs_data[index__] = vs_data[index__+1];
 free((char*) vs_data[num_vs_data-1].save_taylor);
 num_vs_data--;
}

/****************************************************************************/
/*                                                               THAT'S ALL */

END_C_DECLS




//@@@@@@@  adouble.cpp

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     adouble.cpp
 Revision: $Id: adouble.cpp,v 1.2 2004/05/24 10:50:28 kowarz Exp $
 Contents: adouble.C contains that definitions of procedures used to 
           define various badouble, adub, asub and adouble operations. 
           These operations actually have two purposes.
           The first purpose is to actual compute the function, just as 
           the same code written for double precision (single precision -
           complex - interval) arithmetic would.  The second purpose is 
           to write a transcript of the computation for the reverse pass 
           of automatic differentiation.

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20040423 kowarz: adapted to configure - make - make install
          20020705 olvo:   (1) free_loc used in destructors
                           (2) current_top instead of location_cnt in
                           would be good, but is impossible!
          19991210 olvo:   checking the changes
          19991122 olvo:   new op_codes eq_plus_prod eq_min_prod
                           for  y += x1 * x2
                           and  y -= x1 * x2  
          19981130 olvo:   last check (includes ...)
          19981119 olvo:   changed tanh as J.M. Aparicio suggested
          19981020 olvo:   skip upd_resloc(..) if no tracing performed
          19980924 olvo:   changed all int_* opcodes
          19980921 olvo:   (1) changed save-order in sin/cos
                           (2) new interface in call to
                               void overwrite_scaylor(..) which
                               allows correction of old overwrite in store
          19980820 olvo:   new comparison strategy
          19980721 olvo:   write of taylors in subscript
          19980713 olvo:   elimination of "writes" from taputil1.c completed
          19980710 olvo:   sin/cos writes 2 taylors
          19980709 olvo:   elimination of "writes" from taputil1.c
          19980708 olvo:   new: write_upd(..)
          19980707 olvo:   taping with keep
          19980706 olvo:   new operation code: incr_a
                                               decr_a
          19980623 olvo:   griewank's idea -- stock manipulation
          19980518 olvo:   griewank's idea -- write_death(..) killed
          19980517 olvo:   griewank's idea -- operator:
                           adouble& adouble::operator = (const adub& a)

----------------------------------------------------------------------------*/

//#include "adouble.h"
//#include "adouble_p.h"
//#include "oplate.h"
//#include "taputil.h"
//#include "taputil_p.h"
//#include "tayutil.h"
//#include "tayutil_p.h"

//#include <math.h>
//#include <errno.h>

/****************************************************************************/
/*                                                        HELPFUL FUNCTIONS */

/*--------------------------------------------------------------------------*/
static inline void condassign( double &res, const double &cond, 
                 const double &arg1, const double &arg2 )
{ res = cond ? arg1 : arg2;
}

/*--------------------------------------------------------------------------*/
static inline void condassign( double &res, const double &cond, 
                 const double &arg)
{ res = cond ? arg : res;
}

/*--------------------------------------------------------------------------*/
static inline double fmax( const double &x, const double &y )
{ if (y > x) 
    return y;  
  else 
    return x; 
}

/*--------------------------------------------------------------------------*/
static inline double fmin( const double &x, const double &y )
{ if (y < x) 
    return y;
  else 
    return x;
}

/****************************************************************************/
/*                                                              GLOBAL VARS */

/*--------------------------------------------------------------------------*/
ADOLC_DLL_EXPORT double* store;                      // = double stack
int trace_flag             = 0;

/*--------------------------------------------------------------------------*/
/*static*/ locint maxloc       = sizeof(locint) ==2 ? 65535 : 2147483647;
/*static*/ locint current_top  = 0;     // = largest live location + 1
/*static*/ locint location_cnt = 0;     // = maximal # of lives so far
/*static*/ locint maxtop       = 0;     // = current size of store
/*static*/ locint maxtop2;
/*static*/ locint dealloc      = 0;     // = # of locations to be freed
/*static*/ locint deminloc     = 0;     // = lowest loc to be freed 


bool check_lifo = false;

/****************************************************************************/
/*                                                         MEMORY MANAGMENT */

/*--------------------------------------------------------------------------*/
/* Return the next free location in "adouble" memory */
locint next_loc()
{ /* First deallocate dead adoubles if they form a contiguous tail: */
#ifdef overwrite
  if (dealloc && dealloc+deminloc == current_top)    
  { /* olvo 980518 deleted write_death (see version griewank) */
    // if (trace_flag) 
    //   write_death(deminloc, current_top - 1);
    current_top = deminloc ;
    dealloc     = 0; 
    deminloc    = maxloc;
  }

  //EGK begin
  else if (dealloc)// && dealloc+deminloc != current_top)
  {
     std::cout << "Error: All adouble variables must be allocated and "
	"deallocated in a last in first out basis. You appear to "
	"be violating this LIFO rule." << std::endl;
     std::cout << "dealloc: " << dealloc << "\n";
     std::cout << "deminloc: " << deminloc << "\n";
     std::cout << "current_top: " << current_top << "\n";
     abort();
  }
  //EGK end
#endif
  if (current_top == location_cnt)
  {
    ++location_cnt;
    /* Begin EGK */
    if(currently_in_initial_timestep == 0)
    {
       printf("Fatal error: attempt to add more adoubles "
	      "after initial timestep");
       abort();
     }
    /* End EGK */
  }
  if (location_cnt > maxtop) 
  { maxtop2 = ++maxtop*2 > maxloc ? maxloc : 2*maxtop;
    if (maxtop2 == maxloc)
    { fprintf(DIAG_OUT,"\nADOL-C error:\n");
      fprintf(DIAG_OUT,"maximal number (%d) of live active variables exceeded\n\n", maxloc);
      fprintf(DIAG_OUT,"Possible remedies :\n\n");
      fprintf(DIAG_OUT," 1. Use more automatic local variables and \n");
      fprintf(DIAG_OUT,"    allocate/deallocate adoubles on free store\n");
      fprintf(DIAG_OUT,"     in a strictly last in first out fashion\n\n");
      fprintf(DIAG_OUT," 2. Extend the range by redefining the type of \n");
      fprintf(DIAG_OUT,"    locint (currently %d byte) from unsigned short (%d byte)  or int \n", sizeof(locint),sizeof(unsigned short));
      fprintf(DIAG_OUT,"    to int (%d byte) or long (%d byte). \n",sizeof(int),sizeof(long));
      exit(-3);
    }
    else
    { maxtop = maxtop2;
      if (maxtop == 2)
      { store = (double *)malloc(maxtop*sizeof(double));
	deminloc = maxloc;
      }
      else
        store = (double *)realloc((char *)store,maxtop*sizeof(double));
      if (store == 0) 
      { fprintf(DIAG_OUT,"\nADOL-C error:\n");
  	fprintf(DIAG_OUT,"Failure to reallocate storage for adouble values\n");
	fprintf(DIAG_OUT,"Possible remedies :\n\n");
       	fprintf(DIAG_OUT," 1. Use more automatic local variables and \n");
	fprintf(DIAG_OUT,"    allocate/deallocate adoubles on free store\n");
	fprintf(DIAG_OUT,"    in a strictly last in first out fashion\n");
	fprintf(DIAG_OUT," 2. Enlarge your system stacksize limit\n");
	std::cout << "maxtop: " << maxtop << std::endl;
	std::cout << "location_cnt: " << location_cnt << std::endl;
	exit(-3);
      }
    }
  }
  return current_top++;
}


/*--------------------------------------------------------------------------*/
/* Return the next #size free locations in "adouble" memory */
static locint next_loc( int size )
{ /* First deallocate dead adoubles if they form a contiguous tail: */
#ifdef overwrite
  if (dealloc && dealloc+deminloc == current_top)    
  { /* olvo 980518 deleted write_death (see version griewank) */
    // if (trace_flag)
    //   write_death(deminloc, current_top - 1);
    current_top = deminloc ;
    dealloc     = 0; 
    deminloc    = maxloc;
  }

  //EGK begin
  else if (dealloc)// && dealloc+deminloc != current_top)
  {
     std::cout << "Error: All adouble variables must be allocated and "
	"deallocated in a last in first out basis. You appear to "
	"be violating this LIFO rule." << std::endl;
     std::cout << "dealloc: " << dealloc << "\n";
     std::cout << "deminloc: " << deminloc << "\n";
     std::cout << "current_top: " << current_top << "\n";
     abort();
  }
  //EGK end
#endif
  if ((current_top+size) >= location_cnt) 
  {
    location_cnt = current_top+size+1;
    /* Begin EGK */
    if(currently_in_initial_timestep == 0)
    {
       printf("Fatal error: attempt to add more adoubles "
	      "after initial timestep");
       abort();
     }
    /* End EGK */
  }
  while (location_cnt > maxtop) 
  { maxtop2 = ++maxtop*2 > maxloc ? maxloc : 2*maxtop;
    if (maxtop2 == maxloc)
    { fprintf(DIAG_OUT,"\nADOL-C error:  \n");
      fprintf(DIAG_OUT,"maximal number (%d) of live active variables exceeded\n\n", maxloc);
      fprintf(DIAG_OUT,"Possible remedies :\n\n");
      fprintf(DIAG_OUT," 1. Use more automatic local variables and \n");
      fprintf(DIAG_OUT,"    allocate/deallocate adoubles on free store\n");
      fprintf(DIAG_OUT,"    in a strictly last in first out fashion\n\n");
      fprintf(DIAG_OUT," 2. Extend the range by redefining the type of \n");
      fprintf(DIAG_OUT,"    locint (currently %d byte) from unsigned short (%d byte)  or int \n", sizeof(locint),sizeof(unsigned short));
      fprintf(DIAG_OUT,"    to int (%d byte) or long (%d byte). \n",sizeof(int),sizeof(long));
      exit(-3);
    }
    else
    { maxtop = maxtop2;
      if (maxtop == 2)
      { store = (double *)malloc(maxtop*sizeof(double));
	deminloc = maxloc;
      }
      else
      { /* Allocate the storage */
	double *temp;
	temp = (double *)malloc(maxtop*sizeof(double));
	if(temp == NULL)
        { fprintf(DIAG_OUT,"\nADOL-C error: cannot allocate %i bytes\n",maxtop*sizeof(double));
          exit (-1);
        }
        /* Copy over storage */
	for (unsigned int i=0; i<current_top; i++)
	  temp[i]=store[i];
        free((char*) store);
        store = temp;
      }
      if (store == 0) 
      { fprintf(DIAG_OUT,"\nADOL-C error:\n");
  	fprintf(DIAG_OUT,"Failure to reallocate storage for adouble values\n");
	fprintf(DIAG_OUT,"Possible remedies :\n\n");
       	fprintf(DIAG_OUT," 1. Use more automatic local variables and\n");
	fprintf(DIAG_OUT,"    allocate/deallocate adoubles on free store\n");
	fprintf(DIAG_OUT,"    in a strictly last in first out fashion\n");
	fprintf(DIAG_OUT," 2. Enlarge your system stacksize limit\n");
	std::cout << "maxtop: " << maxtop << std::endl;
	std::cout << "location_cnt: " << location_cnt << std::endl;
	exit(-3);
      }
    }
  }
#if defined(ADOLC_DEBUG)
  fprintf (DIAG_OUT,"ADOL-C debug: Top is: %d\n ",current_top+size);
#endif
  locint return_val = current_top;
  current_top += size;
  return return_val;
}

/*--------------------------------------------------------------------------*/
/* Free a location in "adouble" memory */
// EGK moved to adolc.h
//inline void free_loc( locint old_loc )
//{ ++dealloc;
//  if (old_loc < deminloc)
//    deminloc = old_loc;
//}

/*--------------------------------------------------------------------------*/
/* Free #size locations in "adouble" memory */
static void free_loc( locint old_loc, int size )
{ dealloc+=size;
  if (old_loc < deminloc)
    deminloc = old_loc ;


  // EGK
  /*
  if (check_lifo && dealloc+deminloc != current_top)
  {
     std::cout << "Error: All adouble variables must be allocated and "
	"deallocated in a last in first out basis. You appear to "
	"be violating this LIFO rule." << std::endl;
  std::cout << "old_loc: " << old_loc << "\n";
  std::cout << "dealloc: " << dealloc << "\n";
  std::cout << "deminloc: " << deminloc << "\n";
  std::cout << "current_top: " << current_top << "\n";
     abort();
  }
  */

}
  
/****************************************************************************/
/*                                                       STOCK MANIPULATION */

/*--------------------------------------------------------------------------*/
/* olvo 980623 version griewank */
static void take_stock()
{
#ifdef TAPE_DOC /* olvo 980709 ??? this case might be useless */
  for (int res =0; res< current_top; res++) 
  { double coval = store[res];   // Avoid I/O of NaN's !
    if (coval == coval) 
    { // old: write_int_assign_d(res,coval);
      if (coval == 0)
      { put_op(assign_d_zero);
        put_locint(res);
      }
      else
        if (coval == 1.0)
        { put_op(assign_d_one);
          put_locint(res);
        }
        else
        { put_op(assign_d);
          put_locint(res);
          put_val(coval);
        }
 
      ++vs_ptr; 
//      if (revalso)
        write_scaylor(store[res]);
    }
  }
#else /* usual case */
  // old: write_take_stock(current_top,store);
  locint space_left,
         vals_left = current_top,
         loc       = 0;
  double *vals     = store;
  space_left       = get_val_space();
  while (space_left < vals_left)
  { put_op(take_stock_op);
    put_locint(space_left);
    put_locint(loc);
    put_vals_p(vals,space_left);
    vals      += space_left;
    vals_left -= space_left;
    loc       += space_left;
    space_left = get_val_space();
  }
  if (vals_left > 0)
  { put_op(take_stock_op);
    put_locint(vals_left);
    put_locint(loc);
    put_vals_r(vals,vals_left);
  }
#endif
  trace_flag = 1;
}

/*--------------------------------------------------------------------------*/
/* olvo 980623 version griewank */
static locint keep_stock()
{ if (location_cnt > 0) 
  { // old: write_death(0,location_cnt - 1);
    locint loc2 = location_cnt - 1;

    put_op(death_not);
    put_locint(0);
    put_locint(loc2);

    vs_ptr += location_cnt;
//    if (revalso) 
      do 
        write_scaylor(store[loc2]);
      while(loc2-- > 0);
  }
  trace_flag = 0;
  return location_cnt;
}

/*----------------------------------------------------------------*/
/* The remaining routines define the badouble,adub,and adouble    */
/* routines.                                                      */
/*----------------------------------------------------------------*/

/****************************************************************************/
/*                                                             CONSTRUCTORS */

/*--------------------------------------------------------------------------*/
/* just a comment:
adub::adub( double coval )
{ location = next_loc();

  if (trace_flag) 
  { // old: write_int_assign_d(location,coval);
    if (coval == 0)
    { put_op(assign_d_zero);
      put_locint(location);   // = res
    }
    else
      if (coval == 1.0)
      { put_op(assign_d_one);
        put_locint(location); // = res
      }
      else
      { put_op(assign_d);
        put_locint(location); // = res
        put_val(coval);       // = coval
      }

    ++vs_ptr; 
    //if (revalso)  
      write_scaylor(store[location]);
  }

  store[res] = coval;
}
*/

/*--------------------------------------------------------------------------*/
adouble::adouble()
{ location = next_loc();
}

/*--------------------------------------------------------------------------*/
adouble::adouble( double coval )
{ location = next_loc();

  if (trace_flag) 
  { // old:  write_int_assign_d(location,coval);
    if (coval == 0)
    { put_op(assign_d_zero);
      put_locint(location);   // = res
    }
    else
      if (coval == 1.0)
      { put_op(assign_d_one);
        put_locint(location); // = res
      }
      else
      { put_op(assign_d);
        put_locint(location); // = res
        put_val(coval);       // = coval
      }

    ++vs_ptr; 
    //if (revalso)  
      write_scaylor(store[location]);
  }

  store[location] = coval;
}

/*--------------------------------------------------------------------------*/
adouble::adouble( const adouble& a )
{ location = next_loc();

  if (trace_flag) 
  { // old: write_int_assign_a(location,a.location);
    put_op(assign_a);
    put_locint(a.location);   // = arg
    put_locint(location);     // = res
  
    ++vs_ptr; 
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location] = store[a.location];
}

/*--------------------------------------------------------------------------*/
adouble::adouble( const adub& a )
{ location = next_loc();

  if (trace_flag) 
  { // old:  write_int_assign_a(location,a.loc());
    put_op(assign_a);
    put_locint(a.loc());  // = arg
    put_locint(location); // = res
  
    ++vs_ptr; 
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location] = store[a.loc()];
}

/*--------------------------------------------------------------------------*/
adouble::adouble( const along& a )
{ location = next_loc();

  if (trace_flag) 
  { // old: write_int_assign_a(location,a.loc());
    put_op(assign_a);
    put_locint(a.loc());  // = arg
    put_locint(location); // = res
  
    ++vs_ptr; 
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location] = store[a.loc()];
}

/****************************************************************************/
/*                                                              DESTRUCTORS */

#ifdef overwrite
/*--------------------------------------------------------------------------*/
adouble::~adouble()
{ free_loc(location);
}

/*--------------------------------------------------------------------------*/
// EGK made inline
//adub::~adub()
//{ free_loc(location);
//}

/*--------------------------------------------------------------------------*/
asub::~asub()
{ free_loc(location);
}

/*--------------------------------------------------------------------------*/
along::~along()
{ free_loc(location);
}
#endif


/****************************************************************************/
/*                                                                   VALUE */

/*--------------------------------------------------------------------------*/
//double badouble::value() const
//{
//  return store[location];
//}

/****************************************************************************/
/*                                                              ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
/* Assign an adouble variable a constant value. */
badouble& badouble::operator_equal ( double coval ) 
{ //if (trace_flag) 
  { // old:  write_assign_d(location,coval);
    if (coval == 0)
    { put_op(assign_d_zero);
      put_locint(location);   // = res
    }
    else
      if (coval == 1.0)
      { put_op(assign_d_one);
        put_locint(location); // = res
      }
      else
      { put_op(assign_d);
        put_locint(location); // = res
        put_val(coval);       // = coval
      }

    ++vs_ptr; 
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location] = coval;
  return *this;
}   

/*--------------------------------------------------------------------------*/
/* Assign an adouble variable a constant value. */
//adouble& adouble::operator = ( double coval ) 
//{ (*this).badouble::operator=(coval);
//  return (*this);
//}

/*--------------------------------------------------------------------------*/
/* Assign an adouble variable to an independent value. */
badouble& badouble::operator <<= ( double coval ) 
{ if (trace_flag) 
  { // old:  write_assign_ind(location);
    ind_ptr++;

    put_op(assign_ind);
    put_locint(location); // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[location]);
  }
 
  store[location] = coval;
  return *this;
}   

/*--------------------------------------------------------------------------*/
/* Assign a float variable from a dependent adouble value. */
badouble& badouble::operator >>= ( double& coval ) 
{ if (trace_flag) 
  { // old:  write_assign_dep(location);
    dep_ptr++;

    put_op(assign_dep);
    put_locint(location); // = res
  }

  coval = double (store[location]);
  return *this;
}   

/*--------------------------------------------------------------------------*/
/* Assign an Badouble variable an Badouble value. */
badouble& badouble::operator_equal ( const badouble& x ) 
{ locint x_loc = x.loc();
  if (location!=x_loc)  
  /* test this to avoid for x=x statements adjoint(x)=0 in reverse mode */
  { //if (trace_flag) 
    { // old:  write_assign_a(location,x.location);
      put_op(assign_a);
      put_locint(x_loc);    // = arg
      put_locint(location);   // = res

      ++vs_ptr;
      //if (revalso)
        write_scaylor(store[location]);
    }

    store[location]=store[x_loc];
  } 
  return *this;
}  

/*--------------------------------------------------------------------------*/
/* Assign an Badouble variable an Badouble value. */
//adouble& adouble::operator = ( const badouble& x ) 
//{ (*this).badouble::operator=(x);
//  return (*this);
//}

/*--------------------------------------------------------------------------*/
/* Assign an adouble an adub */
/* olvo 980517 new version griewank */
badouble& badouble::operator_equal ( const adub& a )
{ locint a_loc = a.loc();
  //int upd = 0;
  /* 981020 olvo  skip upd_resloc(..) if no tracing performed */
  //if (trace_flag)
    int upd = upd_resloc(a_loc,location);
  if (upd)
  { /* olvo 980708 new n2l & 980921 changed interface */
    revreal tempVal = store[a_loc];
    //if (revalso) 
      overwrite_scaylor(store[location],&store[a_loc]); 
    if (a_loc == current_top-1)
    { current_top--;     // The temporary will die in a minute and
      dealloc--;         // by reducing dealloc and current_top 
    }                    // we neutralize that effect
    store[location] = tempVal;
  }
  else
  { //if (trace_flag)
    { // old: write_assign_a(location,a_loc);
      put_op(assign_a);
      put_locint(a_loc);    // = arg
      put_locint(location); // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[location]);
    }
    store[location] = store[a_loc];
  }

  return *this;
}

/*--------------------------------------------------------------------------*/
/* Assign an adouble an adub */
/* olvo 980517 new version griewank */
//adouble& adouble::operator = ( const adub& a )
//{ (*this).badouble::operator=(a);
//  return (*this);
//}


/****************************************************************************/
/*                                                           INPUT / OUTPUT */

/*--------------------------------------------------------------------------*/
/* Output an adouble value !!! No tracing of this action */
std::ostream& operator << ( std::ostream& out, const badouble& y )
{ return out << store[y.location] << "(a)" ;
}

/*--------------------------------------------------------------------------*/
/* Input adouble value */
std::istream& operator >> ( std::istream& in, const badouble& y )
{ double coval;
  in >> coval;
  if (trace_flag) 
  { // old: write_assign_d(y.location,coval);
    if (coval == 0)
    { put_op(assign_d_zero);
      put_locint(y.location);   // = res
    }
    else
      if (coval == 1.0)
      { put_op(assign_d_one);
	put_locint(y.location); // = res
      }
      else
      { put_op(assign_d);
      put_locint(y.location);   // = res
        put_val(coval);         // = coval
      }

    ++vs_ptr; 
    //if (revalso)  
      write_scaylor(store[y.location]);
  }

  store[y.location] = coval;
  return in;
}
  
/****************************************************************************/
/*                                                    INCREMENT / DECREMENT */

/*--------------------------------------------------------------------------*/
/* Postfix increment */
adub adouble::operator++( int ) 
{ locint locat = next_loc();

  if (trace_flag) 
  { // old: write_assign_a(locat,location);
    put_op(assign_a);
    put_locint(location); // = arg
    put_locint(locat);    // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat]=store[location];

  if (trace_flag) 
  { // old: write_incr_decr_a(incr_a,location);
    put_op(incr_a);
    put_locint(location); // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location]++;
  return locat;
}

/*--------------------------------------------------------------------------*/
 /* Postfix decrement */
adub adouble::operator--( int )
{ locint locat = next_loc();

  if (trace_flag) 
  { // old: write_assign_a(locat,location);
    put_op(assign_a);
    put_locint(location); // = arg
    put_locint(locat);    // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat]=store[location];
  if (trace_flag) 
  { // old: write_incr_decr_a(decr_a,location);
    put_op(decr_a);
    put_locint(location); // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location]--;
  return locat;
}

/*--------------------------------------------------------------------------*/
 /* Prefix increment */
badouble& adouble::operator++()
{ if (trace_flag) 
  { // old: write_incr_decr_a(incr_a,location);
    put_op(incr_a);
    put_locint(location); // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location]++;
  return *this;
}

/*--------------------------------------------------------------------------*/
/* Prefix decrement */
badouble& adouble::operator--()
{ if (trace_flag) 
  { // old: write_incr_decr_a(decr_a,location);
    put_op(decr_a);
    put_locint(location); // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location]--;
  return *this;
}

/****************************************************************************/
/*                                                   OPERATION + ASSIGNMENT */

/*--------------------------------------------------------------------------*/
/* Adding a floating point to an adouble */
badouble& badouble::operator_plus_equal ( double coval ) 
{// if (trace_flag) 
  { // old: write_d_same_arg(eq_plus_d,location,coval);
    put_op(eq_plus_d);
    put_locint(location); // = res
    put_val(coval);       // = coval

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] += coval;
  return *this; 
} 


/*--------------------------------------------------------------------------*/
/* Subtracting a floating point from an adouble */
badouble& badouble::operator_minus_equal ( double coval ) 
{// if (trace_flag) 
  { // old: write_d_same_arg(eq_min_d,location,coval);
    put_op(eq_min_d);
    put_locint(location); // = res
    put_val(coval);       // = coval

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] -= coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
/* Add an adouble to another adouble */
badouble& badouble::operator_plus_equal ( const badouble& y ) 
{ locint y_loc = y.loc();
  //if (trace_flag) 
  { // old: write_a_same_arg(eq_plus_a,location,y.location);
    put_op(eq_plus_a);
    put_locint(y_loc); // = arg
    put_locint(location);   // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] += store[y_loc];
  return *this;
}

/*--------------------------------------------------------------------------*/
/* olvo 991122 new version for y += x1 * x2; */
//badouble& badouble::operator += ( const adub& a )
badouble& badouble::operator_plus_equal ( const adub& a )
{ locint a_loc = a.loc();
  int upd = 0;
  //if (trace_flag)
    upd = upd_resloc_inc_prod(a_loc,location,eq_plus_prod);
  if (upd)
  { store[location] += store[a_loc];
    //if (revalso) 
      delete_scaylor(&store[a_loc]); 
    if (a_loc == current_top-1)
    { current_top--;     // The temporary will die in a minute and
      dealloc--;         // by reducing dealloc and current_top 
    }                    // we neutralize that effect
    --vs_ptr;
  }
  else
  { //if (trace_flag)
    { // old: write_assign_a(location,a_loc);
      put_op(eq_plus_a);
      put_locint(a_loc);    // = arg
      put_locint(location); // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[location]);
    }
    store[location] += store[a_loc];
  }

  return *this;
}

/*--------------------------------------------------------------------------*/
/* Subtract an adouble from another adouble */
badouble& badouble::operator_minus_equal ( const badouble& y ) 
{ locint y_loc = y.loc();
//  if (trace_flag) 
  { // old: write_a_same_arg(eq_min_a,location,y.location);
    put_op(eq_min_a);
    put_locint(y_loc); // = arg
    put_locint(location);   // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] -= store[y_loc];
  return *this;
}

/*--------------------------------------------------------------------------*/
/* olvo 991122 new version for y -= x1 * x2; */
//badouble& badouble::operator -= ( const adub& a )
badouble& badouble::operator_minus_equal ( const adub& a )
{ locint a_loc = a.loc();
  int upd = 0;
//  if (trace_flag)
    upd = upd_resloc_inc_prod(a_loc,location,eq_min_prod);
  if (upd)
  { store[location] -= store[a_loc];
    //if (revalso) 
      delete_scaylor(&store[a_loc]); 
    if (a_loc == current_top-1)
    { current_top--;     // The temporary will die in a minute and
      dealloc--;         // by reducing dealloc and current_top 
    }                    // we neutralize that effect
    --vs_ptr;
  }
  else
  { //if (trace_flag)
    { // old: write_assign_a(location,a_loc);
      put_op(eq_min_a);
      put_locint(a_loc);    // = arg
      put_locint(location); // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[location]);
    }
    store[location] -= store[a_loc];
  }

  return *this;
}

/*--------------------------------------------------------------------------*/
/* Multiply an adouble by a floating point */
badouble& badouble::operator_mult_equal ( double coval ) 
{// if (trace_flag) 
  { // old: write_d_same_arg(eq_mult_d,location,coval);
    put_op(eq_mult_d);
    put_locint(location); // = res
    put_val(coval);       // = coval

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] *= coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
/* Multiply one adouble by another adouble*/
badouble& badouble::operator_mult_equal ( const badouble& y ) 
{ locint y_loc = y.loc();
//  if (trace_flag) 
  { // old: write_a_same_arg(eq_mult_a,location,y.location);
    put_op(eq_mult_a);
    put_locint(y_loc); // = arg
    put_locint(location);   // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] *= store[y_loc];
  return *this;
}

/*--------------------------------------------------------------------------*/
// EGK made inline
//badouble& badouble::operator /= (double y) 
//{ *this = *this/y;
//  return *this;
//}

/*--------------------------------------------------------------------------*/
// EGK made inline
//badouble& badouble::operator /= (const badouble& y) 
//{ *this = *this * (1.0/y);
//  return *this;
//}

/****************************************************************************/
/*                                                               COMPARISON */
/* olvo 980819 NOTE: new comparison strategy !!! */

/*--------------------------------------------------------------------------*/
/*   The Not Equal Operator (!=) */
int operator != ( const badouble& v, double coval )
{ if (coval)
    return (-coval+v != 0);
  else
  { if (trace_flag)
    { put_op(store[v.location] ? neq_zero : eq_zero);
      put_locint(v.location);
    }
    return (store[v.location] != 0);
  }
}

/*--------------------------------------------------------------------------*/
/*   The Equal Operator (==) */
int operator == ( const badouble& v, double coval)
{ if (coval)
    return (-coval+v == 0);
  else
  { if (trace_flag)
    { put_op(store[v.location] ? neq_zero : eq_zero);
      put_locint(v.location);
    }
    return (store[v.location] == 0);
  }
}

/*--------------------------------------------------------------------------*/
/*   The Less than or Equal Operator (<=)      */
int operator <= ( const badouble& v, double coval )
{ if (coval)
    return (-coval+v <= 0);
  else
  { int b = (store[v.location] <= 0);
    if (trace_flag)
    { put_op(b ? le_zero : gt_zero);
      put_locint(v.location);
    }
    return b;
  }
}

/*--------------------------------------------------------------------------*/
/*   The Greater than or Equal Operator (>=)      */
int operator >= ( const badouble& v, double coval )
{ if (coval)
    return (-coval+v >= 0);
  else
  { int b = (store[v.location] >= 0);
    if (trace_flag)
    { put_op(b ? ge_zero : lt_zero);
      put_locint(v.location);
    }
    return b;
  }
}

/*--------------------------------------------------------------------------*/
/*   The Greater than Operator (>)      */
int operator > ( const badouble& v, double coval )
{ if (coval)
    return (-coval+v > 0);
  else
  { int b = (store[v.location] > 0);
    if (trace_flag)
    { put_op(b ? gt_zero : le_zero);
      put_locint(v.location);
    }
    return b;
  }
}

/*--------------------------------------------------------------------------*/
/*   The Less than Operator (<)      */
int operator < ( const badouble& v, double coval )
{ if (coval)
    return (-coval+v < 0);
  else
  { int b = (store[v.location] < 0);
    if (trace_flag)
    { put_op(b ? lt_zero : ge_zero);
      put_locint(v.location);
    }
    return b;
  }
}


/****************************************************************************/
/*                                                          SIGN  OPERATORS */

/*--------------------------------------------------------------------------*/
/* olvo 980709 modified positive sign operator 
   ??? possibly there is a better way */
adub operator + ( const badouble& x )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_pos_sign_a(locat,x.location);
    put_op(pos_sign_a);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = store[x.location];  
  return locat;
} 

/*--------------------------------------------------------------------------*/
/* olvo 980709 modified negative sign operator */
adub operator - ( const badouble& x )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_neg_sign_a(locat,x.location);
    put_op(neg_sign_a);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = -store[x.location];  
  return locat;
} 


/****************************************************************************/
/*                                                         BINARY OPERATORS */

/* NOTE: each operator calculates address of temporary  and returns
         an adub */

/*--------------------------------------------------------------------------*/
/* Adding two adoubles */
//adub operator + ( const badouble& x, const badouble& y ) 
adub operator_plus ( const badouble& x, const badouble& y ) 
{ locint locat = next_loc();

//  if (trace_flag) 
  { // old: write_two_a_rec(plus_a_a,locat,x.location,y.location);
    put_op(plus_a_a);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = store[x.location] + store[y.location];
  return locat;
}

/*--------------------------------------------------------------------------*/
/* Adding a adouble and a floating point */
//adub operator + ( double coval, const badouble& y ) 
adub operator_plus ( double coval, const badouble& y ) 
{ locint locat = next_loc(); 

  /* olvo 980708 test coval to be zero */
  // EGK removed test for zero since uncommon
//  if (coval)
 { //if (trace_flag)
    { // old: write_args_d_a(plus_d_a,locat,coval,y.location);
      put_op(plus_d_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res
      put_val(coval);         // = coval

      ++vs_ptr;
      //if (revalso)  
        write_scaylor(store[locat]);
    }

    store[locat] = coval + store[y.location];
  } 
/*  else 
  { if (trace_flag)
    { // old: write_pos_sign_a(locat,y.location);
      put_op(pos_sign_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[locat]);
    }

    store[locat] = store[y.location];
  }
*/

  return locat;
}

/*--------------------------------------------------------------------------*/
//adub operator + ( const badouble& y, double coval) 
adub operator_plus ( const badouble& y, double coval) 
{ locint locat = next_loc(); 

  /* olvo 980708 test coval to be zero */
  // EGK removed test for zero since uncommon
//  if (coval)
 { //if (trace_flag)
    { // old: write_args_d_a(plus_d_a,locat,coval,y.location);
      put_op(plus_d_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res
      put_val(coval);         // = coval

      ++vs_ptr;
      //if (revalso)  
        write_scaylor(store[locat]);
    }

    store[locat] = coval + store[y.location];
  } 
/*  else 
  { if (trace_flag)
    { // old: write_pos_sign_a(locat,y.location);
      put_op(pos_sign_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[locat]);
    }

    store[locat] = store[y.location];
  }
*/

  return locat;
}

/*--------------------------------------------------------------------------*/
/* Subtraction of two adoubles */
//adub operator - ( const badouble& x, const badouble& y )
adub operator_minus ( const badouble& x, const badouble& y )
{ locint locat = next_loc();

//  if (trace_flag) 
  { // old: write_two_a_rec(min_a_a,locat,x.location,y.location);
    put_op(min_a_a);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = store[x.location] - store[y.location];
  return locat;
}


/*--------------------------------------------------------------------------*/
/* Subtract an adouble from a floating point */
//adub operator - ( double coval, const badouble& y )
adub operator_minus ( double coval, const badouble& y )
{ locint locat = next_loc();

  /* olvo 980708 test coval to be zero */
  // EGK removed test for zero since uncommon
//  if (coval)
 { //if (trace_flag) 
    { // old: write_args_d_a(min_d_a,locat,coval,y.location);
      put_op(min_d_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res
      put_val(coval);         // = coval

      ++vs_ptr;
      //if (revalso)  
        write_scaylor(store[locat]);
    }

    store[locat] = coval - store[y.location];
  }
/*  else
  { if (trace_flag)
    { // old: write_neg_sign_a(locat,y.location);
      put_op(neg_sign_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[locat]);
    }

    store[locat] = -store[y.location];  
  }
*/
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Multiply two adoubles */
//adub operator * ( const badouble& x, const badouble& y )

adub operator_mult ( const badouble& x, const badouble& y )
{ locint locat = next_loc();

//  if (trace_flag) 
  { // old: write_two_a_rec(mult_a_a,locat,x.location,y.location);
    put_op(mult_a_a);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = store[x.location] * store[y.location];
  return locat;
}



/*--------------------------------------------------------------------------*/
/* Multiply an adouble by a floating point */ 
/* olvo 980709 modified */
//adub operator * ( double coval, const badouble& y )
adub operator_mult ( double coval, const badouble& y )
{ locint locat = next_loc();

// EGK removed checks for 1 and -1 since uncommon
/*  if ( coval == 1.0 )
  { //if (trace_flag)
    { // old: write_pos_sign_a(locat,y.location);
      put_op(pos_sign_a);
      put_locint(y.location); // = arg
      put_locint(locat);      // = res

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[locat]);
    }

    store[locat] = store[y.location];  
  }
  else
    if ( coval == -1.0 )
    { //if (trace_flag)
      { // old: write_neg_sign_a(locat,y.location);
        put_op(neg_sign_a);
        put_locint(y.location); // = arg
        put_locint(locat);      // = res

        ++vs_ptr;
        //if (revalso) 
          write_scaylor(store[locat]);
      }

      store[locat] = -store[y.location];  
    }
    else
*/    { //if (trace_flag) 
      { // old: write_args_d_a(mult_d_a,locat,coval,y.location);
        put_op(mult_d_a);
        put_locint(y.location); // = arg
        put_locint(locat);      // = res
        put_val(coval);         // = coval

        ++vs_ptr;
        //if (revalso)  
          write_scaylor(store[locat]);
      }
 
      store[locat] = coval * store[y.location];
    }
  return locat;
}


/*--------------------------------------------------------------------------*/
/* Divide an adouble by another adouble */
//adub operator / ( const badouble& x, const badouble& y )
adub operator_divide ( const badouble& x, const badouble& y )
{ locint locat = next_loc();

//  if (trace_flag)
  { // old: write_two_a_rec(div_a_a,locat,x.location,y.location);
    put_op(div_a_a);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = store[x.location] / store[y.location];
  return locat;
}

/*--------------------------------------------------------------------------*/
/* Division floating point - adouble */
//adub operator / ( double coval, const badouble& y )
adub operator_divide ( double coval, const badouble& y )
{ locint locat = next_loc();

//  if (trace_flag)
  { // old: write_args_d_a(div_d_a,locat,coval,y.location);
    put_op(div_d_a);
    put_locint(y.location); // = arg
    put_locint(locat);      // = res
    put_val(coval);         // = coval

    ++vs_ptr;
    //if (revalso)  
      write_scaylor(store[locat]);
  }

  store[locat] = coval  / store[y.location];
  return locat;
}


/****************************************************************************/
/*                                                        SINGLE OPERATIONS */

/*--------------------------------------------------------------------------*/
/* Compute exponential of adouble */
adub exp ( const badouble& x )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_single_op(exp_op,locat,x.location);
    put_op(exp_op);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res   

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = exp(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Compute logarithm of adouble */
adub log ( const badouble& x )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_single_op(log_op,locat,x.location);
    put_op(log_op);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res   

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = log(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Compute sqrt of adouble */
adub sqrt ( const badouble& x )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_single_op(sqrt_op,locat,x.location);
    put_op(sqrt_op);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res   

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = sqrt(store[x.location]);
  return locat; 
}

/****************************************************************************/
/*                                                          QUAD OPERATIONS */

/*--------------------------------------------------------------------------*/
/* Compute sin of adouble
   !!! Sin and Cos are always evaluated together
*/
adub sin ( const badouble& x ) 
{ locint locat = next_loc(); 

  adouble y;

  if (trace_flag) 
  { // old: write_quad(sin_op,locat,x.location,y.location);
    put_op(sin_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    vs_ptr += 2;
    //if (revalso) 
    { /* olvo 980921 changed order */
      write_scaylor(store[y.location]);
      write_scaylor(store[locat]);
    }
  }

  store[locat]      = sin(store[x.location]);
  store[y.location] = cos(store[x.location]);
  return locat;
}

/*--------------------------------------------------------------------------*/
/* Compute cos of adouble */
adub cos ( const badouble& x )
{ locint locat = next_loc();

  adouble y;

  if (trace_flag)
  { // old: write_quad(cos_op, locat,x.location,y.location);
    put_op(cos_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    vs_ptr += 2;
    //if (revalso) 
    { /* olvo 980921 changed order */
      write_scaylor(store[y.location]);
      write_scaylor(store[locat]);
    }
  }

  store[locat]      = cos(store[x.location]);
  store[y.location] = sin(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Compute tan of adouble */
adub tan ( const badouble& x ) 
{ return sin(x) / cos(x);
}

/*--------------------------------------------------------------------------*/
/* Asin value -- really a quadrature */
adub asin ( const badouble& x )
{ locint locat = next_loc();

  adouble y = 1.0 / sqrt(1.0 - x*x);

  if (trace_flag)
  { // old:  write_quad(asin_op,locat,x.location,y.location);
    put_op(asin_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = asin(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Acos value -- really a quadrature */
adub acos ( const badouble& x )
{ locint locat = next_loc();

  adouble y = -1.0 / sqrt(1.0 - x*x);

  if (trace_flag)
  { // old: write_quad(acos_op,locat,x.location,y.location);
    put_op(acos_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = acos(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Atan value -- really a quadrature */
adub atan ( const badouble& x )
{ locint locat = next_loc();

  adouble y = 1.0 / (1.0 + x*x);

  if (trace_flag)
  { // old: write_quad(atan_op,locat,x.location,y.location);
    put_op(atan_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = atan(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
adouble atan2( const badouble& y, const badouble& x)
{ adouble a1, a2, ret, sy;
  const double pihalf = asin(1.0);
  /* y+0.0 is a hack since condassign is currently not defined for 
     badoubles */
  condassign( sy,  y+0.0,  1.0 , -1.0 ); 
  condassign( a1,  x+0.0, (adouble) atan(y/x), 
                           (adouble)( atan(y/x)+sy*2*pihalf));
  condassign( a2,  (adouble) fabs(y), (adouble) (sy*pihalf-atan(x/y)),
                                      (adouble) 0.0 );
  condassign( ret, (adouble) (fabs(x) - fabs(y)), a1, a2 );
  return ret;
}

/*--------------------------------------------------------------------------*/
/* power value -- adouble ^ floating point */
adub pow ( const badouble& x, double coval )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_args_d_a(pow_op,locat,cocval,x.location);
    put_op(pow_op);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res
    put_val(coval);         // = coval

    ++vs_ptr;
    //if (revalso)  
       write_scaylor(store[locat]);
  }

  store[locat] = pow(store[x.location],coval);
  return locat;
}

/*--------------------------------------------------------------------------*/
/* power value --- floating point ^ adouble */
adouble pow ( double coval, const badouble& y )
{ adouble ret;
 
  if (coval <= 0)
  { fprintf(DIAG_OUT,"\nADOL-C message:  exponent at zero/negative constant basis deactivated\n");
  }

  condassign (ret, coval, exp(y*log(coval)), pow(coval,y.value()) );

  return ret;
}

/*--------------------------------------------------------------------------*/
/* power value --- adouble ^ adouble */
adouble pow ( const badouble& x, const badouble& y)  
{ adouble a1, a2, ret;
  double vx = x.value();
  double vy = y.value();

  if (!(vx > 0))
    if (vx < 0 || vy >= 0)
      fprintf(DIAG_OUT,"\nADOL-C message: exponent of zero/negative basis deactivated\n");
    else 
      fprintf(DIAG_OUT,"\nADOL-C message: negative exponent and zero basis deactivated\n"); 

  condassign(a1,-y,pow(vx,vy),pow(x,vy));
  condassign(a2,fabs(x),pow(x, vy),a1);
  condassign(ret,x+0.0,exp(y*log(x)),a2);

  return ret;  
}

/*--------------------------------------------------------------------------*/
/* log base 10 of an adouble */
adub log10 ( const badouble& x ) 
{ return log(x) / log(10.0);
}

/*--------------------------------------------------------------------------*/
/* Hyperbolic Sine of an adouble */
/* 981119 olvo changed as J.M. Aparicio suggested */
adub sinh ( const badouble& x ) 
{ if (x.value() < 0.0)
  { adouble temp = exp(x);
    return  0.5*(temp - 1.0/temp);
  }
  else
  { adouble temp = exp(-x);
    return 0.5*(1.0/temp - temp);
  }
}

/*--------------------------------------------------------------------------*/
/* Hyperbolic Cosine of an adouble */
/* 981119 olvo changed as J.M. Aparicio suggested */
adub cosh ( const badouble& x ) 
{ adouble temp = (x.value() < 0.0) ? exp(x) : exp(-x);
  return 0.5*(temp + 1.0/temp);
}

/*--------------------------------------------------------------------------*/
/*
  Hyperbolic Tangent of an adouble value.
*/
/* 981119 olvo changed as J.M. Aparicio suggested */
adub tanh ( const badouble& x ) 
{ if (x.value() < 0.0)
  { adouble temp = exp(2.0*x);
    return (temp - 1.0)/(temp + 1.0);
  }
  else
  { adouble temp = exp((-2.0)*x);
    return (1.0 - temp)/(temp + 1.0);
  }
}

/*--------------------------------------------------------------------------*/
/* Ceiling function (NOTE: This function is nondifferentiable) */
adub ceil ( const badouble& x ) 
{ locint locat=next_loc();
  
  double coval = ceil(store[x.location]);

  if (trace_flag)
  { // old: write_args_d_a(ceil_op,locat,coval,x.location);
    put_op(ceil_op);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res
    put_val(coval);         // = coval

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = coval;
  return locat;
}

/*--------------------------------------------------------------------------*/
/* Floor function (NOTE: This function is nondifferentiable) */
adub floor ( const badouble& x ) 
{ locint locat=next_loc();

  double coval = floor(store[x.location]);

  if (trace_flag)
  { // old: write_args_d_a(floor_op,locat,coval,x.location);
    put_op(floor_op);
    put_locint(x.location); // = arg
    put_locint(locat);      // = res
    put_val(coval);         // = coval

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = coval;
  return locat;
}

#ifdef ATRIG_ERF
/* NOTE: enable if your compiler knows asinh, acosh, atanh, erf */

/*--------------------------------------------------------------------------*/
/* Asinh value -- really a quadrature */
adub asinh ( const badouble& x )
{ locint locat = next_loc();

  adouble y = 1.0 / sqrt(1.0 + x*x);

  if (trace_flag) 
  { // old: write_quad(asinh_op,locat,x.location,y.location);
    put_op(asinh_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = asinh(store[x.location]);
  return locat; 
} 

/*--------------------------------------------------------------------------*/
/* Acosh value -- really a quadrature */
adub acosh ( const badouble& x )
{ locint locat = next_loc();

  adouble y = 1.0 / sqrt(1.0 - x*x);

  if (trace_flag)
  { // old: write_quad(acosh_op,locat,x.location,y.location);
    put_op(acosh_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = acosh(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/* Atanh value -- really a quadrature */
adub atanh ( const badouble& x )
{ locint locat = next_loc();

  adouble y = 1.0 / (1.0 - x*x);

  if (trace_flag)
  { // old: write_quad(atanh_op,locat,x.location,y.location);
    put_op(atanh_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat] = atanh(store[x.location]);
  return locat; 
}

/*--------------------------------------------------------------------------*/
/*  The error function erf */
adub erf( const badouble& x ) 
{ locint locat = next_loc();

  adouble y = exp(-x*x);

  if (trace_flag)
  { // old: write_quad(erf_op,locat,x.location,y.location);
    put_op(erf_op);
    put_locint(x.location); // = arg1
    put_locint(y.location); // = arg2
    put_locint(locat);      // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat]=erf(store[x.location]);
  return locat;
} 

#endif

/*--------------------------------------------------------------------------*/
/* Fabs Function (NOTE: This function is also nondifferentiable at x=0) */
adub fabs ( const badouble& x )
{ locint locat = next_loc();
  
  double coval = 1.0;
  double temp  = fabs(store[x.location]);
  if (temp != store[x.location])
    coval = 0.0;

  if (trace_flag)
  { /*  write_args_d_a(abs_val,locat,coval,x.location); */
    put_op(abs_val);
    put_locint(x.location);   /* arg */
    put_locint(locat);        /* res */ 
    put_val(coval);           /* coval */
 
    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }
  store[locat] = temp;
  return locat;
}

/*--------------------------------------------------------------------------*/
/* max and min functions  (changed : 11/15/95) */
adub fmin ( const badouble& x, const badouble& y )
{ /* olvo 980702 tested: return 0.5*fabs(x+y-fabs(x-y)); */
  locint locat = next_loc();

  if (store[y.location] < store[x.location])
  { if (trace_flag) 
    { // old: write_min_op(x.location,y.location,locat,0.0);
      put_op(min_op);
      put_locint(x.location); // = arg1
      put_locint(y.location); // = arg2
      put_locint(locat);      // = res
      put_val(0.0);           // = coval

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[locat]);
    }

    store[locat]=store[y.location];
  } 
  else 
  { if (trace_flag) 
    { // old: write_min_op(x.location,y.location,locat,1.0);
      put_op(min_op);
      put_locint(x.location); // = arg1
      put_locint(y.location); // = arg2
      put_locint(locat);      // = res
      put_val(1.0);           // = coval

      ++vs_ptr;
      //if (revalso) 
        write_scaylor(store[locat]);
    }

    store[locat]=store[x.location];
  }
  return locat;
}

/*--------------------------------------------------------------------------*/
/*21.8.96*/
adub fmin ( double d, const badouble& y )
{ adouble x = d;
  return (fmin (x,y));
}

/*--------------------------------------------------------------------------*/
adub fmin ( const badouble& x, double d )
{ adouble y = d;
  return (fmin (x,y));
}

/*--------------------------------------------------------------------------*/
adub fmax ( const badouble& x, const badouble& y )
{ return (-fmin(-x,-y));
}

/*--------------------------------------------------------------------------*/
/*21.8.96*/
adub fmax ( double d, const badouble& y )
{ adouble x = d;
  return (-fmin(-x,-y));
}

/*--------------------------------------------------------------------------*/
adub fmax ( const badouble& x, double d )
{ adouble y = d;
  return (-fmin(-x,-y));
}

/*--------------------------------------------------------------------------*/
/* Ldexp Function */
adub ldexp ( const badouble& x, int exp ) 
{ return x*ldexp(1.0,exp);
}

/*--------------------------------------------------------------------------*/
/* Macro for user defined quadratures, example myquad is below.*/
/* the forward sweep tests if the tape is executed exactly at  */
/* the same argument point otherwise it stops with a returnval */
#define extend_quad(func,integrand)\
adouble func ( const badouble& arg )\
{  adouble temp; \
    adouble val; \
    integrand; \
    if (trace_flag) \
    { put_op(gen_quad); \
      put_locint(arg.location); \
      put_locint(val.location); \
      put_locint(temp.location); \
      ++vs_ptr; \
      if (revalso) \
        write_scaylor(store[temp.location]); \
    } \
    store[temp.location]=func(store[arg.location]); \
    if (trace_flag) \
    { put_val(store[arg.location]); \
      put_val(store[temp.location]); \
    } \
    return temp; }

double myquad(double& x)
{
  double res;
  res = log(x);
  return res;
}

/* This defines the natural logarithm as a quadrature */

extend_quad(myquad,val = 1/arg)


/****************************************************************************/
/*                                                             CONDITIONALS */

/* For the time being condassign is defined using adoubles in two 
   versions with adouble and along as left hand side.  This implies 
   some problems when badoubles are used as arguments, e.g. inside 
   the pow definition. For later versions we will replace this with
   complete definition for all parameter type constellations */

/*--------------------------------------------------------------------------*/
void condassign( adouble &res,        const adouble &cond, 
                 const adouble &arg1, const adouble &arg2 ) 
{ if (trace_flag)
  { // old: write_condassign(res.location,cond.location,arg1.location,
    //		     arg2.location);
    put_op(cond_assign);
    put_locint(cond.location); // = arg
    put_val(store[cond.location]);
    put_locint(arg1.location); // = arg1
    put_locint(arg2.location); // = arg2
    put_locint(res.location);  // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[res.location]);
  }

  if (store[cond.location] > 0)
    store[res.location] = store[arg1.location];
  else
    store[res.location] = store[arg2.location];
}

/*--------------------------------------------------------------------------*/
void condassign( adouble &res, const adouble &cond, const adouble &arg ) 
{ if (trace_flag)		
  { // old: write_condassign2(res.location,cond.location,arg.location);
    put_op(cond_assign_s);
    put_locint(cond.location); // = arg
    put_val(store[cond.location]);
    put_locint(arg.location);  // = arg1
    put_locint(res.location);  // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[res.location]);
  }

  if (store[cond.location] > 0)
    store[res.location] = store[arg.location];
}

/*--------------------------------------------------------------------------*/
void condassign( along &res, const adouble &cond, 
                 const adouble &arg1, const adouble &arg2 ) 
{ if (trace_flag)
  { // old: write_condassign(res.location,cond.location,arg1.location,
    //		     arg2.location);
    put_op(cond_assign);
    put_locint(cond.location); // = arg
    put_val(store[cond.location]);
    put_locint(arg1.location); // = arg1
    put_locint(arg2.location); // = arg2
    put_locint(res.location);  // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[res.location]);
  }

  if (store[cond.location] > 0)
    store[res.location] = store[arg1.location];
  else
    store[res.location] = store[arg2.location];
}

/*--------------------------------------------------------------------------*/
void condassign( along &res, const adouble &cond, const adouble &arg) 
{ if (trace_flag)		
  { // old: write_condassign2(res.location,cond.location,arg.location);
    put_op(cond_assign_s);
    put_locint(cond.location); // = arg
    put_val(store[cond.location]);
    put_locint(arg.location);  // = arg1
    put_locint(res.location);  // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[res.location]);
  }

  if (store[cond.location] > 0)
    store[res.location] = store[arg.location];
}

/****************************************************************************/
/*                                   SUBSCRIPTS (CONSTRUCTOR / ASSIGNMENTS) */

/*--------------------------------------------------------------------------*/
asub::asub(locint start, locint index)
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"\nADOL-C debug: Constructing an asub with 2 arguments\n");
#endif  
  base   = start;
  offset = index;

  location = next_loc();

  if (trace_flag)
  { // old:write_associating_value(subscript,location,base,offset);
    put_op(subscript);
    put_locint(base);
    put_locint(offset);
    put_locint(location);
    put_val(store[offset]);

    /* olvo 980721 new n3l */
    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location] = store[base+(int)store[offset]];  
}

/*--------------------------------------------------------------------------*/
asub& asub::operator <<= ( double coval ) 
{ locint res = base+(int)store[offset];
  
  if (trace_flag)
  { // old: write_assign_ind(location);
    ind_ptr++;
    put_op(assign_ind);
    put_locint(location); // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[location]);

  /* olvo 980711 necessary ??? 
  }
  store[location] = coval;  
  if (trace_flag)
  { */

    // old: write_associating_value(subscript_l,location,base,offset);
    put_op(subscript_l);
    put_locint(base);
    put_locint(offset);
    put_locint(location);
    put_val(store[offset]);

    ++vs_ptr;
    //if (revalso) /* olvo 980711 ??? next line */
      write_scaylor(store[location]); 
      /* this is correct since location is the location of the copy which 
         already contains the value to be stored */
  }

  store[res] = coval;
  return *this;
}   

/*--------------------------------------------------------------------------*/
asub& asub::operator = ( double coval )
{ locint res = base+(int)store[offset];

  if (trace_flag)
  { // old: write_associating_value_ld(subscript_ld,coval,base,offset);
    put_op(subscript_ld);
    put_val(coval);
    put_locint(base);
    put_locint(offset);
    put_val(store[offset]);

   ++vs_ptr;
   //if (revalso) 
     write_scaylor(store[res]);
  }

  store[res] = coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator = ( const badouble& x ) 
{ locint res = base+(int)store[offset];

  if (trace_flag)
  { // old: write_associating_value(subscript_l,x.loc(),base,offset);
    put_op(subscript_l);
    put_locint(base);
    put_locint(offset);
    put_locint(x.loc());
    put_val(store[offset]);

    ++vs_ptr;
    //if (revalso) /* olvo 980711 ??? next line */
      write_scaylor(store[x.loc()]);
      /* this is correct since location is the location of the copy which 
         already contains the value to be stored */
  }

  store[res]=store[x.loc()];
  return *this;
}   

/*--------------------------------------------------------------------------*/
/* 20.08.96 */
asub& asub::operator = ( const asub& x ) 
{ locint res = base+(int)store[offset];

  if (trace_flag)
  { // : write_associating_value(subscript_l,x.loc(),base,offset);
    put_op(subscript_l);
    put_locint(base);
    put_locint(offset);
    put_locint(x.loc());
    put_val(store[offset]);

    ++vs_ptr;
    //if (revalso) /* olvo 980711 ??? next line */
      write_scaylor(store[x.loc()]);
      /* this is correct since location is the location of the copy which 
         already contains the value to be stored */
  }

  store[res]=store[x.loc()];
  return *this;
} 


/****************************************************************************/
/*                                      SUBSCRIPTS (OPERATION + ASSIGNMENT) */

/* olvo 980713 !!! seems to be a temporary version */
 
/*--------------------------------------------------------------------------*/
/* Sep/01/96 */
asub& asub::operator += ( double x )
{ *this = *this + x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator += ( const badouble& x )
{ *this = *this + x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator -= ( double x )
{ *this = *this - x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator -= ( const badouble& x )
{ *this = *this - x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator *= ( double x )
{ *this = *this * x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator *= ( const badouble& x )
{ *this = *this * x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator /= ( double x )
{ *this = *this / x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asub& asub::operator /= ( const badouble& x )
{ *this = *this / x;
  return *this;
}

/****************************************************************************/
/*                                       SUBSCRIPTS (INCREMENT / DECREMENT) */

/*--------------------------------------------------------------------------*/
/* postfix increment */
adub asub::operator++( int )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_assign_a(locat,location);
    put_op(assign_a);
    put_locint(location); // = arg
    put_locint(locat);    // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[locat]);
  }

  store[locat]=store[location]; /* location is the local copy of the
  asub for which this definition is invoked */
  *this = *this + 1;
  return locat ;
}

/*--------------------------------------------------------------------------*/
/* postfix decrement */
adub asub::operator--( int )
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_assign_a(locat,location);
    put_op(assign_a);
    put_locint(location); // = arg
    put_locint(locat);    // = res

    ++vs_ptr;
    //if (revalso)
      write_scaylor(store[locat]);
  }

  store[locat]=store[location]; /* location is the local copy of the 
  asub for which this definition is invoked */
  *this = *this - 1;
  return locat ;
}

/*--------------------------------------------------------------------------*/
/* prefix increment */
asub& asub::operator++() 
{ *this = *this + 1;
  return *this;
}

/*--------------------------------------------------------------------------*/
/* prefix decrement */
asub& asub::operator--() 
{ *this = *this - 1;
  return *this;
}

/****************************************************************************/
/*                                                              ALONG STUFF */

/*--------------------------------------------------------------------------*/
along::along()
{ location = next_loc();
}

/*--------------------------------------------------------------------------*/
along& along::operator = ( int coval ) 
{ if (trace_flag)
  { // old: write_assign_d(location,coval);
    if (coval == 0)
    { put_op(assign_d_zero);
      put_locint(location);   // = res
    }
    else
      if (coval == 1.0)
      { put_op(assign_d_one);
        put_locint(location); // = res
      }
      else
      { put_op(assign_d);
        put_locint(location); // = res
        put_val(coval);
      }

    ++vs_ptr;
    //if (revalso)  
      write_scaylor(store[location]);
  }

  store[location]=coval;
  return *this;
}   

/*--------------------------------------------------------------------------*/
along& along::operator = ( const badouble& x ) 
{ if (location != x.loc())  
  /* test this to avoid for x=x statements adjoint(x)=0 in reverse mode */
  { if (trace_flag)
    { // old:   write_assign_a(location,x.loc());
      put_op(assign_a);
      put_locint(x.loc());  // = arg
      put_locint(location); // = res

      ++vs_ptr;
      //if (revalso)
        write_scaylor(store[location]);
    }

    store[location]=store[x.loc()];
  } 
  return *this;
}

/*--------------------------------------------------------------------------*/
along& along::operator = ( const along& x ) 
{ if (location != x.location) 
  /* test this to avoid for x=x statements adjoint(x)=0 in reverse mode */
  { if (trace_flag)
    { // old: write_assign_a(location,x.location);
      put_op(assign_a);
      put_locint(x.location); // = arg
      put_locint(location);   // = res

      ++vs_ptr;
      //if (revalso)
        write_scaylor(store[location]);
    }

    store[location]=store[x.location];
  } 
  return *this;
}

/*--------------------------------------------------------------------------*/
along& along::operator = ( const adub& a )
{ if (location != a.loc())  
  /* test this to avoid for x=x statements adjoint(x)=0 in reverse mode */
  { if (trace_flag)
    { // old: write_assign_a(location,a.loc());
      put_op(assign_a);
      put_locint(a.loc());  // = arg
      put_locint(location); // = res

      ++vs_ptr;
      //if (revalso)
        write_scaylor(store[location]);
    }

    store[location]=store[a.loc()] ;
  } 
  return *this;
}

/*--------------------------------------------------------------------------*/
along::along( int coval )
{ location = next_loc();

  if (trace_flag)
  { // old: write_int_assign_d(location,coval);
    if (coval == 0)
    { put_op(assign_d_zero);
      put_locint(location);   // = res
    }
    else
      if (coval == 1.0)
      { put_op(assign_d_one);
        put_locint(location); // = res
      }
      else
      { put_op(assign_d);
        put_locint(location); // = res
        put_val(coval);
      }

    ++vs_ptr; 
    //if (revalso)  
      write_scaylor(store[location]);
  }

  store[location] = coval;
}

/*--------------------------------------------------------------------------*/
along::along( const along& a )
{ location = next_loc();

  if (trace_flag)
  { // old: write_int_assign_a(location,a.location);
    put_op(assign_a);
    put_locint(a.location); // = arg
    put_locint(location);   // = res
 
    ++vs_ptr; 
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location]=store[a.location];
}

/*--------------------------------------------------------------------------*/
along::along( const adub& a )
{ location = next_loc();

  if (trace_flag)
  { // old: write_int_assign_a(location,a.loc());
    put_op(assign_a);
    put_locint(a.loc());  // = arg
    put_locint(location); // = res
 
    ++vs_ptr; 
    //if (revalso)
      write_scaylor(store[location]);
  }

  store[location]=store[a.loc()];
}

/*--------------------------------------------------------------------------*/
/* postfix increment */
adub along::operator++( int ) 
{ locint locat = next_loc();

  if (trace_flag) 
  { // old: write_assign_a(locat,location);
    put_op(assign_a);
    put_locint(location); // = arg
    put_locint(locat);    // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat]=store[location];

  if (trace_flag) 
  { // old: write_incr_decr_a(incr_a,location); 
    put_op(incr_a);
    put_locint(location);

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location]++;
  return locat ;
}

/*--------------------------------------------------------------------------*/
/* postfix decrement */
adub along::operator--( int ) 
{ locint locat = next_loc();

  if (trace_flag)
  { // old: write_assign_a(locat,location);
    put_op(assign_a);
    put_locint(location); // = arg
    put_locint(locat);    // = res

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[locat]);
  }

  store[locat]=store[location];

  if (trace_flag)
  { // old: write_incr_decr_a(decr_a,location);
    put_op(decr_a);
    put_locint(location);

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location]--;
  return locat ;
}

/*--------------------------------------------------------------------------*/
/* prefix increment */
along& along::operator++()
{ if (trace_flag)
  { // old: write_incr_decr_a(incr_a,location);
    put_op(incr_a);
    put_locint(location);

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location]++;
  return *this;
}

along& along::operator--() /* prefix decrement */
{ if (trace_flag) 
  { // old: write_incr_decr_a(decr_a,location);
    put_op(decr_a);
    put_locint(location);

    ++vs_ptr;
    //if (revalso) 
      write_scaylor(store[location]);
  }

  store[location]--;
  return *this;
}

/****************************************************************************/
/*                                                                THAT'S ALL*/

//@@@@@@@ avector.cpp


/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     avector.cpp
 Revision: $Id: avector.cpp,v 1.2 2004/05/24 10:50:30 kowarz Exp $
 Contents: Avector.C contains the necessary routines for vector operations       
           that are defined in avector.h.  Note: avector.h is included 
           automatically by adouble.h, and hence does not need to be 
           included here again.
           
 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20040423 kowarz: adapted to configure - make - make install
          19981130 olvo:   last check (includes ...)
	                        NOTICE: I think everything concerning vectors 
                                   has to be checked again in detail!
          19980930 olvo:   allow overwrites in av*=a, av*a, a*av
          19980924 olvo:   changed all int_* opcodes
          19980721 olvo:   write of taylors in m_subscript
          19980714 olvo:   debugging vector - matrix stuff
          19980713 olvo:   elimination of "writes" from taputil1.c completed
          19980707 olvo:   (1) used void write_dot_av_av(..)
                           (2) taping with keep

----------------------------------------------------------------------------*/

//#include "adouble.h"
//#include "adouble_p.h"
//#include "oplate.h"
//#include "taputil.h"
//#include "taputil_p.h"
//#include "tayutil.h"
//#include "tayutil_p.h"

//#include <math.h>

/****************************************************************************/
/*                                                   GLOBAL VARS & ROUTINES */

/*--------------------------------------------------------------------------*/
extern double* store;
extern int trace_flag;

/****************************************************************************/
/*                                                      VECTOR CONSTRUCTORS */
  
/*--------------------------------------------------------------------------*/
adoublev::adoublev( int n )
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:Declaring active vector\n");
#endif
  size = n;
  start_loc = next_loc(size); 


  //EGK added this
  *this = 0.0;
}

/*--------------------------------------------------------------------------*/
adoublev::adoublev( const adoublev &arg )
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:Declaring active vector and"
                   " initializing from adoublev\n");
#endif
  size = arg.size;
  start_loc = next_loc(size);

  if (trace_flag) 
  { // old: write_intvec_assign_av(size,start_loc,arg.start_loc);
    put_op(assign_av);
    put_locint(arg.start_loc); // = arg
    put_locint(size);
    put_locint(start_loc);     // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[start_loc+i] = store[arg.start_loc+i];    
}

/*--------------------------------------------------------------------------*/
adoublev::adoublev( const adubv& a)
{ /* olvo 980713 what about size? */
  size = a.sz();
  start_loc = next_loc(size);

  if (trace_flag)
  { // old: write_intvec_assign_av(size,start_loc,a.loc());
    put_op(assign_av);
    put_locint(a.loc());   // = arg
    put_locint(size);
    put_locint(start_loc); // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[start_loc+i] = store[a.loc()+i];
}


/****************************************************************************/
/*                                                       VECTOR ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
/* backup copy
adoublev& adoublev::operator = ( double* coval ) 
{ if (trace_flag) 
  { // old: write_assign_vec_dv(size,start_loc,coval);
    locint space_left = get_val_space(), 
           vals_left  = size, 
           loc        = start_loc;
    double *d = coval;

    while (space_left < vals_left)
    { put_op(assign_dv);
      put_locint(space_left);
      put_locint(loc);
      put_vals_p(d,space_left);
      d         += space_left;
      vals_left -= space_left;
      loc       += space_left;
      space_left = get_val_space();
      abort();
    } 

    if (vals_left > 0)
    { put_op(assign_dv);
      put_locint(vals_left);
      put_locint(loc);
      put_vals_r(d,vals_left);
    }

    vs_ptr += size;
    //if (revalso)
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[start_loc+i] = coval[i];
  return *this;
}
*/

adoublev& adoublev::operator= ( double* coval ) 
//adoublev& adoublev::operator_equal ( double* coval ) 
{ if (trace_flag) 
  { // old: write_assign_vec_dv(size,start_loc,coval);

     // EGK removed writing to disk feature

/*    locint space_left = get_val_space(), 
           vals_left  = size, 
           loc        = start_loc;
    double *d = coval;

    while (space_left < vals_left)
    { put_op(assign_dv);
      put_locint(space_left);
      put_locint(loc);
      put_vals_p(d,space_left);
      d         += space_left;
      vals_left -= space_left;
      loc       += space_left;
      space_left = get_val_space();
      abort();
    } 
*/
//    if (vals_left > 0)
    { put_op(assign_dv);
      put_locint(size);
      put_locint(start_loc);
      put_vals_r(coval,size);
    }

    vs_ptr += size;
    //if (revalso)
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[start_loc+i] = coval[i];
  return *this;
}

double* adoublev::operator_equal_start () 
{ if (trace_flag) 
 {
    write_scaylors((store+start_loc),size);
  }

  return store+start_loc;
}

void adoublev::operator_equal_end () 
{ if (trace_flag) 
 {  put_op(assign_dv);
    put_locint(size);
    put_locint(start_loc);
    put_vals_r(store+start_loc,size);
   
    vs_ptr += size;
  }
}


/*--------------------------------------------------------------------------*/
adoublev& adoublev::operator = ( double coval )
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:In adoublev=double\n");
#endif
  /* olvo 980713 very tricky */
  if (trace_flag)
  { vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
     store[start_loc+i] = coval;

  if (trace_flag)
  { // old: write_assign_vec_dv(size,start_loc,store+start_loc);
    locint space_left = get_val_space(), 
           vals_left  = size,
           loc        = start_loc;
    double *d         = store + start_loc;

    while (space_left < vals_left)
    { put_op(assign_dv);
      put_locint(space_left);
      put_locint(loc);
      put_vals_p(d,space_left);
      d         += space_left;
      vals_left -= space_left;
      loc       += space_left;
      space_left = get_val_space();
    } 

    if (vals_left > 0)
    { put_op(assign_dv);
      put_locint(vals_left);
      put_locint(loc);
      put_vals_r(d,vals_left);
    } 
  }

  return *this;
}

/*--------------------------------------------------------------------------*/
adoublev& adoublev::operator = ( const badoublev& x ) 
{ if(start_loc != x.loc())
  /* test this to avoid  adjoint(x)=0 for x=x in reverse */
  { if (trace_flag) 
    { // old: write_assign_av(size,start_loc,x.loc());
      put_op(assign_av);
      put_locint(x.loc());   // = arg
      put_locint(size);
      put_locint(start_loc); // = res

      vs_ptr += size;
      //if (revalso) 
        write_scaylors((store+start_loc),size);
    }
    
    for (int i=0; i<size; i++)
      store[start_loc+i] = store[x.loc()+i];
  } 
  return *this;
}

/*--------------------------------------------------------------------------*/
adoublev& adoublev::operator = ( const adoublev& x ) 
{ if(start_loc != x.start_loc)
  /* test this to avoid  adjoint(x)=0 for x=x in reverse */
  { if (trace_flag) 
    { // old: write_assign_av(size,start_loc,x.start_loc);
      put_op(assign_av);
      put_locint(x.start_loc); // = arg
      put_locint(size);
      put_locint(start_loc);   // = res

      vs_ptr += size;
      //if (revalso) 
        write_scaylors((store+start_loc),size);
    }

    for (int i=0; i<size; i++)
      store[start_loc+i] = store[x.start_loc+i];
  } 
  return *this;
}

/*--------------------------------------------------------------------------*/
adoublev& adoublev::operator = ( const adubv& a )
{ if (start_loc != a.loc())
  /* test this to avoid  adjoint(x)=0 for x=x in reverse */
  { if (trace_flag)
    { // old: write_assign_av(size,start_loc,a.loc());
      put_op(assign_av);
      put_locint(a.loc());   // = arg
      put_locint(size);
      put_locint(start_loc); // = res

      vs_ptr += size;
      //if (revalso) 
        write_scaylors((store+start_loc),size);
    }

    for (int i=0; i<size; i++)
      store[start_loc+i] = store[a.loc()+i];
  } 
  return *this;
}


/****************************************************************************/
/*                                                              DESTRUCTORS */
#ifdef overwrite

/*--------------------------------------------------------------------------*/
adoublev::~adoublev()
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:Destructing active vector\n");
#endif
  free_loc(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adubv::~adubv()
{ free_loc(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adoublem::~adoublem()
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:Destructing active matrix\n");
#endif
  delete[] index;
}

#endif


/****************************************************************************/
/*                                                           INPUT / OUTPUT */

/*--------------------------------------------------------------------------*/
std::ostream& operator << ( std::ostream& out, const badoublev &arg )
{ out << "(";
  for (int i=0; i<arg.size-1; i++)
    out << store[arg.start_loc+i] << ", ";
  out << store[(arg.start_loc+arg.size)-1] << ")(a)";
  return out;
}  


/****************************************************************************/
/*                                                                    INDEX */

/*--------------------------------------------------------------------------*/
// EGK: made inline by EGK, removed bounds checking
//badouble badoublev::operator[](int i) const  
//{  /* Used so can access the vector like an array with the [] */
//  /* Check if out of range */
//  if (i<0 || i>=size)
//  { fprintf (DIAG_OUT,"ADOL-C error: adoublev index out of range.\n");
//    exit(-3);
//  }
//
//  return start_loc+i;
//}


/****************************************************************************/
/*                                                              ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator = ( const badoublev &arg )
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:In badoublev = badoublev\n");
#endif
  if (start_loc != arg.start_loc)
  /* test this to avoid  adjoint(x)=0 for x=x in reverse */
  { if (trace_flag)
    { // old: write_assign_av(size,start_loc,arg.start_loc);
      put_op(assign_av);
      put_locint(arg.start_loc); // = arg
      put_locint(size);
      put_locint(start_loc);     // = res

      vs_ptr += size;
      //if (revalso) 
        write_scaylors((store+start_loc),size);
    }
  
    for (int i=0; i<arg.size; i++)
      store[start_loc+i] = store[arg.start_loc+i];
  }
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator = ( const adubv &arg )
{ locint arg_start_loc = arg.loc();
  locint arg_size      = arg.sz();

  if (start_loc != arg_start_loc)
  /* test this to avoid  adjoint(x)=0 for x=x in reverse */
  { if (trace_flag)
    { // old: write_assign_av(size,start_loc,arg_start_loc);
      put_op(assign_av);
      put_locint(arg_start_loc); // = arg
      put_locint(size);
      put_locint(start_loc);     // = res

      vs_ptr += size;
      //if (revalso) 
        write_scaylors((store+start_loc),size);
    }
  
    for (locint i=0; i<arg_size; i++)
      store[start_loc+i] = store[arg_start_loc+i];
  }
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator = ( const adoublev& x ) 
{ locint x_start_loc=x.loc();

  if (start_loc != x_start_loc)
  /* test this to avoid  adjoint(x)=0 for x=x in reverse */
  { if (trace_flag) 
    { // old: write_assign_av(size,start_loc,x_start_loc);
      put_op(assign_av);
      put_locint(x_start_loc); // = arg
      put_locint(size);
      put_locint(start_loc);   // = res

      vs_ptr += size;
      //if (revalso) 
        write_scaylors((store+start_loc),size);
    }

    for (int i=0; i<size; i++)
      store[start_loc+i] = store[x_start_loc+i];
  }
  return *this;
}   

/*--------------------------------------------------------------------------*/
/* Assign an adouble vector an independent float vector */
adoublev& adoublev::operator <<= ( double* coval ) 
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:IND EQ double*\n");
#endif

  if (trace_flag)
  { // old: write_assign_indvec(size,start_loc,coval);
    ind_ptr += size;
    put_op(assign_indvec);
    put_locint(size);
    put_locint(start_loc); // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[(start_loc)+i] = coval[i];
  return *this;
}   

/*--------------------------------------------------------------------------*/
/* Assign a float vector a dependent adouble vector */
adoublev& adoublev::operator >>= ( double* coval ) 
{  
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:DEP EQ double* operator\n");
#endif
  if (trace_flag) 
  { // old: write_assign_depvec(size,start_loc);
    dep_ptr += size;
    put_op(assign_depvec);
    put_locint(size);
    put_locint(start_loc); // = res
  }

  for (int i=0; i<size; i++)
    coval[i] = double (store[(start_loc)+i]);
  return *this;
}   


/****************************************************************************/
/*                                            VECTOR OPERATION + ASSIGNMENT */

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator -= ( const badoublev& y ) 
{ if (trace_flag)
  { // old: write_av_same_arg(eq_min_av,size,start_loc,y.start_loc);
    put_op(eq_min_av);
    put_locint(y.start_loc); // = arg
    put_locint(size);
    put_locint(start_loc);   // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[start_loc+i] -= store[y.start_loc+i];
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator += ( const badoublev& y ) 
{ if (trace_flag)
  { // old: write_av_same_arg(eq_plus_av,size,start_loc,y.start_loc);
    put_op(eq_plus_av);
    put_locint(y.start_loc); // = arg
    put_locint(size);
    put_locint(start_loc);   // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }
  
  for (int i=0; i<size; i++)
    store[start_loc+i] += store[y.start_loc+i];
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator *= ( double coval ) 
{ if (trace_flag)
  { // old: write_samearg_av_d(eq_mult_av_d,size,start_loc,coval);
    put_op(eq_mult_av_d);
    put_locint(size);
    put_locint(start_loc); // = res
    put_val(coval);

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (int i=0; i<size; i++)
    store[start_loc+i] *= coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator *= ( const badouble& y ) 
{ int loc = y.loc();

  if (trace_flag)
  { // old: write_av_same_arg(eq_mult_av_a,size,start_loc,loc);
    put_op(eq_mult_av_a);
    put_locint(loc);       // = arg
    put_locint(size);
    put_locint(start_loc); // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  /* olvo 980930 use tempory to allow overwrites */
  double tmpVal = store[loc];
  for (int i=0; i<size; i++)
    store[start_loc+i] *= tmpVal;
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator /= ( double coval ) 
{ *this = *this / coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
badoublev& badoublev::operator /= ( const badouble& y ) 
{*this = *this * (1.0/y);
  return *this;
}


/****************************************************************************/
/*                                                 BINARY VECTOR OPERATIONS */

/*--------------------------------------------------------------------------*/
adubv operator + ( const badoublev &arg1, const badoublev &arg2 )
{ locint size      = arg1.size;
  locint start_loc = next_loc(size);

#if defined(ADOLC_DEBUG)
  if (arg1.size != arg2.size)
  { fprintf(DIAG_OUT,"ADOL-C error: Can not add vectors as not same size\n");
    exit(-3);
  }
#endif

  if (trace_flag) 
  { // old: write_two_av_rec(plus_av_av,size,start_loc,
    //			     arg1.start_loc,arg2.start_loc);
    put_op(plus_av_av);
    put_locint(arg1.start_loc); // = arg1
    put_locint(arg2.start_loc); // = arg2
    put_locint(size);
    put_locint(start_loc);      // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  for (locint i=0; i<size; i++)
    store[start_loc+i] =   store[arg1.start_loc+i]
                         + store[arg2.start_loc+i];
  return adubv(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adubv operator * ( const badoublev &arg, double coval )
{ locint size = arg.size;
  locint start_loc = next_loc(size);

  if (trace_flag)
  { // old:  write_args_d_av(mult_d_av,size,start_loc,coval,arg.start_loc);
    put_op(mult_d_av);
    put_locint(arg.start_loc); // = arg
    put_locint(size);
    put_locint(start_loc);     // = res
    put_val(coval);            // = coval

    vs_ptr += size;
    //if (revalso)
       write_scaylors((store+start_loc),size);
  }

  for (locint i=0; i<size; i++)
    store[start_loc+i] = store[arg.start_loc+i]*coval;
  return adubv(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adubv operator * ( double coval, const badoublev &arg )
{ locint size = arg.size;
  locint start_loc = next_loc(size);

  if (trace_flag)
  { // old: write_args_d_av(mult_d_av,size,start_loc,coval,arg.start_loc);
    put_op(mult_d_av);
    put_locint(arg.start_loc); // = arg
    put_locint(size);
    put_locint(start_loc);     // = res
    put_val(coval);            // = coval

    vs_ptr += size;
    //if (revalso)
       write_scaylors((store+start_loc),size);
  }    

  for (locint i=0; i<size; i++)
    store[start_loc+i] = store[arg.start_loc+i]*coval;  
  return adubv(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adub operator* ( const badoublev &arg1, const badoublev &arg2 ) 
//adub operator_mult ( const badoublev &arg1, const badoublev &arg2 ) 
{ 
  locint locat = next_loc();
  

#if defined(ADOLC_DEBUG)
#error
  if (arg1.size!=arg2.size)
  { fprintf(DIAG_OUT,"ADOL-C error: Can not take dot product,"
                     " vectors are not same size\n");
    exit(-3);
  }
#endif

  if (trace_flag)
  { // old: write_dot_av_av(arg1.size,locat,arg1.start_loc,arg2.start_loc);
    put_op(dot_av_av);
    put_locint(arg1.start_loc); // = arg1
    put_locint(arg2.start_loc); // = arg2
    put_locint(arg1.size);
    put_locint(locat);      // = res

    vs_ptr++;
    //if (revalso)
      write_scaylor(store[locat]);
  }

  double x = 0;    
/*
  for (int i=0; i<arg1.size; i++)
     x += store[arg1.start_loc+i] * store[arg2.start_loc+i];
*/

  const double* p1 = &store[arg1.start_loc];
  const double* p2 = &store[arg2.start_loc];
  const int arg1size = arg1.size;
  for (int i=0; i<arg1size; i++)
     x += (*p1++) * (*p2++);


  store[locat] = x;
  return locat;
}

/*--------------------------------------------------------------------------*/
adubv operator / ( const badoublev &x, const badouble &y )
{ int loc  = y.loc();
  int size = x.size;
  locint start_loc = next_loc(size);

  if (trace_flag)
  { // old: write_av_a_rec(div_av_a,size,start_loc,x.start_loc,loc);
    put_op(div_av_a);
    put_locint(x.start_loc); // = arg1
    put_locint(loc);         // = arg2
    put_locint(size);
    put_locint(start_loc);   // = res

    vs_ptr += size;
    //if (revalso)
      write_scaylors((store+start_loc),size);
  }
  
  for (int i=0; i<size; i++)
    store[start_loc+i] = store[x.start_loc+i]*(1.0/store[loc]);
  return adubv(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adubv operator - ( const badoublev &arg1, const badoublev &arg2 )
{ locint size = arg1.size;
  locint start_loc = next_loc(size);
#if defined(ADOLC_DEBUG)
  if (arg1.size != arg2.size)
  { fprintf(DIAG_OUT,"ADOL-C error: Can not add vectors as not same size\n");
    exit(-3);
  }
#endif
      
  if (trace_flag) 
  { // old: write_two_av_rec(sub_av_av,size,start_loc,
    //			     arg1.start_loc,arg2.start_loc);
    put_op(sub_av_av);
    put_locint(arg1.start_loc); // = arg1
    put_locint(arg2.start_loc); // = arg2
    put_locint(size);
    put_locint(start_loc);      // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }
      
  for (locint i=0; i<size; i++)
    store[start_loc+i] =  store[arg1.start_loc+i]
                        - store[arg2.start_loc+i];
  return adubv(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adubv operator * ( const badoublev &arg, const badouble &n )
{ int loc = n.loc();
  int size = arg.size;
  locint start_loc = next_loc(size);

  if (trace_flag)
  { // old: write_av_a_rec(mult_av_a,size,start_loc,arg.start_loc,loc);
    put_op(mult_a_av);
    put_locint(arg.start_loc); // = arg1
    put_locint(loc);           // = arg2
    put_locint(size);
    put_locint(start_loc);     // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  /* olvo 980930 use tempory to allow overwrites */
  double tmpVal = store[loc];
  for (int i=0; i<size; i++)
    store[start_loc+i] = store[arg.start_loc+i]*tmpVal;    
  return adubv(start_loc,size);
}

/*--------------------------------------------------------------------------*/
adubv operator * ( const badouble &n, const badoublev &arg )
{ int loc = n.loc();
  int size = arg.size;
  locint start_loc = next_loc(size);

  if (trace_flag)
  { // old: write_av_a_rec(mult_a_av,size,start_loc,arg.start_loc,loc);
    put_op(mult_a_av);
    put_locint(arg.start_loc); // = arg1
    put_locint(loc);           // = arg2
    put_locint(size);
    put_locint(start_loc);     // = res

    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);
  }

  /* olvo 980930 use tempory to allow overwrites */
  double tmpVal = store[loc];
  for (int i=0; i<size; i++)
    store[start_loc+i] = store[arg.start_loc+i]*tmpVal;    
  return adubv(start_loc,size);
}

/****************************************************************************/
/*                                                             MATRIX STUFF */

/*--------------------------------------------------------------------------*/
adoublem::adoublem(int row, int col)
{ m = row;
  n = col;
  index = new adoublev[m];
  for (int i=0; i<m; i++)
  { index[i].size = n;
    index[i].start_loc = next_loc(n);
  }

  //EGK added this
  for (int i=0; i<m; i++)
     index[i] = 0.0;
}

/*--------------------------------------------------------------------------*/
adoublem::adoublem(const adoublem &arg)
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:Declaring active matrix and initializing"
                   " from adoublem\n");
#endif
  m = arg.m;
  n = arg.n;
  index = new adoublev[m];
  for (int i=0; i < m; i++)
  { index[i].size = n;
    index[i].start_loc = next_loc(n);

    if (trace_flag)
    { /* old: write_intvec_assign_av(n, index[i].start_loc,
         arg.index[i].start_loc); */
      put_op(assign_av);
      put_locint(arg.index[i].start_loc); // = arg
      put_locint(n);                      // = size
      put_locint(index[i].start_loc);     // = res

      vs_ptr += n;
      //if (revalso) 
        write_scaylors((store+(index[i].start_loc)),n);
    }

    for (int j=0; j < n; j++)
      store[index[i].start_loc+j] = store[arg.index[i].start_loc+j];
  } 
}

/*--------------------------------------------------------------------------*/
/* // EGK: made inline
adoublev& adoublem::operator[]( int i ) 
{// if (i<0 || i>=m)
 // { fprintf (DIAG_OUT,"ADOL-C error: adoublem index out of range.\n");
 //   exit(-3);
 // }
  return index[i];
}
*/
/*--------------------------------------------------------------------------*/
asub badoublev::operator[]( const along &i )  const
{ int j=(int)(store[i.loc()]);
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:In along overloaded []\n");
#endif
  /* Used so can access the vector like an array with the [] */
  /* Check if out of range */
  if ((j<0) || (j>=size))
    fprintf (DIAG_OUT,"ADOL-C warning:: adoublev index out of range.\n");
  return asub(start_loc,i.loc());
}

/****************************************************************************/
/*                                                         ASUBV OPERATIONS */

#ifdef overwrite
/*--------------------------------------------------------------------------*/
asubv::~asubv()
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug:Destructing active subscript vector\n");
#endif
  free_loc(start_loc,size);
}

#endif

/*--------------------------------------------------------------------------*/
asubv::asubv( adoublev* start, locint index )
{
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug: Constructing an asubv with 3 arguments\n");
#endif
  begin  = (start[0]).loc(); /* start of matrix */
  base   = (start[(int)store[index]]).loc(); /* start of the i-th row */
  offset = index;
  size   = (start[(int)store[index]]).sz(); /* size of the row-vector */
  start_loc = next_loc(size);

  if (trace_flag)
  { // old: write_associating_vector(m_subscript,start_loc,begin,offset,size);
    put_op(m_subscript);
    put_locint(begin);
    put_locint(offset);
    put_locint(size);
    put_locint(start_loc);
    put_val(store[offset]);

    /* olvo 980721 new n3l */
    vs_ptr += size;
    //if (revalso)
      write_scaylors(store+start_loc,size); 
  }

  for(int i=0;i<size;i++)
    store[start_loc+i] = store[base+i];
}


/*--------------------------------------------------------------------------*/
asubv adoublem::operator[]( const along &i )
{ int j = (int)(store[i.loc()]);
#if defined(ADOLC_DEBUG)
  fprintf(DIAG_OUT,"ADOL-C debug: In along overloaded []\n");
#endif
  /* Used so can access the vector like an array with the [] */
  /* Check if out of range */
  if (j<0 || j>=n)
    fprintf (DIAG_OUT,"ADOL-C warning:: adoublem index out of range.\n");
  return asubv(index,i.loc());
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator = ( const adubv& a )
{ if (trace_flag)
  { // old: write_associating_vector(m_subscript_l,a.loc(),begin,offset,size);
    put_op(m_subscript_l);
    put_locint(begin);
    put_locint(offset);
    put_locint(size);
    put_locint(a.loc());
    put_val(store[offset]);

    vs_ptr+=size;
    //if (revalso)
      write_scaylors((store+(begin+(int)store[offset])),size); 
  }

  for(int i=0;i<size;i++)
    store[base+i] = store[a.loc()+i] ;
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator = ( const badoublev& x )
{ if (trace_flag)
  { //old: write_associating_vector(m_subscript_l,x.loc(),begin,offset,size);
    put_op(m_subscript_l);
    put_locint(begin);
    put_locint(offset);
    put_locint(size);
    put_locint(x.loc());
    put_val(store[offset]);

    vs_ptr+=size;
    //if (revalso)
      write_scaylors((store+(begin+(int)store[offset])),size); 
  }

  for(int i=0;i<size;i++)
    store[base+i] = store[x.loc()+i];
  return *this;
}  

/*--------------------------------------------------------------------------*/
asubv& asubv::operator <<= (double* y)
{ if (trace_flag)
  { // old: write_assign_indvec(size,start_loc,y);
    ind_ptr += size;
    put_op(assign_indvec);
    put_locint(size);
    put_locint(start_loc);
  
    vs_ptr += size;
    //if (revalso) 
      write_scaylors((store+start_loc),size);

    /* old: write_associating_vector(m_subscript_l,start_loc,
       begin,offset,size); */
    put_op(m_subscript_l);
    put_locint(begin);
    put_locint(offset);
    put_locint(size);
    put_locint(start_loc);
    put_val(store[offset]);

    vs_ptr+=size;
    //if (revalso)
      write_scaylors((store+(begin+(int)store[offset])),size); 
  }
  for(int i=0;i<size;i++)
    store[base+i] = y[i];
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator = (double* x)
{ if (trace_flag)
  { // old: write_associating_vector_ld(x,begin,offset,size);
    locint space_left = get_val_space(), 
           vals_left  = size, 
           loc        = 0;
    double *d = x;    
  
    while (space_left < vals_left)
    { put_op(m_subscript_ld);
      put_locint(begin);
      put_locint(offset);
      put_val(store[offset]);
      put_locint(loc);
      put_locint(space_left);
      put_vals_p(d,space_left);
      d         += space_left;
      vals_left -= space_left;
      loc       += space_left;
      space_left=get_val_space();
    }

    if (vals_left > 0)
    { put_op(m_subscript_ld);
      put_locint(begin);
      put_locint(offset);
      put_val(store[offset]);
      put_locint(loc);
      put_locint(vals_left);
      put_vals_r(d,vals_left);
    }

    vs_ptr += size;
    //if (revalso)
      write_scaylors((store+(begin+(int)store[offset])),size);
  }

  for(int i=0;i<size;i++)
    store[base+i] = x[i];
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator = ( const asubv& x )
{ if (trace_flag)
  { // old: write_associating_vector(m_subscript_l,x.loc(),begin,offset,size);
    put_op(m_subscript_l);
    put_locint(begin);
    put_locint(offset);
    put_locint(size);
    put_locint(x.loc());
    put_val(store[offset]);

    vs_ptr+=size;
    //if (revalso)
      write_scaylors((store+(begin+(int)store[offset])),size); 
  }

  for(int i=0;i<size;i++)
    store[base+i] = store[x.loc()+i];
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator += ( const badoublev& x )
{ *this = *this + x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator -= ( const badoublev& x )
{ *this = *this - x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator *= ( const badouble& x )
{ *this = *this * x;
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator *= ( double coval )
{ *this = *this * coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator /= ( const badouble& x )
{ *this = *this * (1.0/x);
  return *this;
}

/*--------------------------------------------------------------------------*/
asubv& asubv::operator /= ( double coval )
{ *this = *this / coval;
  return *this;
}

/*--------------------------------------------------------------------------*/
adubv operator+ ( const badoublev& x )
{ return x * (1.0);
}
  
/*--------------------------------------------------------------------------*/
adubv operator- ( const badoublev& x )
{ return x * (-1.0);
}

/****************************************************************************/
/*                                                                THAT'S ALL*/


//@@@@@@ taputilc.cpp

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     tapeutilc.cpp
 Revision: $Id: taputilc.cpp,v 1.2 2004/05/24 10:50:41 kowarz Exp $
 Contents: C++ interface for initialization and stopage of the taping 
           process

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
        990713 olvo: trace_on/off: default values for arguments 
        981130 olvo: newly created from utils.C
        
----------------------------------------------------------------------------*/

//#include "taputil.h"
//#include "taputil_p.h"
//#include "adouble.h"
//#include "adouble_p.h"

/****************************************************************************/
/*                                                                 TRACE_ON */
/* Trace_on:                                                             
   Initialization for the taping process.  Sets up the arrays op_tape,   
   int_tape, val_tape, and stats.  Op_tape, int_tape, val_tape are arrays
   of pointers to individual buffers for operations, integers (locints), 
   and values (doubles).  Also initializes buffers for this tape, sets   
   files names, and calls appropriate setup routines */
void trace_on( short tnum, int revals )
{ start_trace(tnum,revals);
  take_stock();   /* record all existing adoubles on the tape */
}

/****************************************************************************/
/*                                                                TRACE_OFF */
/* Stop Tracing.  Clean up, and turn off trace_flag */
void trace_off( int flag )
{ int locations;
  locations = keep_stock();     /* copy remaining live variables and turns */
                                /* off trace_flag  */
  stop_trace(locations,flag);   
  std::cout.flush();
}

/****************************************************************************/
/*                                                               THAT'S ALL */



//@@@@@@@ adalloc.c


/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     adalloc.c
 Revision: $Id: adalloc.c,v 1.2 2004/05/24 10:50:27 kowarz Exp $
 Contents: C allocation of arrays of doubles in several dimensions 

 Copyright (c) 2003
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing

 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20040423 kowarz: adapted to configure - make - make install
          20020628 olvo:   Initialization to 0 in myAllocI2(..)
                           + replaced ADOLC_MALLOC
          20000217 olvo:   Version Waechter
          20000214 olvo:   The defininition of the macro USE_CALLOC
                           forces the ADOL-C allocation routines
                           to use 'calloc' instead of 'malloc'.
                           This may help in case of problems with
                           uninitialized memory as reported by Andreas
                           Waechter from CMU.
          19990622 olvo:   special identity allocations (2n-1-vectors)
                           routines for freeing memory
          19981130 olvo:   newly created.

----------------------------------------------------------------------------*/

//#include "adalloc.h"

#if defined(ADOLC_USE_CALLOC)
#  if defined(HAVE_MALLOC)
#     define ADOLC_MALLOC(n,m) calloc(n,m)
#  else
#     define ADOLC_MALLOC(n,m) rpl_calloc(n,m)
#  endif
#else
#  if defined(HAVE_MALLOC)
#     define ADOLC_MALLOC(n,m) malloc(n*m)
#  else
#     define ADOLC_MALLOC(n,m) rpl_malloc(n,m)
#  endif
#endif

BEGIN_C_DECLS

/****************************************************************************/
/*                                              MEMORY MANAGEMENT UTILITIES */

/*--------------------------------------------------------------------------*/
static double* myalloc1(int m)
{ double* A = (double*)ADOLC_MALLOC(m,sizeof(double));
  if (A == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myalloc1 cannot allocate %i bytes\n",
                     (int)(m*sizeof(double)));
    exit (-1);
  }
  return A;
}

/*--------------------------------------------------------------------------*/
static double** myalloc2(int m, int n)
{ double *Adum = (double*)ADOLC_MALLOC(m*n,sizeof(double));
  double   **A = (double**)malloc(m*sizeof(double*));
  int i;
  if (Adum == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myalloc2 cannot allocate %i bytes\n",
                     (int)(m*n*sizeof(double)));
    exit (-1);
  }
  if (A == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myalloc2 cannot allocate %i bytes\n",
                     (int)(m*sizeof(double*)));
    exit (-1);
  }
  for (i=0; i<m; i++)
  { A[i] = Adum;
    Adum += n;
  }
  return A;
}

/*--------------------------------------------------------------------------*/
static double*** myalloc3(int m, int n, int p)
{ /* This function allocates 3-tensors contiguously */ 
  double *Adum = (double*) ADOLC_MALLOC(m*n*p,sizeof(double));
  double **Apt = (double**)malloc(m*n*sizeof(double*));
  double  ***A = (double***)malloc(m*sizeof(double**));
  int i,j;
  if (Adum == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myalloc3 cannot allocate %i bytes\n",
                     (int)(m*n*p*sizeof(double)));
    exit (-1);
  }
  if (Apt == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myalloc3 cannot allocate %i bytes\n",
                     (int)(m*n*sizeof(double*)));
    exit (-1);
  }
  if (A == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myalloc3 cannot allocate %i bytes\n",
                     (int)(m*sizeof(double**)));
    exit (-1);
  }
  for (i=0; i<m; i++)
  { A[i] = Apt;
    for (j=0; j<n; j++)
    { *Apt++ =  Adum;
      Adum += p;
    }
  }   
  return A;
}

/*--------------------------------------------------------------------------*/
static void myfree1(double   *A)
{ free((char*) A);
}

/*--------------------------------------------------------------------------*/
static void myfree2(double  **A)
{ free((char*)*A); free((char*) A);
}

/*--------------------------------------------------------------------------*/
static void myfree3(double ***A)
{ free((char*)**A); free((char*)*A); free((char*) A);
}


/****************************************************************************/
/*                                          SPECIAL IDENTITY REPRESENTATION */

/*--------------------------------------------------------------------------*/
static double   **myallocI2(int n)
{ double *Idum = (double*)ADOLC_MALLOC((2*n-1),sizeof(double));
  double   **I = (double**)malloc(n*sizeof(double*));
  int i;
  if (Idum == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myallocI2 cannot allocate %i bytes\n",
                     (int)((2*n-1)*sizeof(double)));
    exit (-1);
  }
  if (I == NULL)
  { fprintf(DIAG_OUT,"ADOL-C error: myallocI2 cannot allocate %i bytes\n",
                     (int)(n*sizeof(double*)));
    exit (-1);
  }
  I[0] = Idum+=(n-1); 
  *Idum = 1.0;
  /* 20020628 olvo n3l: Initialization to 0 */
  for (i=1; i<n; i++)
    *(++Idum)= 0.0;
  Idum-=(n-1);
  for (i=1; i<n; i++)
  { I[i] = --Idum;
    *Idum = 0.0;
  }
  return I;
}

/*--------------------------------------------------------------------------*/
static void myfreeI2(int n, double** I)
{ free((char*)I[n-1]); free((char*) I);
}

END_C_DECLS



//@@@@@@@ malloc.c


/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     malloc.c
 Revision: $Id$
 Contents: malloc replacements for not gnu compatible malloc system functions

 Copyright (c) 2005
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

History:
         20050617 kowarz: initial version

----------------------------------------------------------------------------*/

//#include "malloc.h"

//#undef malloc
//#undef realloc
//#undef calloc
#include <stdlib.h>
//void *malloc();
//void *calloc();
//void *realloc();

/* Allocate an n-byte block from heap, n>=1 */

void *rpl_malloc(size_t n) {
   if (n==0) n=1;
   return malloc(n);
}

void *rpl_calloc(size_t n, size_t size) {
   if (n==0) n=1;
   if (size==0) size=1;
   return calloc(n, size);
}

void *rpl_realloc(void *ptr, size_t size) {
   if (size==0) size=1;
   if (ptr==NULL) ptr=rpl_malloc(1);
   return realloc(ptr, size);
}



//@@@@@@@ fo_rev.c


#define _FOS_ 1

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     fo_rev.c
 Revision: $Id: fo_rev.c,v 1.3 2004/05/27 12:50:06 kowarz Exp $
 Contents: Contains the routines :
           fos_reverse (first-order-scalar reverse mode)  : define _FOS_
           fov_reverse (first-order-vector reverse mode)  : define _FOV_

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20040423 kowarz: adapted to configure - make - make install
          20030305 andrea: change taylor_back
          19991122 olvo:   new op_codes eq_plus_prod eq_min_prod
                           for  y += x1 * x2
                           and  y -= x1 * x2  
          19981130 olvo:   last check (includes ...)
          19980929 olvo:   allow reflexive operations for
                           - vector operations: eq_mult_av_a,
                             mult_a_av, div_av_a
          19980924 olvo:   (1) Lots of small changes (Atemp, At --> Aqo)
                           (2) new macros AQO*
                           (3) deleted all int_* opcodes
                           (4) allow reflexive operations for
                               - cond_assign, cond_assign_s
                               (changed code completely)
          19980922 olvo:   (1) allow reflexive operations for
                               - div_d_a, div_a_a
          19980921 olvo:   (1) changed save-order in sin/cos
                           (2) allow reflexive operations for
                               - pow
          19980820 olvo:   new comparison strategy 
          19980721 olvo:   write of taylors in subscript and
                           subscript_m   
          19980714 olvo:   some error elimination
                           op-code mult_av_a removed  
          19980713 olvo:   debugging and optimizing
          19980710 olvo:   sin/cos writes 2 taylors
          19980709 olvo:   new operation code: neg_sign_a
                                               pos_sign_a
          19980706 olvo:   new operation code: int_adb_d_one
                                               int_adb_d_zero
          19980703 olvo:   new operation code: assign_d_one
                                               assign_d_zero
          19980626 olvo:   vector operations & subscripts
          19980623 mitev/olvo: revision + stock stuff 
          19980616 olvo:   griewank's idea II
          19980615 olvo:   griewank's idea
          19980612 mitev
          
----------------------------------------------------------------------------*/

/*****************************************************************************
 
  There are four basic versions of the procedure `reverse', which
  are optimized for the cases of scalar or vector reverse sweeps
  with first or higher derivatives, respectively. In the calling
  sequence this distinction is apparent from the type of the
  parameters `lagrange' and `results'. The former may be left out
  and the integer parameters `depen', `indep', `degre', and `nrows'
  must be set or default according to the following matrix of
  calling cases. 

           no lagrange         double* lagrange     double** lagrange

double*   gradient of scalar   weight vector times    infeasible 
results   valued function      Jacobian product       combination

          ( depen = 1 ,         ( depen > 0 ,         
	    degre = 0 ,           degre = 0 ,              ------
	    nrows = 1 )           nrows = 1 )

double**  Jacobian of vector   weight vector times     weight matrix
results   valued function      Taylor-Jacobians        times Jacobian
           
	  ( 0 < depen           ( depen > 0 ,          ( depen > 0 ,
	      = nrows ,           degre > 0 ,            degre = 0 ,
	    degre = 0 )           nrows = 1 )            nrows > 0 )

double*** full family of         ------------          weigth matrix x
results   Taylor-Jacobians       ------------          Taylor Jacobians

*****************************************************************************/ 

/****************************************************************************/
/*                                                                   MACROS */
#undef _ADOLC_VECTOR_

/*--------------------------------------------------------------------------*/
#ifdef _FOS_
#define GENERATED_FILENAME "fos_reverse"              

#define RESULTS(l,indexi)  results[indexi]
#define LAGRANGE(l,indexd) lagrange[indexd] 

/*--------------------------------------------------------------------------*/
#elif _FOV_
#define GENERATED_FILENAME "fov_reverse"             

#define _ADOLC_VECTOR_

#define RESULTS(l,indexi)  results[l][indexi]
#define LAGRANGE(l,indexd) lagrange[l][indexd] 

#else
#error Error ! Define [_FOS_ | _FOV_] 
#endif

/*--------------------------------------------------------------------------*/
/*                                                     access to variables  */

#ifdef _FOS_
#define ARES       *Ares
#define AARG       *Aarg
#define AARG1      *Aarg1
#define AARG2      *Aarg2
#define AQO        *Aqo

#define ARES_INC   *Ares
#define AARG_INC   *Aarg
#define AARG1_INC  *Aarg1
#define AARG2_INC  *Aarg2
#define AQO_INC    *Aqo

#define ARES_INC_O  Ares
#define AARG_INC_O  /adAarg
#define AARG1_INC_O Aarg1
#define AARG2_INC_O Aarg2
#define AQO_INC_O   Aqo

#define ASSIGN_A(a,b)  a = &b;

#else  /* _FOV_, _HOS_, _HOV_ */
#define ARES       *Ares
#define AARG       *Aarg
#define AARG1      *Aarg1
#define AARG2      *Aarg2
#define AQO        *Aqo

#define ARES_INC   *Ares++
#define AARG_INC   *Aarg++
#define AARG1_INC  *Aarg1++
#define AARG2_INC  *Aarg2++
#define AQO_INC    *Aqo++

#define ARES_INC_O  Ares++
#define AARG_INC_O  Aarg++
#define AARG1_INC_O Aarg1++
#define AARG2_INC_O Aarg2++
#define AQO_INC_O   Aqo++

#define ASSIGN_A(a,b)  a = b;
#endif

#define TRES       T[res]
#define TARG       T[arg]
#define TARG1      T[arg1]
#define TARG2      T[arg2]

#define ASSIGN_T(a,b)

/*--------------------------------------------------------------------------*/
/*                                                              loop stuff  */
#ifdef _ADOLC_VECTOR_
#define FOR_0_LE_l_LT_p for (l=0; l<p; l++)  
#define FOR_p_GT_l_GE_0 for (l=p-1; l>=0; l--)  
#else
#define FOR_0_LE_l_LT_p 
#define FOR_p_GT_l_GE_0  
#endif
 
#define FOR_0_LE_i_LT_k  
#define FOR_k_GT_i_GE_0  

#ifdef _HOV_
#define FOR_0_LE_l_LT_pk1 for (l=0; l<pk1; l++)  
#elif _FOV_
#define FOR_0_LE_l_LT_pk1 for (l=0; l<p; l++)  
#elif _HOS_
#define FOR_0_LE_l_LT_pk1 for (l=0; l<k1; l++)  
#else
#define FOR_0_LE_l_LT_pk1
#endif


/****************************************************************************/
/*                                                       NECESSARY INCLUDES */
//#include "adolc.h"
//#include "interfaces.h"
//#include "adalloc.h"
//#include "oplate.h"
//#include "taputil.h"
//#include "taputil_p.h"
//#include "tayutil.h"
//#include "tayutil_p.h"
extern unsigned char *g_op_ptr;
extern locint        *g_loc_ptr;
extern double        *g_real_ptr;
#define get_op_r() *(--g_op_ptr)
#define get_locint_r() *(--g_loc_ptr)
#define get_val_r() *(--g_real_ptr)

/*#include <malloc.h>*/
#include <math.h>
/*#include <assert.h>*/

BEGIN_C_DECLS

/****************************************************************************/
/*                                                             NOW THE CODE */

/*--------------------------------------------------------------------------*/
/*                                                   Local Static Variables */

// EGK: changed tag to tag__ to avoid conflict
//static short tag;
static short tag__;

static int rev_location_cnt;
static int dep_cnt;
static int ind_cnt;

#ifdef _FOS_

/* Begin EGK */
int currently_in_initial_timestep = 1;

/*
static double* new_adjoint_values = 0;
static locint* new_adjoint_locations = 0;
static int number_of_adjoints_to_modify = 0;
static int modify_adjoints_flag = 0;
*/
  
/* This function can be used to set the adjoint at any desired time.
 * This is usefull for checkpointing of one
 */

static double* adjointsPtr = 0;
static revreal* TPtr = 0;

void modify_adjoints(double *vals,locint *locs, int n)
{
   /*printf("vals: %p",vals);*/
   /*printf("locs: %p",locs);*/

   int number_of_adjoints_to_modify = n;
   double* new_adjoint_values = vals;
   locint* new_adjoint_locations = locs;

   int i;
   for(i=0; i<number_of_adjoints_to_modify; i++)
   {
#ifndef NDEBUG
      if(static_cast<int>(new_adjoint_locations[i]) >= rev_location_cnt)
      {
	 printf("index too large  %i \n",i);
	 abort();
      }
      if(new_adjoint_locations[i] < 0)
      {
	 printf("index negative  %i \n",i);
	 abort();
      }
#endif      
      
      adjointsPtr[ new_adjoint_locations[i] ] = new_adjoint_values[i];
   }
   
   
}

double* get_adjoints_ptr()
{
#ifndef NDEBUG
   if(adjointsPtr==0)
   {
      printf("adjointPtr is NULL \n");
      abort();
   }
#endif 

   return adjointsPtr;
}
revreal* get_T_ptr()
{
#ifndef NDEBUG
   if(TPtr==0)
   {
      printf("TPtr is NULL \n");
      abort();
   }
#endif 

   return TPtr;
}


/*void get_adjoint(double *a,int *locs, int n)
{
   assert(adjoint_pointer != 0);

   int i;
   for(i=0; i<n; i++)
     a[i] = adjoint_pointer[ locs[i] ];
}
int get_number_of_adjoints()
{
   return rev_location_cnt;
}
 */
/* End EGK */

   
       
/****************************************************************************/
/* First-Order Scalar Reverse Pass.                                         */
/****************************************************************************/
int revolve_fos_reverse(short   tnum,       /* tape id */
                int     depen,      /* consistency chk on # of deps */
                int     indep,      /* consistency chk on # of indeps */
                double  *lagrange,
                double  *results)   /*  coefficient vectors */

#elif _FOV_
/****************************************************************************/
/* First-Order Vector Reverse Pass.                                         */
/****************************************************************************/

int fov_reverse(short   tnum,        /* tape id */
                int     depen,       /* consistency chk on # of deps */
                int     indep,       /* consistency chk on # of indeps */
                int     nrows,       /* # of Jacobian rows being calculated */
                double  **lagrange,  /* domain weight vector */
                double  **results)   /* matrix of coefficient vectors */  

#endif 

{
/****************************************************************************/
/*                                                           ALL VARIABLES  */
  unsigned char operation; /* operation code */
  int tape_stats[11];      /* tape stats */
  int ret_c=3;             /* return value */

  locint size = 0;
  locint res  = 0;
  locint arg  = 0;
  locint arg1 = 0;
  locint arg2 = 0;

  double coval = 0, *d = 0;

  int indexi = 0,  indexd = 0;

  /* loop indices */
#if defined(_FOS_)
  int i;
#else
  int l;
#endif
  int j, ls;

  /* other necessary variables */
  double r0, r_0;
  int buffer;
  static int rax;
#if defined(_FOV_)
  static int pax;
#endif
  int taycheck;
  int numdep,numind;
  double aTmp;

/*--------------------------------------------------------------------------*/
  /* Taylor stuff */
  static revreal *T;
 
/*--------------------------------------------------------------------------*/
  /* Adjoint stuff */
#ifdef _FOS_
  static double* A;
  double Atemp;
#else /* _FOV_, _HOS_, _HOV_ */  
  static double** A;
  static double *Atemp;
#endif
  double  *Ares, *Aarg, *Aarg1, *Aarg2, *Aqo;

/*--------------------------------------------------------------------------*/

#ifdef _ADOLC_VECTOR_
  int p = nrows;
#endif 

#ifdef _HOV_
  int pk1 = p*k1;
#endif


#ifdef DEBUG
/****************************************************************************/
/*                                                           DEBUG MESSAGES */
  fprintf(DIAG_OUT,"Call of %s(..) with tag: %d, n: %d, m %d,\n",
                   GENERATED_FILENAME, tnum, indep, depen);      
#ifdef _ADOLC_VECTOR_
  fprintf(DIAG_OUT,"                    p: %d\n\n",nrows);
#endif
  
#endif


/****************************************************************************/
/*                                                                    INITs */

  /*------------------------------------------------------------------------*/
  /* Set up stuff for the tape */

  tag__ = tnum;   /*tag__ is global which indicates which tape to look at */
        
  tapestats(tag__,tape_stats);
  ind_cnt          = tape_stats[0];
  dep_cnt          = tape_stats[1];
  rev_location_cnt = tape_stats[2];
  buffer           =  tape_stats[4];

  set_buf_size(buffer);

/* EGK */
#ifndef _FOS_
  if ((depen != dep_cnt)||(indep != ind_cnt))
  { fprintf(DIAG_OUT,"ADOL-C error: Reverse sweep on tape %d  aborted!\n",tag__);
    fprintf(DIAG_OUT,"Number of dependent and/or independent variables "
             "passed to reverse is\ninconsistent with number "
             "recorded on tape %d \n",tag__);
    exit (-1);
  }
#endif

   
  indexi = ind_cnt - 1;
  indexd = dep_cnt - 1;


/****************************************************************************/
/*                                                  MEMORY ALLOCATION STUFF */

/*--------------------------------------------------------------------------*/
#ifdef _FOS_                                                         /* FOS */
  if (rev_location_cnt compsize rax) 
  { 
     
     /* Begin EGK */
     /*If we are not in the initial timestep then abort
      since the allocation only needs to be done once */
     if(currently_in_initial_timestep == 0)
     {
	printf("Fatal error: attempt to change size of Trs, As\n");
	printf("rev_location_cnt = %i\n",rev_location_cnt);
	printf("rax = %i\n",rax);
	exit(1);
     }
     /* End EGK */

    if (rax)
    { free((char*) T);
      free((char*) A);
    }
    T = (revreal*) malloc(rev_location_cnt*sizeof(revreal));
    A = myalloc1(rev_location_cnt);

     
    if (T == NULL)
    { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate %i bytes !\n",
              rev_location_cnt*sizeof(revreal));
      exit (-1);
    }
    rax = rev_location_cnt;
  }
   
  /* olvo 980924 is following initialization necessary ??? */

   /* Begin EGK */
/*   printf("rev_location_cnt = %i\n",rev_location_cnt); */
   if(currently_in_initial_timestep == 1)
   {
      /*EGK*/
      /* necessary so we can modify the adjoints */
      adjointsPtr = A;
      TPtr = T;

       Aqo = A;
      for (i=0; i<rev_location_cnt; i++) 
	*Aqo++ = 0.0;
      currently_in_initial_timestep = 0;
   }
   /* End EGK */
   
/*--------------------------------------------------------------------------*/
#elif _FOV_                                                          /* FOV */
  if (rev_location_cnt compsize  rax || p compsize pax)
  { if (rax || pax)
    { free((char *) Atemp);
      free((char *) T);
      free((char *) *A); free((char*) A);
    }
    Atemp = myalloc1(p);
    T     = (revreal *)malloc(sizeof(revreal)*rev_location_cnt);
    if (T == NULL)
    { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate %i bytes!\n",
              sizeof(revreal)*rev_location_cnt);
      exit (-1);
    }
    A = myalloc2(rev_location_cnt,p);
    rax = rev_location_cnt;
    pax = p;
  }
#endif


/****************************************************************************/
/*                                                    TAYLOR INITIALIZATION */
  taylor_back(tnum,T,&numdep,&numind,&taycheck);

  if (taycheck < 0)   
  { fprintf(DIAG_OUT,"\n ADOL-C error: reverse fails because it was not"
                   " preceeded\nby a forward sweep with degree>0, keep=1!\n");
    exit(-2);
  };

   
/* EGK */
#ifndef _FOS_
  if((numdep != depen)||(numind != indep))
  { fprintf(DIAG_OUT, "\n ADOL-C error: reverse fails on tape %d because the"
                    " number of\nindependent and/or dependent variables"
                    " given to reverse are\ninconsistent with that of the"
                    " internal taylor array.\n",tag__);
    exit(-2);
  }
#endif

// EGK added the following check. This was necessary because I removed all
// checking for buffer overflow. If, however, buffer overflow did occur, we
// still need to know about it. Hence we check for it here. Note that if
// buffer overflow did occur, we may not even make it this point since the
// program might crash.
  if(loc_ptr >= buff_size || op_ptr >= buff_size || real_ptr >= buff_size ||
     cur_vs_data->taylor_cnt >= cur_vs_data->T_buf_size)
  { fprintf(DIAG_OUT, "\n EGK error: It appears that you ran out of\n"
	    "tape, since one of the *_ptr is greater than buff_size.\n"
	    "This happens as a result of the fact that I disabled writing\n"
	    "to tape and hence also disabled checking for buffer overflow,\n"
	    "so there is no place to catch such an error, other than\n"
	    "immediately before doing a reverse sweep. To fix this problem,\n"
	    "you should either increase the buffer size or shorten the time\n"
	    "steps.\n");
                    

  // print out the sizes of the buffers
  std::cout << "loc_ptr: " << loc_ptr << " / " << buff_size << std::endl;
  std::cout << "op_ptr: " << op_ptr <<  " / " << buff_size << std::endl;
  std::cout << "real_ptr: " << real_ptr <<  " / " << buff_size << std::endl;
  std::cout << "cur_vs_data->taylor_cnt: " << cur_vs_data->taylor_cnt 
	    <<  " / " << cur_vs_data->T_buf_size << std::endl;

    exit(-2);
  }

  // Print out the percentage of the amount of the buffers used every few
  // hundred function calls
  static unsigned int bufferPercentCheck = 0;
  if(bufferPercentCheck++ % 250 == 0)
  {
     if(bufferPercentCheck==1)
     {
	std::cout << "buff_size: " << buff_size << "\n";
	std::cout << "cur_vs_data->T_buf_size: " << cur_vs_data->T_buf_size << "\n";
     }

     std::cout << "loc_ptr: " 
	       << (static_cast<double>(loc_ptr) / static_cast<double>(buff_size)) << "\n";
     std::cout << "op_ptr: " 
	       << (static_cast<double>(op_ptr) / static_cast<double>(buff_size)) << "\n";
     std::cout << "real_ptr: " 
	       << (static_cast<double>(real_ptr) / static_cast<double>(buff_size)) << "\n";
     std::cout << "cur_vs_data->taylor_cnt: " 
	       << (static_cast<double>(cur_vs_data->taylor_cnt) / 
		   static_cast<double>(cur_vs_data->T_buf_size)) << std::endl;
  }

  
/****************************************************************************/
/*                                                            REVERSE SWEEP */

  /* Initialize the Reverse Sweep */
  init_rev_sweep(tag__);

  operation=get_op_r();
  while (operation != start_of_tape) 
  { /* Switch statement to execute the operations in Reverse */
    switch (operation) {


/****************************************************************************/
/*                                                                  MARKERS */

/*--------------------------------------------------------------------------*/
      case end_of_op:                                          /* end_of_op */
        get_op_block_r();
        operation = get_op_r(); 
        /* Skip next operation, it's another end_of_op */
        break;

/*--------------------------------------------------------------------------*/
      case end_of_int:                                        /* end_of_int */
        get_loc_block_r(); /* Get the next int block */
        break;

/*--------------------------------------------------------------------------*/
      case end_of_val:                                        /* end_of_val */
        get_val_block_r(); /* Get the next val block */
        break;

/*--------------------------------------------------------------------------*/
      case start_of_tape:                                  /* start_of_tape */
      case end_of_tape:                                      /* end_of_tape */
	break;


/****************************************************************************/
/*                                                               COMPARISON */

/*--------------------------------------------------------------------------*/
      case eq_zero  :                                            /* eq_zero */
        arg   = get_locint_r();

        ret_c = 0;
        break;

/*--------------------------------------------------------------------------*/
      case neq_zero :                                           /* neq_zero */
      case gt_zero  :                                            /* gt_zero */
      case lt_zero :                                             /* lt_zero */
        arg   = get_locint_r();
        break;

/*--------------------------------------------------------------------------*/
      case ge_zero :                                             /* ge_zero */
      case le_zero :                                             /* le_zero */
        arg   = get_locint_r();

        ASSIGN_T( Targ, T[arg])

        if (TARG == 0)
          ret_c = 0;
        break;


/****************************************************************************/
/*                                                              ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
      case assign_a:           /* assign an adouble variable an    assign_a */
	                       /* adouble value. (=) */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Aarg, A[arg])
	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
        { AARG_INC += ARES;
          ARES_INC = 0.0;
        }

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case assign_d:            /* assign an adouble variable a    assign_d */
	                        /* double value. (=) */
        res   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC = 0.0;
        
        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case assign_d_zero:  /* assign an adouble variable a    assign_d_zero */
      case assign_d_one:   /* double value (0 or 1). (=)       assign_d_one */
        res   = get_locint_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC = 0.0;
        
        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case assign_ind:       /* assign an adouble variable an    assign_ind */
	                     /* independent double value (<<=) */
        res = get_locint_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          RESULTS(l,indexi) = ARES_INC;
        
        get_taylor(res);
	indexi--;
	break;

/*--------------------------------------------------------------------------*/
      case assign_dep:           /* assign a float variable a    assign_dep */
	                         /* dependent adouble value. (>>=) */
        res = get_locint_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC = LAGRANGE(l,indexd);

	indexd--;
	break;


/****************************************************************************/
/*                                                   OPERATION + ASSIGNMENT */

/*--------------------------------------------------------------------------*/
      case eq_plus_d:            /* Add a floating point to an    eq_plus_d */
	                         /* adouble. (+=) */
        res   = get_locint_r();
        coval = get_val_r();

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_plus_a:             /* Add an adouble to another    eq_plus_a */
	                          /* adouble. (+=) */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg]);

        FOR_0_LE_l_LT_p
          AARG_INC += ARES_INC;

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_min_d:       /* Subtract a floating point from an    eq_min_d */
                           /* adouble. (-=) */
        res   = get_locint_r();
        coval = get_val_r();

	get_taylor(res);
	break;
	
/*--------------------------------------------------------------------------*/
      case eq_min_a:        /* Subtract an adouble from another    eq_min_a */
	                    /* adouble. (-=) */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
          AARG_INC -= ARES_INC;

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_d:              /* Multiply an adouble by a    eq_mult_d */
	                           /* flaoting point. (*=) */
        res   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC *= coval;

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_a:       /* Multiply one adouble by another    eq_mult_a */
	                    /* (*=) */
        res = get_locint_r();
        arg = get_locint_r();

 	get_taylor(res);

	ASSIGN_A( Ares, A[res])
        ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])
	ASSIGN_T( Targ, T[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
	  /* olvo 980713 nn: ARES = 0.0; */ 
	  ARES_INC =  aTmp * TARG;
	  AARG_INC += aTmp * TRES; 
        }
        break;
        
/*--------------------------------------------------------------------------*/
      case incr_a:                        /* Increment an adouble    incr_a */
      case decr_a:                        /* Increment an adouble    decr_a */
        res   = get_locint_r();

	get_taylor(res);
	break;


/****************************************************************************/
/*                                                        BINARY OPERATIONS */

/*--------------------------------------------------------------------------*/
      case plus_a_a:                 /* : Add two adoubles. (+)    plus a_a */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Aarg2, A[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp;
          AARG2_INC += aTmp;          
        }

      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case plus_d_a:             /* Add an adouble and a double    plus_d_a */
	                         /* (+) */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp;
        }

      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case min_a_a:              /* Subtraction of two adoubles    min_a_a */
	                         /* (-) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Aarg2, A[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp;
          AARG2_INC -= aTmp;
        }

        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case min_d_a:                /* Subtract an adouble from a    min_d_a */
	                           /* double (-) */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC -= aTmp;
        }

        get_taylor(res);
	break;
	
/*--------------------------------------------------------------------------*/
      case mult_a_a:               /* Multiply two adoubles (*)    mult_a_a */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        get_taylor(res);

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ1, T[arg1])
	ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG2_INC += aTmp * TARG1;
	  AARG1_INC += aTmp * TARG2;
        }
        break;

/*--------------------------------------------------------------------------*/
      /* olvo 991122: new op_code with recomputation */
      case eq_plus_prod:   /* increment a product of           eq_plus_prod */
                           /* two adoubles (*) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ1, T[arg1])
	ASSIGN_T( Targ2, T[arg2])

        /* RECOMPUTATION */
        ASSIGN_T( Tres,  T[res])
        TRES -= TARG1*TARG2;

        FOR_0_LE_l_LT_p
        { AARG2_INC += ARES    * TARG1;
	  AARG1_INC += ARES_INC * TARG2;
        }
        break;

/*--------------------------------------------------------------------------*/
      /* olvo 991122: new op_code with recomputation */
      case eq_min_prod:    /* decrement a product of            eq_min_prod */
                           /* two adoubles (*) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ1, T[arg1])
	ASSIGN_T( Targ2, T[arg2])

        /* RECOMPUTATION */
        ASSIGN_T( Tres,  T[res])
        TRES += TARG1*TARG2;

        FOR_0_LE_l_LT_p
        { AARG2_INC -= ARES    * TARG1;
	  AARG1_INC -= ARES_INC * TARG2;
        }
        break;

/*--------------------------------------------------------------------------*/
      case mult_d_a:         /* Multiply an adouble by a double    mult_d_a */
                             /* (*) */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += coval * aTmp;
        }

        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case div_a_a:           /* Divide an adouble by an adouble    div_a_a */
                              /* (/) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_T( Tres,  T[res])
        ASSIGN_T( Targ2, T[arg2])

	/* olvo 980922 changed order to allow x=y/x */
	r_0 = -TRES;
        get_taylor(res);
        r0  = 1.0 / TARG2;
	r_0 *= r0;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * r0;
	  AARG2_INC += aTmp * r_0;
        }

        break;

/*--------------------------------------------------------------------------*/
      case div_d_a:             /* Division double - adouble (/)    div_d_a */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
	ASSIGN_T( Tres, T[res])
        ASSIGN_T( Targ, T[arg])

	/* olvo 980922 changed order to allow x=d/x */
        r0 = -TRES;
        if (arg == res)
          get_taylor(arg);
        r0 /= TARG;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }

        get_taylor(res);
        break;


/****************************************************************************/
/*                                                         SIGN  OPERATIONS */

/*--------------------------------------------------------------------------*/
      case pos_sign_a:                                        /* pos_sign_a */
        res   = get_locint_r();
        arg   = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp;
        }

      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case neg_sign_a:                                        /* neg_sign_a */
        res   = get_locint_r();
        arg   = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC -= aTmp;
        }

      	get_taylor(res);
	break;


/****************************************************************************/
/*                                                         UNARY OPERATIONS */

/*--------------------------------------------------------------------------*/
      case exp_op:                          /* exponent operation    exp_op */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * TRES;
        }

 	get_taylor(res);
        break;

/*--------------------------------------------------------------------------*/
      case sin_op:                              /* sine operation    sin_op */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * TARG2;
        }

       	get_taylor(res);
       	get_taylor(arg2); /* olvo 980710 covalue */
	                  /* NOTE: A[arg2] should be 0 already */
	break;

/*--------------------------------------------------------------------------*/
      case cos_op:                            /* cosine operation    cos_op */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC -= aTmp * TARG2;          
        }

       	get_taylor(res);
       	get_taylor(arg2); /* olvo 980710 covalue */
	                  /* NOTE A[arg2] should be 0 already */
	break;

/*--------------------------------------------------------------------------*/
      case atan_op:                                             /* atan_op  */
      case asin_op:                                             /* asin_op  */
      case acos_op:                                             /* acos_op  */
      case asinh_op:                                            /* asinh_op */
      case acosh_op:                                            /* acosh_op */
      case atanh_op:                                            /* atanh_op */
      case erf_op:                                              /* erf_op   */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        get_taylor(res);

        ASSIGN_A( Ares,  A[res])
        ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * TARG2;
        }
	break;

/*--------------------------------------------------------------------------*/
      case log_op:                                                /* log_op */
        res = get_locint_r();
        arg = get_locint_r();

        get_taylor(res);

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
	ASSIGN_T( Targ, T[arg])

        r0 = 1.0/TARG;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }
	break;

/*--------------------------------------------------------------------------*/
      case pow_op:                                                /* pow_op */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])
        ASSIGN_T( Targ, T[arg])

	/* olvo 980921 changed order to allow x=pow(x,n) */
        r0 = TRES;
        if (arg == res)
          get_taylor(arg);
        if (TARG == 0.0) 
          r0 = 0.0;
        else
          r0 *= coval/TARG;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }
 
        get_taylor(res);
        break;

/*--------------------------------------------------------------------------*/
      case sqrt_op:                                              /* sqrt_op */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])

        if (TRES == 0.0)
          r0 = 0.0;
        else 
          r0 = 0.5 / TRES;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }
  
        get_taylor(res);
        break;

/*--------------------------------------------------------------------------*/
      case gen_quad:                                            /* gen_quad */
        res   = get_locint_r();
        arg2  = get_locint_r();
        arg1  = get_locint_r();
        coval = get_val_r();
        coval = get_val_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * TARG2;
        }
  
      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case min_op:                                                /* min_op */
        res   = get_locint_r();
        arg2  = get_locint_r();
        arg1  = get_locint_r();
        coval = get_val_r();
  
        get_taylor(res);

        ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_A( Aarg2, A[arg2])
        ASSIGN_A( Ares,  A[res])
        ASSIGN_T( Targ1, T[arg1])
        ASSIGN_T( Targ2, T[arg2])

        if (TARG1 > TARG2)
          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            if ((coval) && (aTmp))
              MINDEC(ret_c,2);
            AARG2_INC += aTmp;
          }
        else 
          if (TARG1 < TARG2)
            FOR_0_LE_l_LT_p
            { aTmp = ARES;
              ARES_INC = 0.0; 
              if ((!coval) && (aTmp))
                MINDEC(ret_c,2);
              AARG1_INC += aTmp;
            }
          else
          { /* both are equal */
            FOR_0_LE_l_LT_p
            { aTmp = ARES / 2.0;
              ARES_INC = 0.0; 
              AARG2_INC += aTmp;
              AARG1_INC += aTmp;
            }
            if (arg1 != arg2)
              MINDEC(ret_c,1);
          }
        break;

/*--------------------------------------------------------------------------*/
      case abs_val:                                              /* abs_val */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();
  
        get_taylor(res);

        ASSIGN_A( Ares, A[res])
        ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Targ, T[arg])

        if (TARG < 0.0)
          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            if ((coval) && (aTmp))
              MINDEC(ret_c,2);
            AARG_INC -= aTmp;
          } 
        else 
          if (TARG > 0.0)
            FOR_0_LE_l_LT_p
            { aTmp = ARES;
              ARES_INC = 0.0; 
              if ((!coval) && (aTmp))
                MINDEC(ret_c,2);
              AARG_INC += aTmp;
            }
          else 
            FOR_0_LE_l_LT_p 
            { aTmp = ARES;
              ARES_INC = 0.0; 
              if (aTmp)        
                MINDEC(ret_c,1);
            }
        break;

/*--------------------------------------------------------------------------*/
      case ceil_op:                                              /* ceil_op */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

        get_taylor(res);

        ASSIGN_A( Ares, A[res])
        ASSIGN_T( Targ, T[arg])

        coval = (coval != ceil(TARG) );

        FOR_0_LE_l_LT_p
        { if ((coval) && (ARES))
            MINDEC(ret_c,2);
          ARES_INC = 0.0;
        }
        break;

/*--------------------------------------------------------------------------*/
      case floor_op:                                            /* floor_op */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

        get_taylor(res);

        ASSIGN_A( Ares, A[res])
        ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Targ, T[arg])

        coval = ( coval != floor(TARG1) );

        FOR_0_LE_l_LT_p
        { if ( (coval) && (ARES) )
            MINDEC(ret_c,2);
          ARES_INC = 0.0;
	}
        break;    


/****************************************************************************/
/*                                                             CONDITIONALS */

/*--------------------------------------------------------------------------*/
      case cond_assign:                                      /* cond_assign */
        res    = get_locint_r();
        arg2   = get_locint_r();
        arg1   = get_locint_r();
        arg    = get_locint_r();
        coval  = get_val_r(); 

	get_taylor(res);

        ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Ares,  A[res])
        ASSIGN_A( Aarg2, A[arg2])
        ASSIGN_T( Targ,  T[arg])

	/* olvo 980924 changed code a little bit */
        if (TARG > 0.0)
        { if (res != arg1)
            FOR_0_LE_l_LT_p
            { if ((coval <= 0.0) && (ARES))
                MINDEC(ret_c,2);
              AARG1_INC += ARES;
              ARES_INC = 0.0;
	    }
          else
            FOR_0_LE_l_LT_p
              if ((coval <= 0.0) && (ARES_INC))
                MINDEC(ret_c,2);
	}
        else
        { if (res != arg2)
            FOR_0_LE_l_LT_p
            { if ((coval <= 0.0) && (ARES))
                MINDEC(ret_c,2);
              AARG2_INC += ARES;
              ARES_INC = 0.0;
	    }
          else
            FOR_0_LE_l_LT_p
              if ((coval <= 0.0) && (ARES_INC))
                MINDEC(ret_c,2);
	}
        break;

/*--------------------------------------------------------------------------*/
      case cond_assign_s:                                  /* cond_assign_s */
        res   = get_locint_r();
        arg1  = get_locint_r();
        arg   = get_locint_r(); 
        coval = get_val_r();

        get_taylor(res);

        ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Ares,  A[res])
        ASSIGN_T( Targ,  T[arg])
        
	/* olvo 980924 changed code a little bit */
        if (TARG > 0.0)
        { if (res != arg1)
            FOR_0_LE_l_LT_p
            { if ((coval <= 0.0) && (ARES))
                MINDEC(ret_c,2);
              AARG1_INC += ARES;
              ARES_INC = 0.0;
	    }
          else
            FOR_0_LE_l_LT_p
              if ((coval <= 0.0) && (ARES_INC))
                MINDEC(ret_c,2);
	}
        else
          if (TARG == 0.0) /* we are at the tie */
            FOR_0_LE_l_LT_p
              if (ARES_INC)
                MINDEC(ret_c,0);
        break;


/****************************************************************************/
/*                                                       VECTOR ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
      case assign_av:                                          /* assign_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

	res += size;
	arg += size;
        for (ls=size; ls>0; ls--)
	{ res--;             /* Location of left-hand-side  */
	  arg--;             /* Location of right-hand-side */

          /* code for assign_a */
          ASSIGN_A( Aarg, A[arg])
	  ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
	  { AARG_INC += ARES;
	    ARES_INC = 0.0;
	  }

	  get_taylor(res);
	  }
	break;

/*--------------------------------------------------------------------------*/
      case assign_dv:                                          /* assign_dv */
        res  = get_locint_r();
        size = get_locint_r();
        d    = get_val_v_r(size);

        res += size;
        d   += size;
	for (ls=size; ls>0; ls--)
	{ res--;                /* Location of left-hand-side */
	  coval = *(--d);       /* Value of right-hand-side   */     

          /* code for assign_d */
	  ASSIGN_A( Ares, A[res])

	  FOR_0_LE_l_LT_p
	    ARES_INC = 0.0;

	  get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case assign_indvec:                                  /* assign_indvec */
        res  = get_locint_r();
        size = get_locint_r();

        res += size;
	for (ls=size; ls>0; ls--)
	{ res--;             /* Location of the left-hand-side */

          /* code for assign_ind */
	  ASSIGN_A( Ares, A[res])

	  FOR_0_LE_l_LT_p
	    RESULTS(l,indexi) = ARES_INC;
	  indexi--;

	  get_taylor(res);
        }
	reset_val_r();
	break;

/*--------------------------------------------------------------------------*/
      case assign_depvec:                                  /* assign_depvec */
        res  = get_locint_r();
        size = get_locint_r();

        res += size;
	for (ls=size; ls>0; ls--)
	{ res--;             /* Location of the left-hand-side */

	  /* code for assign_dep */
	  ASSIGN_A( Ares, A[res])
            
          FOR_0_LE_l_LT_p
            ARES_INC = LAGRANGE(l, indexd);
	  indexd--;
	}
	break;


/****************************************************************************/
/*                                            VECTOR OPERATION + ASSIGNMENT */

/*--------------------------------------------------------------------------*/
      case eq_plus_av:                                        /* eq_plus_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

        res += size;
        arg += size;
	for (ls=size; ls>0; ls--)
	{ res--;            /* Location of left-hand-side  */
	  arg--;            /* Location on right-hand-side */

          /* code for eq_plus_a */
          ASSIGN_A( Ares, A[res])
	  ASSIGN_A (Aarg, A[arg])

	  FOR_0_LE_l_LT_p
	    AARG_INC += ARES_INC;

          get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case eq_min_av:                                          /* eq_min_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

        res += size;
        arg += size;
	for (ls=size; ls>0; ls--)
	{ res--;              /* Location of left-hand-side  */
	  arg--;              /* Location on right-hand-side */

	  /* code for eq_min_a */ 
	  ASSIGN_A( Ares, A[res])
	  ASSIGN_A( Aarg, A[arg])

	  FOR_0_LE_l_LT_p
	    AARG_INC -= ARES_INC;

          get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_av_d:                                    /* eq_mult_av_d */
        res   = get_locint_r();
        size  = get_locint_r();
        coval = get_val_r();

        res += size;
	for (ls=size; ls>0; ls--)
        { res--;            /* Location of the left-hand-side  */
	  /* coval = fixed;    value on the right-hand-side */

	  /* code for eq_mult_d*/
	  ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
            ARES_INC *= coval;

	  get_taylor(res);
        }
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_av_a:                                    /* eq_mult_av_a */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

        /* olvo 980929 new strategy to check for overwrites 
           (changes computation order) */
        if ((arg >= res) && (arg < res+size)) 
	{ /* FIRST compute the case: res==arg */
          /* simplified code for eq_mult_a*/
	  get_taylor(arg);
	
	  ASSIGN_A( Aarg, A[arg]) 
          ASSIGN_T( Targ, T[arg])

          FOR_0_LE_l_LT_p
            AARG_INC  *= 2.0 * TARG; 
	}

	res += size;
        for (ls=size; ls>0; ls--)
	{ res--;                 /* Location of the left-hand-side  */
	  /* arg    = fixed;        Location on the right-hand-side */
     
          if (res == arg) /* NOW skip this case */
            continue;

          /* code for eq_mult_a*/
	  get_taylor(res);
	
	  ASSIGN_A( Aarg, A[arg]) 
	  ASSIGN_A( Ares, A[res]) 
          ASSIGN_T( Tres, T[res])
          ASSIGN_T( Targ, T[arg])

          FOR_0_LE_l_LT_p
          { r0 = ARES;
	    /* olvo 980713 nn: ARES = 0; */
            ARES_INC  = r0 * TARG; 
            AARG_INC += r0 * TRES; 
          }     
	}
	break;


/****************************************************************************/
/*                                                 BINARY VECTOR OPERATIONS */

/*--------------------------------------------------------------------------*/
      case plus_av_av:                                        /* plus_av_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	res  += size;
	arg1 += size;
	arg2 += size;
        for (ls=size; ls>0; ls--)
	{ arg2--;       /* Location of var 2  */
	  arg1--;       /* Location of var 1  */
	  res--;        /* Location of result */

          /* code for plus_a_a */
	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_A( Aarg2, A[arg2])

	  FOR_0_LE_l_LT_p
	  { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG1_INC += aTmp;
            AARG2_INC += aTmp;          
          }

      	  get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case sub_av_av:                                          /* sub_av_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	res  += size;
	arg1 += size;
	arg2 += size;
        for (ls=size; ls>0; ls--)
	{ arg2--;       /* Location of var 2  */
	  arg1--;       /* Location of var 1  */
	  res--;        /* Location of result */

	  /* code for min_a_a */
	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_A( Aarg2, A[arg2])

	  FOR_0_LE_l_LT_p
	  { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG1_INC += aTmp;
            AARG2_INC -= aTmp;          
          }

          get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case dot_av_av:                                          /* dot_av_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        get_taylor(res);

        /* save Ares to Atemp */
        ASSIGN_A( Aqo,  Atemp)
	ASSIGN_A( Ares, A[res])
        FOR_0_LE_l_LT_p
	{ AQO_INC = ARES;
          ARES_INC = 0.0; 
	}

	for (ls=0; ls<size; ls++)
	{ /* code for mult_a_a  */
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1])
          ASSIGN_A( Aqo,   Atemp)
	  ASSIGN_T( Targ1, T[arg1])
	  ASSIGN_T( Targ2, T[arg2])
         

	  FOR_0_LE_l_LT_p
          { AARG2_INC += AQO     * TARG1;
	    AARG1_INC += AQO_INC * TARG2;
          }
          
          arg1++; arg2++;
	}
	break;

/*--------------------------------------------------------------------------*/
      case mult_a_av:                                          /* mult_a_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        /* olvo 980929 new strategy to check for overwrites 
           (changes computation order) */
        if ((arg2 >= res) && (arg2 < res+size)) 
	{ /* FIRST compute the case: res==arg2 */
	  /* simplified code for mult_a_a */
    	  get_taylor(arg2);

	  ASSIGN_A( Aarg1, A[arg1+res-arg2])
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_T( Targ2, T[arg2])
	  ASSIGN_T( Targ1, T[arg1+res-arg2])

          FOR_0_LE_l_LT_p
          { AARG1_INC += AARG2 * TARG2;
	    AARG2_INC *=         TARG1;
          }
	}

        res  += size;
        arg1 += size;
	for (ls=size; ls>0; ls--)
	{ arg1--;    /* Location of rght hnd side vectore[l]  */
	  res--;     /* Location of the result */
	    
          if (res == arg2) /* NOW skip this case */
            continue;

	  /* code for mult_a_a */
    	  get_taylor(res);

	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_T( Targ1, T[arg1])
	  ASSIGN_T( Targ2, T[arg2])

          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG2_INC += aTmp * TARG1;
	    AARG1_INC += aTmp * TARG2;
          }
	}
	break;

/*--------------------------------------------------------------------------*/
      case mult_d_av:                                          /* mult_d_av */
        res   = get_locint_r();
        size  = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

        res += size;
        arg += size;
	for (ls=size; ls>0; ls--)
	{ arg--;     /* Location on the right-hand-side */
	  res--;     /* location of the result */
	  /* coval = Fixed double value */
	    
	  /* code for mult_d_a */
	  ASSIGN_A( Ares, A[res])
	  ASSIGN_A( Aarg, A[arg])

          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG_INC += coval * aTmp;
          }

          get_taylor(res);
        }
	break;

/*--------------------------------------------------------------------------*/
      case div_av_a:                                            /* div_av_a */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        /* olvo 980929 new strategy to check for overwrites 
           (changes computation order) */
        if ((arg2 >= res) && (arg2 < res+size)) 
	{ /* FIRST compute the case: res==arg2 */
	  /* code for div_a_a */
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1+res-arg2])
	  ASSIGN_T( Targ2, T[arg2])

	  /* olvo 980922 changed order to allow x=y/x */
	  r_0 = -TARG2;
          get_taylor(arg2);
          r0  = 1.0 / TARG2;
 	  r_0 *= r0;

          FOR_0_LE_l_LT_p
          { AARG1_INC += AARG2 * r0;
	    AARG2_INC *=         r_0;
          }
	}

        res  += size;
        arg1 += size;
	for (ls=size; ls>0; ls--)
	{ arg1--;    /* Location of right-hand-side vector[l] */
	  res--;     /* Location of the result */
	    
          if (res == arg2) /* NOW skip this case */
            continue;

	  /* code for div_a_a */
	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_T( Tres,  T[res])
	  ASSIGN_T( Targ2, T[arg2])

	  /* olvo 980922 changed order to allow x=y/x */
	  r_0 = -TRES;
          get_taylor(res);
          r0  = 1.0 / TARG2;
 	  r_0 *= r0;

          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG1_INC += aTmp * r0;
	    AARG2_INC += aTmp * r_0;
          }
	}
	break;


/****************************************************************************/
/*                                                               SUBSCRIPTS */

/*--------------------------------------------------------------------------*/
      case subscript:                                          /* subscript */
        res   = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        arg  = arg2 + (int)(TARG1);

	/* olvo 980721 new nl */
        get_taylor(res);

	ASSIGN_A( Aarg, A[arg])
	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
        { if (((int)(coval) != (int)(TARG1)) && (ARES))
            MINDEC(ret_c,2);

          AARG_INC += ARES;
          if (arg != res)
            ARES_INC = 0;
#if defined(_FOV_)
          else 
            ARES_INC;
#endif
        }

	break;

/*--------------------------------------------------------------------------*/
      case subscript_l:                                      /* subscript_l */
        arg   = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        res   = arg2 + (int)(TARG1);

	get_taylor(res);

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

	FOR_0_LE_l_LT_p
        { if (((int)(coval) != (int)(TARG1)) && (ARES))
            MINDEC(ret_c,2);

          AARG_INC += ARES;
          if(arg != res)
            ARES_INC = 0;
#if defined(_FOV_)
          else
            ARES_INC;
#endif
        }
	break;
      
/*--------------------------------------------------------------------------*/
      case subscript_ld:                                    /* subscript_ld */
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        arg = arg2 + (int)(TARG1);

        get_taylor(arg);

        if((int)(coval)!=(int)(TARG1))
          MINDEC(ret_c,2);

	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
	  AARG_INC = 0.0;
	break;
       
/*--------------------------------------------------------------------------*/
      case m_subscript:                                      /* m_subscript */
        res   = get_locint_r();
        size  = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        arg = arg2 + ((int)(TARG1) + 1)*size;
        res += size;
        for (ls=size; ls>0; ls--)
        { res--; arg--;

   	  /* olvo 980721 new nl */
          get_taylor(res);

          ASSIGN_A( Aarg, A[arg])
	  ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
          { if (((int)(coval)!=(int)(TARG1)) && (ARES))
              MINDEC(ret_c,2);
            AARG_INC += ARES;
            if (arg != res)
              ARES_INC = 0;
#if defined(_FOV_)
            else
              ARES_INC;
#endif
          }
        }
	break;

/*--------------------------------------------------------------------------*/
      case m_subscript_l:                                  /* m_subscript_l */
        arg   = get_locint_r();
        size  = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        res = arg2 + ((int)(TARG1) + 1)*size;
        arg += size;
        for (ls=size; ls>0; ls--)
        { arg--; res--;

          get_taylor(res);

          ASSIGN_A( Aarg, A[arg])
          ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
          { if (((int)(coval) != (int)(TARG1)) && (ARES))
              MINDEC(ret_c,2);
            AARG_INC += ARES;
            if (arg != res)
              ARES_INC = 0;
#if defined(_FOV_)
            else
              ARES_INC;
#endif
          } 
        } 
	break;

/*--------------------------------------------------------------------------*/
      case m_subscript_ld:                                /* m_subscript_ld */
        size   = get_locint_r();
        arg    = get_locint_r();
        arg1   = get_locint_r();
        arg2   = get_locint_r(); 
        /* olvo 980702 changed n2l */
        d      = get_val_v_r(size);
        coval  = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        if ((int)(coval) != (int)(TARG1))
          MINDEC(ret_c,2);

        res = arg2 + ((int)(TARG1) + 1)*size + arg;
        for (ls=size; ls>0; ls--)
        { res--;
          
          get_taylor(res);
        
          ASSIGN_A( Ares, A[res])
      
          FOR_0_LE_l_LT_p
            ARES_INC = 0.0;
        }
	break;


/****************************************************************************/
/*                                                          REMAINING STUFF */

/*--------------------------------------------------------------------------*/
      case take_stock_op:                                  /* take_stock_op */
        res  = get_locint_r();
        size = get_locint_r();
        d    = get_val_v_r(size);

        res += size;
	for (ls=size; ls>0; ls--)
	{ res--;

          ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
            ARES_INC = 0.0;
        }
        break;

/*--------------------------------------------------------------------------*/
      case death_not:                                          /* death_not */
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	for (j=arg1;j<=arg2;j++)
	{ ASSIGN_A(Aarg1, A[j])

          FOR_0_LE_l_LT_p
            AARG1_INC = 0.0;
	  
          get_taylor(j);
	}
	break;
	
/*--------------------------------------------------------------------------*/
      default:                                                   /* default */
	/*             Die here, we screwed up     */ 

        fprintf(DIAG_OUT,"ADOL-C fatal error in " GENERATED_FILENAME " (" 
                __FILE__
                ") : no such operation %d\n", operation);
	exit(-1);
	break;
      } /* endswitch */

      /* Get the next operation */
      operation=get_op_r();
    } /* endwhile */


#ifdef _FOS_
#if 0
   int iii;
   int allzero = 1;
   for(iii=0;iii<rev_location_cnt;iii++) 
/*   for(iii=1325;iii<1385;iii++) */
     if(A[iii] != 0.0) 
       { /*printf("!!! %f ",A[iii]);*/
	  allzero = 0;
       }
   
/*     printf("!!! %f ",A[iii]); */
/*     if(As[iii] != 0.0) exit(1);*/
   if(allzero == 1)
     {
	printf("Warning: All adjoints are zero!\n");
/*   abort();*/
     }
#endif
#endif



  end_sweep();
  return ret_c;
}


/****************************************************************************/
/*                                                               THAT'S ALL */

END_C_DECLS

  
#undef _FOS_


//@@@@@@@ fo_rev.c (2)

#define _FOS_ 1

/*---------------------------------------------------------------------------- 
 ADOL-C -- Automatic Differentiation by Overloading in C++
 File:     fo_rev.c
 Revision: $Id: fo_rev.c,v 1.3 2004/05/27 12:50:06 kowarz Exp $
 Contents: Contains the routines :
           fos_reverse (first-order-scalar reverse mode)  : define _FOS_
           fov_reverse (first-order-vector reverse mode)  : define _FOV_

 Copyright (c) 2004
               Technical University Dresden
               Department of Mathematics
               Institute of Scientific Computing
  
 This file is part of ADOL-C. This software is provided under the terms of
 the Common Public License. Any use, reproduction, or distribution of the
 software constitutes recipient's acceptance of the terms of this license.
 See the accompanying copy of the Common Public License for more details.

 History:
          20040423 kowarz: adapted to configure - make - make install
          20030305 andrea: change taylor_back
          19991122 olvo:   new op_codes eq_plus_prod eq_min_prod
                           for  y += x1 * x2
                           and  y -= x1 * x2  
          19981130 olvo:   last check (includes ...)
          19980929 olvo:   allow reflexive operations for
                           - vector operations: eq_mult_av_a,
                             mult_a_av, div_av_a
          19980924 olvo:   (1) Lots of small changes (Atemp, At --> Aqo)
                           (2) new macros AQO*
                           (3) deleted all int_* opcodes
                           (4) allow reflexive operations for
                               - cond_assign, cond_assign_s
                               (changed code completely)
          19980922 olvo:   (1) allow reflexive operations for
                               - div_d_a, div_a_a
          19980921 olvo:   (1) changed save-order in sin/cos
                           (2) allow reflexive operations for
                               - pow
          19980820 olvo:   new comparison strategy 
          19980721 olvo:   write of taylors in subscript and
                           subscript_m   
          19980714 olvo:   some error elimination
                           op-code mult_av_a removed  
          19980713 olvo:   debugging and optimizing
          19980710 olvo:   sin/cos writes 2 taylors
          19980709 olvo:   new operation code: neg_sign_a
                                               pos_sign_a
          19980706 olvo:   new operation code: int_adb_d_one
                                               int_adb_d_zero
          19980703 olvo:   new operation code: assign_d_one
                                               assign_d_zero
          19980626 olvo:   vector operations & subscripts
          19980623 mitev/olvo: revision + stock stuff 
          19980616 olvo:   griewank's idea II
          19980615 olvo:   griewank's idea
          19980612 mitev
          
----------------------------------------------------------------------------*/

/*****************************************************************************
 
  There are four basic versions of the procedure `reverse', which
  are optimized for the cases of scalar or vector reverse sweeps
  with first or higher derivatives, respectively. In the calling
  sequence this distinction is apparent from the type of the
  parameters `lagrange' and `results'. The former may be left out
  and the integer parameters `depen', `indep', `degre', and `nrows'
  must be set or default according to the following matrix of
  calling cases. 

           no lagrange         double* lagrange     double** lagrange

double*   gradient of scalar   weight vector times    infeasible 
results   valued function      Jacobian product       combination

          ( depen = 1 ,         ( depen > 0 ,         
	    degre = 0 ,           degre = 0 ,              ------
	    nrows = 1 )           nrows = 1 )

double**  Jacobian of vector   weight vector times     weight matrix
results   valued function      Taylor-Jacobians        times Jacobian
           
	  ( 0 < depen           ( depen > 0 ,          ( depen > 0 ,
	      = nrows ,           degre > 0 ,            degre = 0 ,
	    degre = 0 )           nrows = 1 )            nrows > 0 )

double*** full family of         ------------          weigth matrix x
results   Taylor-Jacobians       ------------          Taylor Jacobians

*****************************************************************************/ 

/****************************************************************************/
/*                                                                   MACROS */
#undef _ADOLC_VECTOR_

/*--------------------------------------------------------------------------*/
#ifdef _FOS_
#define GENERATED_FILENAME "fos_reverse"              

#define RESULTS(l,indexi)  results[indexi]
#define LAGRANGE(l,indexd) lagrange[indexd] 

/*--------------------------------------------------------------------------*/
#elif _FOV_
#define GENERATED_FILENAME "fov_reverse"             

#define _ADOLC_VECTOR_

#define RESULTS(l,indexi)  results[l][indexi]
#define LAGRANGE(l,indexd) lagrange[l][indexd] 

#else
#error Error ! Define [_FOS_ | _FOV_] 
#endif

/*--------------------------------------------------------------------------*/
/*                                                     access to variables  */

#ifdef _FOS_
#define ARES       *Ares
#define AARG       *Aarg
#define AARG1      *Aarg1
#define AARG2      *Aarg2
#define AQO        *Aqo

#define ARES_INC   *Ares
#define AARG_INC   *Aarg
#define AARG1_INC  *Aarg1
#define AARG2_INC  *Aarg2
#define AQO_INC    *Aqo

#define ARES_INC_O  Ares
#define AARG_INC_O  /adAarg
#define AARG1_INC_O Aarg1
#define AARG2_INC_O Aarg2
#define AQO_INC_O   Aqo

#define ASSIGN_A(a,b)  a = &b;

#else  /* _FOV_, _HOS_, _HOV_ */
#define ARES       *Ares
#define AARG       *Aarg
#define AARG1      *Aarg1
#define AARG2      *Aarg2
#define AQO        *Aqo

#define ARES_INC   *Ares++
#define AARG_INC   *Aarg++
#define AARG1_INC  *Aarg1++
#define AARG2_INC  *Aarg2++
#define AQO_INC    *Aqo++

#define ARES_INC_O  Ares++
#define AARG_INC_O  Aarg++
#define AARG1_INC_O Aarg1++
#define AARG2_INC_O Aarg2++
#define AQO_INC_O   Aqo++

#define ASSIGN_A(a,b)  a = b;
#endif

#define TRES       T[res]
#define TARG       T[arg]
#define TARG1      T[arg1]
#define TARG2      T[arg2]

#define ASSIGN_T(a,b)

/*--------------------------------------------------------------------------*/
/*                                                              loop stuff  */
#ifdef _ADOLC_VECTOR_
#define FOR_0_LE_l_LT_p for (l=0; l<p; l++)  
#define FOR_p_GT_l_GE_0 for (l=p-1; l>=0; l--)  
#else
#define FOR_0_LE_l_LT_p 
#define FOR_p_GT_l_GE_0  
#endif
 
#define FOR_0_LE_i_LT_k  
#define FOR_k_GT_i_GE_0  

#ifdef _HOV_
#define FOR_0_LE_l_LT_pk1 for (l=0; l<pk1; l++)  
#elif _FOV_
#define FOR_0_LE_l_LT_pk1 for (l=0; l<p; l++)  
#elif _HOS_
#define FOR_0_LE_l_LT_pk1 for (l=0; l<k1; l++)  
#else
#define FOR_0_LE_l_LT_pk1
#endif


/* END Macros */


/****************************************************************************/
/*                                                       NECESSARY INCLUDES */
//#include "interfaces.h"
//#include "adalloc.h"
//#include "oplate.h"
//#include "taputil.h"
//#include "taputil_p.h"
//#include "tayutil.h"
//#include "tayutil_p.h"

//#include <math.h>

BEGIN_C_DECLS

/****************************************************************************/
/*                                                             NOW THE CODE */

/*--------------------------------------------------------------------------*/
/*                                                   Local Static Variables */

// EGK: commented out since already declared above
//static short tag;

//static int rev_location_cnt;
//static int dep_cnt;
//static int ind_cnt;

#ifdef _FOS_
/****************************************************************************/
/* First-Order Scalar Reverse Pass.                                         */
/****************************************************************************/
int fos_reverse(short   tnum,       /* tape id */
                int     depen,      /* consistency chk on # of deps */
                int     indep,      /* consistency chk on # of indeps */
                double  *lagrange,
                double  *results)   /*  coefficient vectors */

#elif _FOV_
/****************************************************************************/
/* First-Order Vector Reverse Pass.                                         */
/****************************************************************************/

int fov_reverse(short   tnum,        /* tape id */
                int     depen,       /* consistency chk on # of deps */
                int     indep,       /* consistency chk on # of indeps */
                int     nrows,       /* # of Jacobian rows being calculated */
                double  **lagrange,  /* domain weight vector */
                double  **results)   /* matrix of coefficient vectors */  

#endif 

{
/****************************************************************************/
/*                                                           ALL VARIABLES  */
  unsigned char operation; /* operation code */
  int tape_stats[11];      /* tape stats */
  int ret_c=3;             /* return value */

  locint size = 0;
  locint res  = 0;
  locint arg  = 0;
  locint arg1 = 0;
  locint arg2 = 0;

  double coval = 0, *d = 0;

  int indexi = 0,  indexd = 0;

  /* loop indices */
#if defined(_FOS_)
  int i;
#else
  int l;
#endif
  int j, ls;

  /* other necessary variables */
  double r0, r_0;
  int buffer;
  static int rax;
#if defined(_FOV_)
  static int pax;
#endif
  int taycheck;
  int numdep,numind;
  double aTmp;

/*--------------------------------------------------------------------------*/
  /* Taylor stuff */
  static revreal *T;
 
/*--------------------------------------------------------------------------*/
  /* Adjoint stuff */
#ifdef _FOS_
  static double* A;
  double Atemp;
#else /* _FOV_, _HOS_, _HOV_ */  
  static double** A;
  static double *Atemp;
#endif
  double  *Ares, *Aarg, *Aarg1, *Aarg2, *Aqo;

/*--------------------------------------------------------------------------*/

#ifdef _ADOLC_VECTOR_
  int p = nrows;
#endif 

#ifdef _HOV_
  int pk1 = p*k1;
#endif


#if defined(ADOLC_DEBUG)
/****************************************************************************/
/*                                                           DEBUG MESSAGES */
  fprintf(DIAG_OUT,"Call of %s(..) with tag__: %d, n: %d, m %d,\n",
                   GENERATED_FILENAME, tnum, indep, depen);      
#ifdef _ADOLC_VECTOR_
  fprintf(DIAG_OUT,"                    p: %d\n\n",nrows);
#endif
  
#endif


/****************************************************************************/
/*                                                                    INITs */

  /*------------------------------------------------------------------------*/
  /* Set up stuff for the tape */

  tag__ = tnum;   /*tag__ is global which indicates which tape to look at */
        
  tapestats(tag__,tape_stats);
  ind_cnt          = tape_stats[0];
  dep_cnt          = tape_stats[1];
  rev_location_cnt = tape_stats[2];
  buffer           =  tape_stats[4];

  set_buf_size(buffer);

  if ((depen != dep_cnt)||(indep != ind_cnt))
  { fprintf(DIAG_OUT,"ADOL-C error: Reverse sweep on tape %d  aborted!\n",tag__);
    fprintf(DIAG_OUT,"Number of dependent and/or independent variables "
             "passed to reverse is\ninconsistent with number "
             "recorded on tape %d \n",tag__);
    exit (-1);
  }
  
  indexi = ind_cnt - 1;
  indexd = dep_cnt - 1;


/****************************************************************************/
/*                                                  MEMORY ALLOCATION STUFF */

/*--------------------------------------------------------------------------*/
#ifdef _FOS_                                                         /* FOS */
  if (rev_location_cnt compsize rax) 
  { if (rax)
    { free((char*) T);
      free((char*) A);
    }
    T = (revreal*) malloc(rev_location_cnt*sizeof(revreal));
    A = myalloc1(rev_location_cnt);
    if (T == NULL)
    { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate %i bytes !\n",
              (int)(rev_location_cnt*sizeof(revreal)));
      exit (-1);
    }
    rax = rev_location_cnt;
  }
  /* olvo 980924 is following initialization necessary ??? */
  Aqo = A;
  for (i=0; i<rev_location_cnt; i++) 
    *Aqo++ = 0.0;

/*--------------------------------------------------------------------------*/
#elif _FOV_                                                          /* FOV */
  if (rev_location_cnt compsize  rax || p compsize pax)
  { if (rax || pax)
    { free((char *) Atemp);
      free((char *) T);
      free((char *) *A); free((char*) A);
    }
    Atemp = myalloc1(p);
    T     = (revreal *)malloc(sizeof(revreal)*rev_location_cnt);
    if (T == NULL)
    { fprintf(DIAG_OUT,"ADOL-C error: cannot allocate %i bytes!\n",
              (int)(sizeof(revreal)*rev_location_cnt));
      exit (-1);
    }
    A = myalloc2(rev_location_cnt,p);
    rax = rev_location_cnt;
    pax = p;
  }
#endif


/****************************************************************************/
/*                                                    TAYLOR INITIALIZATION */
  taylor_back(tnum,T,&numdep,&numind,&taycheck);

  if (taycheck < 0)   
  { fprintf(DIAG_OUT,"\n ADOL-C error: reverse fails because it was not"
                   " preceeded\nby a forward sweep with degree>0, keep=1!\n");
    exit(-2);
  };

  if((numdep != depen)||(numind != indep))
  { fprintf(DIAG_OUT, "\n ADOL-C error: reverse fails on tape %d because the"
                    " number of\nindependent and/or dependent variables"
                    " given to reverse are\ninconsistent with that of the"
                    " internal taylor array.\n",tag__);
    exit(-2);
  }

  
/****************************************************************************/
/*                                                            REVERSE SWEEP */

  /* Initialize the Reverse Sweep */
  init_rev_sweep(tag__);

  operation=get_op_r();
  while (operation != start_of_tape) 
  { /* Switch statement to execute the operations in Reverse */
    switch (operation) {


/****************************************************************************/
/*                                                                  MARKERS */

/*--------------------------------------------------------------------------*/
      case end_of_op:                                          /* end_of_op */
        get_op_block_r();
        operation = get_op_r(); 
        /* Skip next operation, it's another end_of_op */
        break;

/*--------------------------------------------------------------------------*/
      case end_of_int:                                        /* end_of_int */
        get_loc_block_r(); /* Get the next int block */
        break;

/*--------------------------------------------------------------------------*/
      case end_of_val:                                        /* end_of_val */
        get_val_block_r(); /* Get the next val block */
        break;

/*--------------------------------------------------------------------------*/
      case start_of_tape:                                  /* start_of_tape */
      case end_of_tape:                                      /* end_of_tape */
	break;


/****************************************************************************/
/*                                                               COMPARISON */

/*--------------------------------------------------------------------------*/
      case eq_zero  :                                            /* eq_zero */
        arg   = get_locint_r();

        ret_c = 0;
        break;

/*--------------------------------------------------------------------------*/
      case neq_zero :                                           /* neq_zero */
      case gt_zero  :                                            /* gt_zero */
      case lt_zero :                                             /* lt_zero */
        arg   = get_locint_r();
        break;

/*--------------------------------------------------------------------------*/
      case ge_zero :                                             /* ge_zero */
      case le_zero :                                             /* le_zero */
        arg   = get_locint_r();

        ASSIGN_T( Targ, T[arg])

        if (TARG == 0)
          ret_c = 0;
        break;


/****************************************************************************/
/*                                                              ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
      case assign_a:           /* assign an adouble variable an    assign_a */
	                       /* adouble value. (=) */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Aarg, A[arg])
	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
        { AARG_INC += ARES;
          ARES_INC = 0.0;
        }

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case assign_d:            /* assign an adouble variable a    assign_d */
	                        /* double value. (=) */
        res   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC = 0.0;
        
        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case assign_d_zero:  /* assign an adouble variable a    assign_d_zero */
      case assign_d_one:   /* double value (0 or 1). (=)       assign_d_one */
        res   = get_locint_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC = 0.0;
        
        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case assign_ind:       /* assign an adouble variable an    assign_ind */
	                     /* independent double value (<<=) */
        res = get_locint_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          RESULTS(l,indexi) = ARES_INC;
        
        get_taylor(res);
	indexi--;
	break;

/*--------------------------------------------------------------------------*/
      case assign_dep:           /* assign a float variable a    assign_dep */
	                         /* dependent adouble value. (>>=) */
        res = get_locint_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC = LAGRANGE(l,indexd);

	indexd--;
	break;


/****************************************************************************/
/*                                                   OPERATION + ASSIGNMENT */

/*--------------------------------------------------------------------------*/
      case eq_plus_d:            /* Add a floating point to an    eq_plus_d */
	                         /* adouble. (+=) */
        res   = get_locint_r();
        coval = get_val_r();

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_plus_a:             /* Add an adouble to another    eq_plus_a */
	                          /* adouble. (+=) */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg]);

        FOR_0_LE_l_LT_p
          AARG_INC += ARES_INC;

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_min_d:       /* Subtract a floating point from an    eq_min_d */
                           /* adouble. (-=) */
        res   = get_locint_r();
        coval = get_val_r();

	get_taylor(res);
	break;
	
/*--------------------------------------------------------------------------*/
      case eq_min_a:        /* Subtract an adouble from another    eq_min_a */
	                    /* adouble. (-=) */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
          AARG_INC -= ARES_INC;

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_d:              /* Multiply an adouble by a    eq_mult_d */
	                           /* flaoting point. (*=) */
        res   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
          ARES_INC *= coval;

	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_a:       /* Multiply one adouble by another    eq_mult_a */
	                    /* (*=) */
        res = get_locint_r();
        arg = get_locint_r();

 	get_taylor(res);

	ASSIGN_A( Ares, A[res])
        ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])
	ASSIGN_T( Targ, T[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
	  /* olvo 980713 nn: ARES = 0.0; */ 
	  ARES_INC =  aTmp * TARG;
	  AARG_INC += aTmp * TRES; 
        }
        break;
        
/*--------------------------------------------------------------------------*/
      case incr_a:                        /* Increment an adouble    incr_a */
      case decr_a:                        /* Increment an adouble    decr_a */
        res   = get_locint_r();

	get_taylor(res);
	break;


/****************************************************************************/
/*                                                        BINARY OPERATIONS */

/*--------------------------------------------------------------------------*/
      case plus_a_a:                 /* : Add two adoubles. (+)    plus a_a */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Aarg2, A[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp;
          AARG2_INC += aTmp;          
        }

      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case plus_d_a:             /* Add an adouble and a double    plus_d_a */
	                         /* (+) */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp;
        }

      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case min_a_a:              /* Subtraction of two adoubles    min_a_a */
	                         /* (-) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Aarg2, A[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp;
          AARG2_INC -= aTmp;
        }

        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case min_d_a:                /* Subtract an adouble from a    min_d_a */
	                           /* double (-) */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC -= aTmp;
        }

        get_taylor(res);
	break;
	
/*--------------------------------------------------------------------------*/
      case mult_a_a:               /* Multiply two adoubles (*)    mult_a_a */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        get_taylor(res);

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ1, T[arg1])
	ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG2_INC += aTmp * TARG1;
	  AARG1_INC += aTmp * TARG2;
        }
        break;

/*--------------------------------------------------------------------------*/
      /* olvo 991122: new op_code with recomputation */
      case eq_plus_prod:   /* increment a product of           eq_plus_prod */
                           /* two adoubles (*) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ1, T[arg1])
	ASSIGN_T( Targ2, T[arg2])

        /* RECOMPUTATION */
        ASSIGN_T( Tres,  T[res])
        TRES -= TARG1*TARG2;

        FOR_0_LE_l_LT_p
        { AARG2_INC += ARES    * TARG1;
	  AARG1_INC += ARES_INC * TARG2;
        }
        break;

/*--------------------------------------------------------------------------*/
      /* olvo 991122: new op_code with recomputation */
      case eq_min_prod:    /* decrement a product of            eq_min_prod */
                           /* two adoubles (*) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ1, T[arg1])
	ASSIGN_T( Targ2, T[arg2])

        /* RECOMPUTATION */
        ASSIGN_T( Tres,  T[res])
        TRES += TARG1*TARG2;

        FOR_0_LE_l_LT_p
        { AARG2_INC -= ARES    * TARG1;
	  AARG1_INC -= ARES_INC * TARG2;
        }
        break;

/*--------------------------------------------------------------------------*/
      case mult_d_a:         /* Multiply an adouble by a double    mult_d_a */
                             /* (*) */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += coval * aTmp;
        }

        get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case div_a_a:           /* Divide an adouble by an adouble    div_a_a */
                              /* (/) */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg2, A[arg2])
	ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_T( Tres,  T[res])
        ASSIGN_T( Targ2, T[arg2])

	/* olvo 980922 changed order to allow x=y/x */
	r_0 = -TRES;
        get_taylor(res);
        r0  = 1.0 / TARG2;
	r_0 *= r0;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * r0;
	  AARG2_INC += aTmp * r_0;
        }

        break;

/*--------------------------------------------------------------------------*/
      case div_d_a:             /* Division double - adouble (/)    div_d_a */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
	ASSIGN_T( Tres, T[res])
        ASSIGN_T( Targ, T[arg])

	/* olvo 980922 changed order to allow x=d/x */
        r0 = -TRES;
        if (arg == res)
          get_taylor(arg);
        r0 /= TARG;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }

        get_taylor(res);
        break;


/****************************************************************************/
/*                                                         SIGN  OPERATIONS */

/*--------------------------------------------------------------------------*/
      case pos_sign_a:                                        /* pos_sign_a */
        res   = get_locint_r();
        arg   = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp;
        }

      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case neg_sign_a:                                        /* neg_sign_a */
        res   = get_locint_r();
        arg   = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC -= aTmp;
        }

      	get_taylor(res);
	break;


/****************************************************************************/
/*                                                         UNARY OPERATIONS */

/*--------------------------------------------------------------------------*/
      case exp_op:                          /* exponent operation    exp_op */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * TRES;
        }

 	get_taylor(res);
        break;

/*--------------------------------------------------------------------------*/
      case sin_op:                              /* sine operation    sin_op */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * TARG2;
        }

       	get_taylor(res);
       	get_taylor(arg2); /* olvo 980710 covalue */
	                  /* NOTE: A[arg2] should be 0 already */
	break;

/*--------------------------------------------------------------------------*/
      case cos_op:                            /* cosine operation    cos_op */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC -= aTmp * TARG2;          
        }

       	get_taylor(res);
       	get_taylor(arg2); /* olvo 980710 covalue */
	                  /* NOTE A[arg2] should be 0 already */
	break;

/*--------------------------------------------------------------------------*/
      case atan_op:                                             /* atan_op  */
      case asin_op:                                             /* asin_op  */
      case acos_op:                                             /* acos_op  */
      case asinh_op:                                            /* asinh_op */
      case acosh_op:                                            /* acosh_op */
      case atanh_op:                                            /* atanh_op */
      case erf_op:                                              /* erf_op   */
        res  = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        get_taylor(res);

        ASSIGN_A( Ares,  A[res])
        ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * TARG2;
        }
	break;

/*--------------------------------------------------------------------------*/
      case log_op:                                                /* log_op */
        res = get_locint_r();
        arg = get_locint_r();

        get_taylor(res);

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
	ASSIGN_T( Targ, T[arg])

        r0 = 1.0/TARG;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }
	break;

/*--------------------------------------------------------------------------*/
      case pow_op:                                                /* pow_op */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])
        ASSIGN_T( Targ, T[arg])

	/* olvo 980921 changed order to allow x=pow(x,n) */
        r0 = TRES;
        if (arg == res)
          get_taylor(arg);
        if (TARG == 0.0) 
          r0 = 0.0;
        else
          r0 *= coval/TARG;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }
 
        get_taylor(res);
        break;

/*--------------------------------------------------------------------------*/
      case sqrt_op:                                              /* sqrt_op */
        res = get_locint_r();
        arg = get_locint_r();

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Tres, T[res])

        if (TRES == 0.0)
          r0 = 0.0;
        else 
          r0 = 0.5 / TRES;

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG_INC += aTmp * r0;
        }
  
        get_taylor(res);
        break;

/*--------------------------------------------------------------------------*/
      case gen_quad:                                            /* gen_quad */
        res   = get_locint_r();
        arg2  = get_locint_r();
        arg1  = get_locint_r();
        coval = get_val_r();
        coval = get_val_r();

	ASSIGN_A( Ares,  A[res])
	ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_T( Targ2, T[arg2])

        FOR_0_LE_l_LT_p
        { aTmp = ARES;
          ARES_INC = 0.0; 
          AARG1_INC += aTmp * TARG2;
        }
  
      	get_taylor(res);
	break;

/*--------------------------------------------------------------------------*/
      case min_op:                                                /* min_op */
        res   = get_locint_r();
        arg2  = get_locint_r();
        arg1  = get_locint_r();
        coval = get_val_r();
  
        get_taylor(res);

        ASSIGN_A( Aarg1, A[arg1])
        ASSIGN_A( Aarg2, A[arg2])
        ASSIGN_A( Ares,  A[res])
        ASSIGN_T( Targ1, T[arg1])
        ASSIGN_T( Targ2, T[arg2])

        if (TARG1 > TARG2)
          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            if ((coval) && (aTmp))
              MINDEC(ret_c,2);
            AARG2_INC += aTmp;
          }
        else 
          if (TARG1 < TARG2)
            FOR_0_LE_l_LT_p
            { aTmp = ARES;
              ARES_INC = 0.0; 
              if ((!coval) && (aTmp))
                MINDEC(ret_c,2);
              AARG1_INC += aTmp;
            }
          else
          { /* both are equal */
            FOR_0_LE_l_LT_p
            { aTmp = ARES / 2.0;
              ARES_INC = 0.0; 
              AARG2_INC += aTmp;
              AARG1_INC += aTmp;
            }
            if (arg1 != arg2)
              MINDEC(ret_c,1);
          }
        break;

/*--------------------------------------------------------------------------*/
      case abs_val:                                              /* abs_val */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();
  
        get_taylor(res);

        ASSIGN_A( Ares, A[res])
        ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Targ, T[arg])

        if (TARG < 0.0)
          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            if ((coval) && (aTmp))
              MINDEC(ret_c,2);
            AARG_INC -= aTmp;
          } 
        else 
          if (TARG > 0.0)
            FOR_0_LE_l_LT_p
            { aTmp = ARES;
              ARES_INC = 0.0; 
              if ((!coval) && (aTmp))
                MINDEC(ret_c,2);
              AARG_INC += aTmp;
            }
          else 
            FOR_0_LE_l_LT_p 
            { aTmp = ARES;
              ARES_INC = 0.0; 
              if (aTmp)        
                MINDEC(ret_c,1);
            }
        break;

/*--------------------------------------------------------------------------*/
      case ceil_op:                                              /* ceil_op */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

        get_taylor(res);

        ASSIGN_A( Ares, A[res])
        ASSIGN_T( Targ, T[arg])

        coval = (coval != ceil(TARG) );

        FOR_0_LE_l_LT_p
        { if ((coval) && (ARES))
            MINDEC(ret_c,2);
          ARES_INC = 0.0;
        }
        break;

/*--------------------------------------------------------------------------*/
      case floor_op:                                            /* floor_op */
        res   = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

        get_taylor(res);

        ASSIGN_A( Ares, A[res])
        ASSIGN_A( Aarg, A[arg])
        ASSIGN_T( Targ, T[arg])

        coval = ( coval != floor(TARG1) );

        FOR_0_LE_l_LT_p
        { if ( (coval) && (ARES) )
            MINDEC(ret_c,2);
          ARES_INC = 0.0;
	}
        break;    


/****************************************************************************/
/*                                                             CONDITIONALS */

/*--------------------------------------------------------------------------*/
      case cond_assign:                                      /* cond_assign */
        res    = get_locint_r();
        arg2   = get_locint_r();
        arg1   = get_locint_r();
        arg    = get_locint_r();
        coval  = get_val_r(); 

	get_taylor(res);

        ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Ares,  A[res])
        ASSIGN_A( Aarg2, A[arg2])
        ASSIGN_T( Targ,  T[arg])

	/* olvo 980924 changed code a little bit */
        if (TARG > 0.0)
        { if (res != arg1)
            FOR_0_LE_l_LT_p
            { if ((coval <= 0.0) && (ARES))
                MINDEC(ret_c,2);
              AARG1_INC += ARES;
              ARES_INC = 0.0;
	    }
          else
            FOR_0_LE_l_LT_p
              if ((coval <= 0.0) && (ARES_INC))
                MINDEC(ret_c,2);
	}
        else
        { if (res != arg2)
            FOR_0_LE_l_LT_p
            { if ((coval <= 0.0) && (ARES))
                MINDEC(ret_c,2);
              AARG2_INC += ARES;
              ARES_INC = 0.0;
	    }
          else
            FOR_0_LE_l_LT_p
              if ((coval <= 0.0) && (ARES_INC))
                MINDEC(ret_c,2);
	}
        break;

/*--------------------------------------------------------------------------*/
      case cond_assign_s:                                  /* cond_assign_s */
        res   = get_locint_r();
        arg1  = get_locint_r();
        arg   = get_locint_r(); 
        coval = get_val_r();

        get_taylor(res);

        ASSIGN_A( Aarg1, A[arg1])
	ASSIGN_A( Ares,  A[res])
        ASSIGN_T( Targ,  T[arg])
        
	/* olvo 980924 changed code a little bit */
        if (TARG > 0.0)
        { if (res != arg1)
            FOR_0_LE_l_LT_p
            { if ((coval <= 0.0) && (ARES))
                MINDEC(ret_c,2);
              AARG1_INC += ARES;
              ARES_INC = 0.0;
	    }
          else
            FOR_0_LE_l_LT_p
              if ((coval <= 0.0) && (ARES_INC))
                MINDEC(ret_c,2);
	}
        else
          if (TARG == 0.0) /* we are at the tie */
            FOR_0_LE_l_LT_p
              if (ARES_INC)
                MINDEC(ret_c,0);
        break;


/****************************************************************************/
/*                                                       VECTOR ASSIGNMENTS */

/*--------------------------------------------------------------------------*/
      case assign_av:                                          /* assign_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

	res += size;
	arg += size;
        for (ls=size; ls>0; ls--)
	{ res--;             /* Location of left-hand-side  */
	  arg--;             /* Location of right-hand-side */

          /* code for assign_a */
          ASSIGN_A( Aarg, A[arg])
	  ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
	  { AARG_INC += ARES;
	    ARES_INC = 0.0;
	  }

	  get_taylor(res);
	  }
	break;

/*--------------------------------------------------------------------------*/
      case assign_dv:                                          /* assign_dv */
        res  = get_locint_r();
        size = get_locint_r();
        d    = get_val_v_r(size);

        res += size;
        d   += size;
	for (ls=size; ls>0; ls--)
	{ res--;                /* Location of left-hand-side */
	  coval = *(--d);       /* Value of right-hand-side   */     

          /* code for assign_d */
	  ASSIGN_A( Ares, A[res])

	  FOR_0_LE_l_LT_p
	    ARES_INC = 0.0;

	  get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case assign_indvec:                                  /* assign_indvec */
        res  = get_locint_r();
        size = get_locint_r();

        res += size;
	for (ls=size; ls>0; ls--)
	{ res--;             /* Location of the left-hand-side */

          /* code for assign_ind */
	  ASSIGN_A( Ares, A[res])

	  FOR_0_LE_l_LT_p
	    RESULTS(l,indexi) = ARES_INC;
	  indexi--;

	  get_taylor(res);
        }
	reset_val_r();
	break;

/*--------------------------------------------------------------------------*/
      case assign_depvec:                                  /* assign_depvec */
        res  = get_locint_r();
        size = get_locint_r();

        res += size;
	for (ls=size; ls>0; ls--)
	{ res--;             /* Location of the left-hand-side */

	  /* code for assign_dep */
	  ASSIGN_A( Ares, A[res])
            
          FOR_0_LE_l_LT_p
            ARES_INC = LAGRANGE(l, indexd);
	  indexd--;
	}
	break;


/****************************************************************************/
/*                                            VECTOR OPERATION + ASSIGNMENT */

/*--------------------------------------------------------------------------*/
      case eq_plus_av:                                        /* eq_plus_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

        res += size;
        arg += size;
	for (ls=size; ls>0; ls--)
	{ res--;            /* Location of left-hand-side  */
	  arg--;            /* Location on right-hand-side */

          /* code for eq_plus_a */
          ASSIGN_A( Ares, A[res])
	  ASSIGN_A (Aarg, A[arg])

	  FOR_0_LE_l_LT_p
	    AARG_INC += ARES_INC;

          get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case eq_min_av:                                          /* eq_min_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

        res += size;
        arg += size;
	for (ls=size; ls>0; ls--)
	{ res--;              /* Location of left-hand-side  */
	  arg--;              /* Location on right-hand-side */

	  /* code for eq_min_a */ 
	  ASSIGN_A( Ares, A[res])
	  ASSIGN_A( Aarg, A[arg])

	  FOR_0_LE_l_LT_p
	    AARG_INC -= ARES_INC;

          get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_av_d:                                    /* eq_mult_av_d */
        res   = get_locint_r();
        size  = get_locint_r();
        coval = get_val_r();

        res += size;
	for (ls=size; ls>0; ls--)
        { res--;            /* Location of the left-hand-side  */
	  /* coval = fixed;    value on the right-hand-side */

	  /* code for eq_mult_d*/
	  ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
            ARES_INC *= coval;

	  get_taylor(res);
        }
	break;

/*--------------------------------------------------------------------------*/
      case eq_mult_av_a:                                    /* eq_mult_av_a */
        res  = get_locint_r();
        size = get_locint_r();
        arg  = get_locint_r();

        /* olvo 980929 new strategy to check for overwrites 
           (changes computation order) */
        if ((arg >= res) && (arg < res+size)) 
	{ /* FIRST compute the case: res==arg */
          /* simplified code for eq_mult_a*/
	  get_taylor(arg);
	
	  ASSIGN_A( Aarg, A[arg]) 
          ASSIGN_T( Targ, T[arg])

          FOR_0_LE_l_LT_p
            AARG_INC  *= 2.0 * TARG; 
	}

	res += size;
        for (ls=size; ls>0; ls--)
	{ res--;                 /* Location of the left-hand-side  */
	  /* arg    = fixed;        Location on the right-hand-side */
     
          if (res == arg) /* NOW skip this case */
            continue;

          /* code for eq_mult_a*/
	  get_taylor(res);
	
	  ASSIGN_A( Aarg, A[arg]) 
	  ASSIGN_A( Ares, A[res]) 
          ASSIGN_T( Tres, T[res])
          ASSIGN_T( Targ, T[arg])

          FOR_0_LE_l_LT_p
          { r0 = ARES;
	    /* olvo 980713 nn: ARES = 0; */
            ARES_INC  = r0 * TARG; 
            AARG_INC += r0 * TRES; 
          }     
	}
	break;


/****************************************************************************/
/*                                                 BINARY VECTOR OPERATIONS */

/*--------------------------------------------------------------------------*/
      case plus_av_av:                                        /* plus_av_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	res  += size;
	arg1 += size;
	arg2 += size;
        for (ls=size; ls>0; ls--)
	{ arg2--;       /* Location of var 2  */
	  arg1--;       /* Location of var 1  */
	  res--;        /* Location of result */

          /* code for plus_a_a */
	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_A( Aarg2, A[arg2])

	  FOR_0_LE_l_LT_p
	  { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG1_INC += aTmp;
            AARG2_INC += aTmp;          
          }

      	  get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case sub_av_av:                                          /* sub_av_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	res  += size;
	arg1 += size;
	arg2 += size;
        for (ls=size; ls>0; ls--)
	{ arg2--;       /* Location of var 2  */
	  arg1--;       /* Location of var 1  */
	  res--;        /* Location of result */

	  /* code for min_a_a */
	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_A( Aarg2, A[arg2])

	  FOR_0_LE_l_LT_p
	  { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG1_INC += aTmp;
            AARG2_INC -= aTmp;          
          }

          get_taylor(res);
	}
	break;

/*--------------------------------------------------------------------------*/
      case dot_av_av:                                          /* dot_av_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        get_taylor(res);

        /* save Ares to Atemp */
        ASSIGN_A( Aqo,  Atemp)
	ASSIGN_A( Ares, A[res])
        FOR_0_LE_l_LT_p
	{ AQO_INC = ARES;
          ARES_INC = 0.0; 
	}

	for (ls=0; ls<size; ls++)
	{ /* code for mult_a_a  */
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1])
          ASSIGN_A( Aqo,   Atemp)
	  ASSIGN_T( Targ1, T[arg1])
	  ASSIGN_T( Targ2, T[arg2])
         

	  FOR_0_LE_l_LT_p
          { AARG2_INC += AQO     * TARG1;
	    AARG1_INC += AQO_INC * TARG2;
          }
          
          arg1++; arg2++;
	}
	break;

/*--------------------------------------------------------------------------*/
      case mult_a_av:                                          /* mult_a_av */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        /* olvo 980929 new strategy to check for overwrites 
           (changes computation order) */
        if ((arg2 >= res) && (arg2 < res+size)) 
	{ /* FIRST compute the case: res==arg2 */
	  /* simplified code for mult_a_a */
    	  get_taylor(arg2);

	  ASSIGN_A( Aarg1, A[arg1+res-arg2])
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_T( Targ2, T[arg2])
	  ASSIGN_T( Targ1, T[arg1+res-arg2])

          FOR_0_LE_l_LT_p
          { AARG1_INC += AARG2 * TARG2;
	    AARG2_INC *=         TARG1;
          }
	}

        res  += size;
        arg1 += size;
	for (ls=size; ls>0; ls--)
	{ arg1--;    /* Location of rght hnd side vectore[l]  */
	  res--;     /* Location of the result */
	    
          if (res == arg2) /* NOW skip this case */
            continue;

	  /* code for mult_a_a */
    	  get_taylor(res);

	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_T( Targ1, T[arg1])
	  ASSIGN_T( Targ2, T[arg2])

          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG2_INC += aTmp * TARG1;
	    AARG1_INC += aTmp * TARG2;
          }
	}
	break;

/*--------------------------------------------------------------------------*/
      case mult_d_av:                                          /* mult_d_av */
        res   = get_locint_r();
        size  = get_locint_r();
        arg   = get_locint_r();
        coval = get_val_r();

        res += size;
        arg += size;
	for (ls=size; ls>0; ls--)
	{ arg--;     /* Location on the right-hand-side */
	  res--;     /* location of the result */
	  /* coval = Fixed double value */
	    
	  /* code for mult_d_a */
	  ASSIGN_A( Ares, A[res])
	  ASSIGN_A( Aarg, A[arg])

          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG_INC += coval * aTmp;
          }

          get_taylor(res);
        }
	break;

/*--------------------------------------------------------------------------*/
      case div_av_a:                                            /* div_av_a */
        res  = get_locint_r();
        size = get_locint_r();
        arg2 = get_locint_r();
        arg1 = get_locint_r();

        /* olvo 980929 new strategy to check for overwrites 
           (changes computation order) */
        if ((arg2 >= res) && (arg2 < res+size)) 
	{ /* FIRST compute the case: res==arg2 */
	  /* code for div_a_a */
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1+res-arg2])
	  ASSIGN_T( Targ2, T[arg2])

	  /* olvo 980922 changed order to allow x=y/x */
	  r_0 = -TARG2;
          get_taylor(arg2);
          r0  = 1.0 / TARG2;
 	  r_0 *= r0;

          FOR_0_LE_l_LT_p
          { AARG1_INC += AARG2 * r0;
	    AARG2_INC *=         r_0;
          }
	}

        res  += size;
        arg1 += size;
	for (ls=size; ls>0; ls--)
	{ arg1--;    /* Location of right-hand-side vector[l] */
	  res--;     /* Location of the result */
	    
          if (res == arg2) /* NOW skip this case */
            continue;

	  /* code for div_a_a */
	  ASSIGN_A( Ares,  A[res])
	  ASSIGN_A( Aarg2, A[arg2])
	  ASSIGN_A( Aarg1, A[arg1])
	  ASSIGN_T( Tres,  T[res])
	  ASSIGN_T( Targ2, T[arg2])

	  /* olvo 980922 changed order to allow x=y/x */
	  r_0 = -TRES;
          get_taylor(res);
          r0  = 1.0 / TARG2;
 	  r_0 *= r0;

          FOR_0_LE_l_LT_p
          { aTmp = ARES;
            ARES_INC = 0.0; 
            AARG1_INC += aTmp * r0;
	    AARG2_INC += aTmp * r_0;
          }
	}
	break;


/****************************************************************************/
/*                                                               SUBSCRIPTS */

/*--------------------------------------------------------------------------*/
      case subscript:                                          /* subscript */
        res   = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        arg  = arg2 + (int)(TARG1);

	/* olvo 980721 new nl */
        get_taylor(res);

	ASSIGN_A( Aarg, A[arg])
	ASSIGN_A( Ares, A[res])

        FOR_0_LE_l_LT_p
        { if (((int)(coval) != (int)(TARG1)) && (ARES))
            MINDEC(ret_c,2);

          AARG_INC += ARES;
          if (arg != res)
            ARES_INC = 0;
#if defined(_FOV_)
          else 
            ARES_INC;
#endif
        }

	break;

/*--------------------------------------------------------------------------*/
      case subscript_l:                                      /* subscript_l */
        arg   = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        res   = arg2 + (int)(TARG1);

	get_taylor(res);

	ASSIGN_A( Ares, A[res])
	ASSIGN_A( Aarg, A[arg])

	FOR_0_LE_l_LT_p
        { if (((int)(coval) != (int)(TARG1)) && (ARES))
            MINDEC(ret_c,2);

          AARG_INC += ARES;
          if(arg != res)
            ARES_INC = 0;
#if defined(_FOV_)
          else
            ARES_INC;
#endif
        }
	break;
      
/*--------------------------------------------------------------------------*/
      case subscript_ld:                                    /* subscript_ld */
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        arg = arg2 + (int)(TARG1);

        get_taylor(arg);

        if((int)(coval)!=(int)(TARG1))
          MINDEC(ret_c,2);

	ASSIGN_A( Aarg, A[arg])

        FOR_0_LE_l_LT_p
	  AARG_INC = 0.0;
	break;
       
/*--------------------------------------------------------------------------*/
      case m_subscript:                                      /* m_subscript */
        res   = get_locint_r();
        size  = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        arg = arg2 + ((int)(TARG1) + 1)*size;
        res += size;
        for (ls=size; ls>0; ls--)
        { res--; arg--;

   	  /* olvo 980721 new nl */
          get_taylor(res);

          ASSIGN_A( Aarg, A[arg])
	  ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
          { if (((int)(coval)!=(int)(TARG1)) && (ARES))
              MINDEC(ret_c,2);
            AARG_INC += ARES;
            if (arg != res)
              ARES_INC = 0;
#if defined(_FOV_)
            else
              ARES_INC;
#endif
          }
        }
	break;

/*--------------------------------------------------------------------------*/
      case m_subscript_l:                                  /* m_subscript_l */
        arg   = get_locint_r();
        size  = get_locint_r();
        arg1  = get_locint_r();
        arg2  = get_locint_r(); 
        coval = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        res = arg2 + ((int)(TARG1) + 1)*size;
        arg += size;
        for (ls=size; ls>0; ls--)
        { arg--; res--;

          get_taylor(res);

          ASSIGN_A( Aarg, A[arg])
          ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
          { if (((int)(coval) != (int)(TARG1)) && (ARES))
              MINDEC(ret_c,2);
            AARG_INC += ARES;
            if (arg != res)
              ARES_INC = 0;
#if defined(_FOV_)
            else
              ARES_INC;
#endif
          } 
        } 
	break;

/*--------------------------------------------------------------------------*/
      case m_subscript_ld:                                /* m_subscript_ld */
        size   = get_locint_r();
        arg    = get_locint_r();
        arg1   = get_locint_r();
        arg2   = get_locint_r(); 
        /* olvo 980702 changed n2l */
        d      = get_val_v_r(size);
        coval  = get_val_r();

	ASSIGN_T( Targ1, T[arg1])

        if ((int)(coval) != (int)(TARG1))
          MINDEC(ret_c,2);

        res = arg2 + ((int)(TARG1) + 1)*size + arg;
        for (ls=size; ls>0; ls--)
        { res--;
          
          get_taylor(res);
        
          ASSIGN_A( Ares, A[res])
      
          FOR_0_LE_l_LT_p
            ARES_INC = 0.0;
        }
	break;


/****************************************************************************/
/*                                                          REMAINING STUFF */

/*--------------------------------------------------------------------------*/
      case take_stock_op:                                  /* take_stock_op */
        res  = get_locint_r();
        size = get_locint_r();
        d    = get_val_v_r(size);

        res += size;
	for (ls=size; ls>0; ls--)
	{ res--;

          ASSIGN_A( Ares, A[res])

          FOR_0_LE_l_LT_p
            ARES_INC = 0.0;
        }
        break;

/*--------------------------------------------------------------------------*/
      case death_not:                                          /* death_not */
        arg2 = get_locint_r();
        arg1 = get_locint_r();

	for (j=arg1;j<=arg2;j++)
	{ ASSIGN_A(Aarg1, A[j])

          FOR_0_LE_l_LT_p
            AARG1_INC = 0.0;
	  
          get_taylor(j);
	}
	break;
	
/*--------------------------------------------------------------------------*/
      default:                                                   /* default */
	/*             Die here, we screwed up     */ 

        fprintf(DIAG_OUT,"ADOL-C fatal error in " GENERATED_FILENAME " (" 
                __FILE__
                ") : no such operation %d\n", operation);
	exit(-1);
	break;
      } /* endswitch */

      /* Get the next operation */
      operation=get_op_r();
    } /* endwhile */

  end_sweep();
  return ret_c;
}


/****************************************************************************/
/*                                                               THAT'S ALL */

END_C_DECLS

#undef _FOS_
