#include <iostream>
#include "ObjectiveFunctionBase.h"
#include "RevolveDriver.h"


#define TIMESTEP(N) {return; L ## N:;}

adoublev s(1);
adoublev s2(10);

class OurFunction: public adolc::ObjectiveFunctionBase
{
   public:


      void Function(adolc::ObjectiveFunctionBase::Label& label)
      {


	 JUMPTABLE_2_GOTO_MACRO;

	 TIMESTEP(0);

	 s[0] = sqrt(m_Independents[0]);

	 TIMESTEP(1);

	 s[0] = sqrt(s[0]);

	 TIMESTEP(2);
	 
	 
	 m_Dependent = sqrt(s[0]);
	 
	 s2[2] = 1.0;
	 s2[2] += s2[0]*s[0];

      }
      
      adolc::ObjectiveFunctionBase* Create() const {return new OurFunction();}
      
      adolc::ObjectiveFunctionBase::LabelsContainerType GetLabels() const
      { 
	 adolc::ObjectiveFunctionBase::LabelsContainerType labels;

	 labels.push_back(Label(0));
	 labels.push_back(Label(1));
	 labels.push_back(Label(2));

	 return labels;
      }


};


int main_real()
{
   OurFunction f;
   f.AllocateIndependents(1);


   adolc::Revolve R;
   R.SetSnaps(20);
   R.SetFunction(&f);
   R.SetInfo(0);

 
   const int n=1;

   double p[n];
   double measure;
   double d[n];

   int status = 0;

   double x=0.1;
   for(;x<100.0;x+=.1)
   {
      p[0]=x;
      R.Evaluate(p,&measure,d);

   
   
      std::cout << "parameters:  ";

      std::cout.setf(std::ios_base::scientific,std::ios_base::floatfield);
      std::cout.precision(16);

      std::cout << p[0] << " ";
      std::cout << "\n";

      std::cout << "Results using AD :\n";

      std::cout << "measure:  " << measure << "\n";
      std::cout << "derivative:  ";
      std::cout << d[0] << " ";
      std::cout << "\n";

      std::cout << "Results by direct differentiation :\n";
      double measure2 = pow(p[0],(1.0/8.0));
      std::cout << "measure:  " << measure2 << "\n";
      std::cout << "derivative:  ";
      double deriv = 1.0/(8.0*pow(p[0],7.0/8.0));
      std::cout << deriv << " ";
      std::cout << "\n";

      const double eps = 1e-15;

      if(fabs(measure - measure2) > eps)
      {
	 std::cout << "Error: direct evaluation of function does not "
	    "agree with AD" << std::endl;
	 status = 1;
      }

      if(fabs(d[0] - deriv) > eps)
      {
	 std::cout <<"Error: direct evaluation of derivative does not "
	    "agree with AD" << std::endl;
	 status = 1;
      }
      

   }

   if(status == 1)
      return EXIT_FAILURE;
   else
      return EXIT_SUCCESS;
}


int main()
{
   int status=0;
   status = main_real();
   if(status)
      return status;
      
   status = main_real();
   return status;
 
}
