#ifndef _RevolveDriver_h
#define _RevolveDriver_h


#include <vector>

#include "ObjectiveFunctionBase.h"

namespace adolc
{


class Revolve
{
   public:

      // The following function must be called before calling Run
      void SetFunction(const ObjectiveFunctionBase* func);
   

      // sets the debugging level. Default is zero (no debugging)
      void SetInfo(int s) { m_Info = s; }
      int GetInfo() const { return m_Info; }

      // Sets the number of snapshots. 64 is the max. Note this function must
      // be called *before* SetFunction. If you want to call this function
      // more than once, then be sure to also call SetFunction afterwards each
      // time.
      void SetSnaps(int s) { m_Snaps = s; }
      int GetSnaps() const { return m_Snaps; }
   

      // This performs the differentiation given the values of the independent
      // variables (in parameters). It returns the value and gradient of the
      // function. If deriv is null then just the function value is returned
      void Evaluate(const double* parameters,double* value, double* deriv=0);
      double Evaluate(const double* parameters)
      { double value;this->Evaluate(parameters,&value,0);return value;}

      // You probably won't need to call these functions
      void SetSteps(int s) { m_Steps = s; }
      int GetSteps() const { return m_Steps; }

      void SetCapo(int c) { m_Capo = c; }
      int GetCapo() const { return m_Capo; }

      void SetFine(int s) { m_Fine = s; }
      int GetFine() const { return m_Fine; }

      void SetCheck(int s) { m_Check = s; }
      int GetCheck() const { return m_Check; }

      void SetTape(int s) { m_Tape = s; }
      int GetTape() const { return m_Tape; }


      int GetCurrentTime() const { return m_CurrentTime; }
      bool AreWeDoingForwardSweep() const { return m_DoingForwardSweep; }


   
      Revolve();
      virtual ~Revolve();
   
   
   
   private:

      virtual void AdvanceOneStep(int t) const;
      virtual void TakeShot();
      virtual void Restore();
      virtual void YouTurn(int t);
      virtual void FirstTurn(int t);


      void SetDependent();
      void SetIndependents() const;
   
      int m_Info;
      int m_Capo;
      int m_Snaps;
      int m_Steps;
      int m_Check;
      int m_Fine;
      int m_CurrentTime;
      bool m_DoingForwardSweep;
   

      short m_Tape;
      int m_Keep;
      std::vector<double> m_Derivative;
   
      int m_TopOfStack;
      std::vector<ObjectiveFunctionBase*> m_Stack;
      //const ObjectiveFunctionBase* m_Function;
      unsigned int m_NumberOfIndependents;

      double m_TimeSpentInReverse;
      double m_TimeSpentRecording;

      double m_FinalObjectiveFunctionValue;

      ObjectiveFunctionBase::LabelsContainerType m_Labels;

      Revolve(const Revolve& rhs); // purposely not implemented
      Revolve& operator=(const Revolve& rhs); // purposely not implemented

};

}

#endif
