#ifndef __ObjectiveFunctionBase_h
#define __ObjectiveFunctionBase_h

#include "adolc.h"
#include "JumptableMacros.h"

#include <vector>
#include <valarray>

extern int trace_flag;

namespace adolc
{

   class Revolve;

class ObjectiveFunctionBase
{

   public:

      // The following function must be called during the
      // initialization before passing the function to the Revolve class
      static void AllocateIndependents(unsigned int n);
      //static void SetNumberOfIndependents(unsigned int n);

      static unsigned int GetNumberOfIndependents()
      {return m_NumberOfIndependents;}




      class Label
      {
	    typedef unsigned char Type;
	    Type current;
	    Type L[3];
	 public:
	    //Label(){ L[0]=L[1]=L[2]=current=0; }
	    explicit Label(Type a=0,Type b=0,Type c=0):current(0)
	    { L[0]=a;L[1]=b;L[2]=c; }
	    Label(const Label& r):current(r.current)
	    {L[0]=r.L[0];L[1]=r.L[1];L[2]=r.L[2];}
	    int GetAndIncr() { return L[current++]; } // Get the next label
						      // and then increment
	    int Get(int i) const { return L[i]; }
	    void Reset() { current=0; }
      };



      typedef std::vector<Label> LabelsContainerType;

   protected:


      // The following 3 functions must be defined in the subclass
      virtual void Function(Label& label) = 0;

      // return a pointer to a new object of this class from the heap. The caller
      // of this function is responsible for deleting it.
      virtual ObjectiveFunctionBase* Create() const = 0;

      virtual LabelsContainerType GetLabels() const = 0;

      // This function copies the data from rhs without doing any allocation.
      // If the derived class declares its own local data, then the derived
      // class must define its own CopyData function and in which it calls the
      // base class' CopyData. Otherwise it's not needed in the derived class.
      virtual void CopyData(const ObjectiveFunctionBase* rhs);



      bool AreWeJustEvaluatingFunction() const { return m_JustEvaluateFunction; }
      bool AreWeDoingForwardSweep() const { return m_DoingForwardSweep; }
      int AreWeCurrentlyTracing() const {return trace_flag;}


      void CopyLocalStoreToGlobalStore() const;
      void CopyGlobalStoreToLocalStore();


   
      static adouble m_Dependent;
      static adouble* m_Independents;
      static unsigned int m_NumberOfIndependents;



      ObjectiveFunctionBase();
      virtual ~ObjectiveFunctionBase();



   private:

      friend class Revolve;


      std::valarray<double> m_StoreCopy;

      bool m_JustEvaluateFunction;
      bool m_DoingForwardSweep;



      ObjectiveFunctionBase(const ObjectiveFunctionBase& rhs);//purposely not
							      //implemntd.
      ObjectiveFunctionBase& operator=(
	 const ObjectiveFunctionBase& rhs); // purposely not implemented. Use
					    // the CopyData function instead.

};

}


#endif
