#include "ObjectiveFunctionBase.h"


extern double* store;
extern locint location_cnt;


namespace adolc
{

   adouble ObjectiveFunctionBase::m_Dependent;
   adouble* ObjectiveFunctionBase::m_Independents = 0;
   unsigned int ObjectiveFunctionBase::m_NumberOfIndependents = 0;

   
ObjectiveFunctionBase::ObjectiveFunctionBase():
   m_JustEvaluateFunction(false),
   m_DoingForwardSweep(false)

{
}

ObjectiveFunctionBase::~ObjectiveFunctionBase()
{
}

void
ObjectiveFunctionBase::CopyData(const ObjectiveFunctionBase* rhs)
{
   if(this == rhs)
      return;


   m_StoreCopy.resize(rhs->m_StoreCopy.size());

   m_StoreCopy = rhs->m_StoreCopy;


   m_JustEvaluateFunction = rhs->m_JustEvaluateFunction;
   m_DoingForwardSweep = rhs->m_DoingForwardSweep;

}


void ObjectiveFunctionBase::CopyGlobalStoreToLocalStore()
{

   m_StoreCopy.resize(location_cnt);

   for(unsigned int i=0;i<m_StoreCopy.size();i++)
   {
      m_StoreCopy[i] = store[i];
   }

}

void ObjectiveFunctionBase::CopyLocalStoreToGlobalStore() const
{

   for(unsigned int i=0;i<m_StoreCopy.size();i++)
   {
      store[i] = m_StoreCopy[i];
   }

}

void ObjectiveFunctionBase::AllocateIndependents(unsigned int n)
{

   if(0 == n)
   {
      std::cout << "Error. Number of Independents must be greater than zero."
		<< std::endl;
      abort();
   }

   if(m_NumberOfIndependents == n)
      return;
   
   m_NumberOfIndependents = n;

   if(m_Independents)
   {
     delete [] m_Independents;
     m_Independents = 0;
   }

   m_Independents = new adouble[n];

   if(!m_Independents)
   {
      std::cout << "Error. Could not allocate adouble array of size "
		<< n << std::endl;
      abort();
   }

}
}
