#ifndef __itkekJumptableMacros_h
#define __itkekJumptableMacros_h

#include <iostream>
#include <cstdlib>

//#define TIMESTEP(N) {return; L ## N:;}
/* Example: If N is 3, then this expands to:
{
   return;
  L3:;
}
*/
//#define TIMESTEP_MOD(N,INDEX,VALUE) if(0 == INDEX % VALUE)
//                                       {TIMESTEP(N);}


#define JUMPTABLE_5_GOTO_MACRO   switch(label.GetAndIncr()) \
   {                \
      case 0:       \
	 goto L0;   \
      case 1:       \
	 goto L1;   \
      case 2:       \
	 goto L2;   \
      case 3:       \
	 goto L3;   \
      case 4:       \
	 goto L4;   \
      case 5:       \
	 goto L5;   \
      default:      \
         std::cout << "Error. Invalid label\n";abort(); \
   }

// All the following look like the above but using macros instead
#define CASE_GOTO(N) case N: goto L ## N;
#define CASE_DEFAULT default: std::cout << "Error. Invalid label\n";abort();

#define JUMPTABLE_1_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_2_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_3_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_4_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_6_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_7_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_8_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_9_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_10_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_11_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_12_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_13_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_14_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_15_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) CASE_GOTO(15) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_16_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) CASE_GOTO(15) \
    CASE_GOTO(16) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_17_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) CASE_GOTO(15) \
    CASE_GOTO(16) CASE_GOTO(17) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_18_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) CASE_GOTO(15) \
    CASE_GOTO(16) CASE_GOTO(17) CASE_GOTO(18) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_19_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) CASE_GOTO(15) \
    CASE_GOTO(16) CASE_GOTO(17) CASE_GOTO(18) CASE_GOTO(19) \
    CASE_DEFAULT \
   }
#define JUMPTABLE_20_GOTO_MACRO   switch(label.GetAndIncr()) \
   { \
    CASE_GOTO(0) \
    CASE_GOTO(1) CASE_GOTO(2) CASE_GOTO(3) CASE_GOTO(4) CASE_GOTO(5) \
    CASE_GOTO(6) CASE_GOTO(7) CASE_GOTO(8) CASE_GOTO(9) CASE_GOTO(10) \
    CASE_GOTO(11) CASE_GOTO(12) CASE_GOTO(13) CASE_GOTO(14) CASE_GOTO(15) \
    CASE_GOTO(16) CASE_GOTO(17) CASE_GOTO(18) CASE_GOTO(19) CASE_GOTO(20) \
    CASE_DEFAULT \
   }


#endif
