% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{smooth}
\alias{smooth}
\title{Smooth the original intensities to remove outliers}
\usage{
smooth(lrr, R = 10, t = 2)
}
\arguments{
\item{lrr}{the matrix of the signal intensities. Each column presents a sequence or subject, each row represents a single marker}

\item{t}{the tuning parameter for smoothing region, defaults to 2}
}
\description{
This function runs the smoothing procedure in the original intensities to remove outliers.
}
\examples{
# Input the example data of SNP genotyping data from Affymatrix Human SNP Array 6.0 platform.
data(example.data.lrr)
data(example.data.baf)
# Use LRR and BAF information of ten samples to calculate eCN
eCN.cal <- eCN(lrr=example.data.lrr,baf=example.data.baf)
e_CN <- eCN.cal$e_CN
# This returns a matrix of smoothed signal intensites of copy number estimatese
e_CN.smo <- smooth(e_CN, R=10, t=2)
}