% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSaRa.R
\name{multiSaRa}
\alias{multiSaRa}
\title{Screening procedure processing single sequence to find local maximizers of the local dignostic statistic}
\usage{
multiSaRa(Y, h1 = 3 * round(log10(length(Y))), h2 = 2 *
  round(log10(length(Y))), h3 = round(log10(length(Y))), FINV = NULL,
  precise = 10000, sigma = NULL)
}
\arguments{
\item{Y}{the vector of the intensities of markers}

\item{h1}{the bandwidth 1 for the screening procedure, defaults to 5}

\item{h2}{the bandwidth 2 for the screening procedure, defaults to 10}

\item{h3}{the bandwidth 3 for the screening procedure, defaults to 15}

\item{FINV}{the inverse CDF of the local minimum p-values, approximated by function fInverse()}

\item{precise}{the precision of the inverse CDF of local min p-values. This will be used only if FINV is not specified. Defaults to 10000}

\item{sigma}{the standard deviation for the intensities between two adjacent change-points, defaults to NULL}
}
\value{
The return is a list of index with local minimum p values at each bandwidth.
}
\description{
This function runs the screening step under multiple bandwidths processing a single sequence.
}
\seealso{
\link{SARA} for processing the screening and ranking steps using single bandwidth
}
