% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiedSaRa.R
\name{modifiedSaRa}
\alias{modifiedSaRa}
\title{CNV detection processing multiple sequences using the modified SaRa algorithm}
\usage{
modifiedSaRa(Y, alpha = 0.01, h1 = 5, h2 = 10, h3 = 15, L = 100,
  sigma = NULL, precise = 10000, FINV = NULL)
}
\arguments{
\item{Y}{the numeric vector of the intensities of markers}

\item{alpha}{the significance levels for the test to accept change-points}

\item{h1}{the bandwidth 1 for the screening procedure, defaults to 5}

\item{h2}{the bandwidth 2 for the screening procedure, defaults to 10}

\item{h3}{the bandwidth 3 for the screening procedure, defaults to 15}

\item{L}{number of iterations in the EM algorithm for CNV clustering}

\item{sigma}{the standard deviation for the intensities between two adjacent change-points, defaults to NULL}

\item{precise}{the precision of the inverse CDF of local min p-values. This will be used only if FINV is not specified. Defaults to 10000}

\item{simT}{number of simulations in getting the inverse CDF of the local minimum p values}
}
\value{
This function generates a list of detected change-points and clustered CNVs for all samples.

newcp a list of vectors presenting detected change-points, which is in marker index units. Length of the list is the number of samples or sequences

h a list of vectors presenting the bandwidth used for this detected change-points. Length of the list is the number of samples

cnv.state state of detected CNV segments, duplication or deletion

cnv.start a list of vectors presenting the start position of CNV segments

cnv.end a list of vectors presenting the end position of CNV segments
}
\description{
This function runs the modified SaRa algorithm and cluster the change-points to CNVs processing multiple sequences.
}
\seealso{
\link{multiSaRa} for processing the screening and ranking steps for single sequence
}
