% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localDiagnostic.R
\name{localDiagnostic}
\alias{localDiagnostic}
\title{Calculate the value for local diagnostic function}
\usage{
localDiagnostic(y, h)
}
\arguments{
\item{y}{the numeric vector of the intensities of markers}

\item{h}{the bandwidth for the screening procedure}
}
\value{
This function generates a numeric vector of local diagnostic function values D(x,h) at each point x
}
\description{
This function calculates local diagnostic function D(x,h) at each point x which depends only on observations in a small neighborhood [x-h,x+h].
}
\details{
Local diagnostic function reflects of position x being or neighborhooding a change-point. A reasonable
local diagnostic is\deqn{D(x)=\frac{\Sigma_{k=1}^{h} y_{x+k}-\Sigma_{k=1}^{h} y_{x+1-k}}{h}}
which is the difference between averages of h data points on the left side and right side of x.
Suppose the errors \eqn{\varepsilon_{i}=0} which means \eqn{Y=\mu} is a piecewise constant vector and D(x) is piecewise linear function.
Based on this function, we proposed a recursive formula\deqn{D(x+1)_{h}=D(x)_{h}+\frac{Y_{x-h+1}+Y_{x+h+1}-2Y_{x+1}}{h}}
}
