% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gausianMixture.R
\name{gausianMixture}
\alias{gausianMixture}
\title{Clustering of CNVs using Expectation-Maximization algorithm}
\usage{
gausianMixture(x, cp, priors, L, st)
}
\arguments{
\item{x}{the vector of the intensities of markers}

\item{cp}{the vector of the marker index of the identified change-points}

\item{priors}{given initial parameters for the EM algorithm}

\item{L}{repeat times in the EM algorithm. Defaults to 100}

\item{st}{number of assumed states in the EM algorithm}
}
\value{
The return is the clustered CNV segments by presenting the start position and end position using SNP or CNV marker index, and the copy number states. It also returns a vector of final candidates of change-points.

p.final probability of falling into each state for each CNV segment after convergence

mu.final segment means of each state after convergence

cp.final list of change-points after EM algorithm

index.final the bandwidth of change-points

state.new assigned copy number state for each CNV
}
\description{
This function clusters the identified change-points to make final CNV calling.The potential CNV segments between two neighbor candidate change-points are assigned to different copy number states according to the average intensities in the segment intervals. We use three clusters including duplication, normal state and deletion. Each cluster is presented by Gaussian distribution with unknown mean and variance. Expectation-Maximization (EM) algorithm is applied for the mixture of Gaussians to assign each segment to the most probable cluster/state. Two physically linked candidate CNV segments in the same group are merged to one unique CNV segment.
}
