% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eCN.R
\name{eCN}
\alias{eCN}
\title{eCN}
\usage{
eCN(lrr, baf)
}
\arguments{
\item{lrr}{the matrix of the log R ratio intensities. Each column describes a single sample or sequence and each row describes a single marker}

\item{baf}{the matrix of the B Allele Frequency intensities. Each column describes a single sample or sequence and each row describes a single marker}
}
\value{
laf the matrix of lesser allele frequency intensities

e_CN.smo the matrix of copy number estimate intensities after smoothing

e_CN the matrix of copy number estimate intensities

cn.est.L the list of likelihood of being each copy number state for each position in the sequence
}
\description{
This function calculates the copy number estimate eCN using the LRR and BAF intensities.
}
\examples{
# Input the example data of SNP genotyping data from Affymatrix Human SNP Array 6.0 platform.
# The map file displays annotation of the markers including the chromosome and location
# information of each SNP or CNV marker.
data(example.data.lrr)
data(example.data.baf)
# Use LRR and BAF information of ten samples to calculate eCN
eCN.cal <- eCN(lrr=example.data.lrr,baf=example.data.baf)
e_CN <- eCN.cal$e_CN
# This returns a matrix of new signal intensites of copy number estimates
}
\seealso{
\link{Likeli.single} for calculating the likelihood of being each copy number state

\link{smooth} for smoothing the intensities
}
