% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SARAp.R
\name{SARAp}
\alias{SARAp}
\title{Screening procedure processing single sequence to find local maximizers of the dignostic statistic}
\usage{
SARAp(Y, h, hh = 2 * h, sigma = NULL)
}
\arguments{
\item{Y}{the numeric vector of the intensities of markers}

\item{h}{the bandwidth for the screening procedure, defaults to 10}

\item{hh}{the bandwidth for the local minimum procedure}

\item{sigma}{the standard deviation for the intensities between two adjacent change points, defaults to NULL}
}
\value{
The return is a vector of local p-value minimum and the marker index of these minimum.

index numeric vector a position index for all the local p-value minimum

pV local minimum p-values
}
\description{
This function runs the screening procedure under single bandwidth processing a single sequence. Local maximizers of the diagnostic statistic or the corresponding minimum p-values within bandwidth h are identified.
}
\seealso{
\link{estimateSigma} for estimation of the standard deviation between two adjacent change-points. \link{localMax} for calculation of the local maximizers of local diagnostic function
}
