% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SARA.R
\name{SARA}
\alias{SARA}
\title{Screening procedure processing single sequence and p value calculation of local maximizers}
\usage{
SARA(Y, h = 10, hh = 2 * h, FINV = NULL, sigma = NULL,
  precise = 10000)
}
\arguments{
\item{Y}{the numeric vector of the intensities of markers}

\item{h}{the bandwidth for the screening procedure, defaults to 10}

\item{hh}{the bandwidth for the local minimum procedure}

\item{FINV}{the inverse CDF of the local min p-values, approximated by function fInverse}

\item{sigma}{the standard deviation for the intensities between two adjacent change points, defaults to NULL}

\item{precise}{the precision of the inverse CDF of local minimum p-values. This will be used only if FINV is not specified. Defaults to 10000}
}
\value{
The return is a vector of corrected local p-value minimum and the marker index of these minimum.

index index of markers for the corrected local p-value minimizers

pV corrected local min p-values
}
\description{
This function runs the screening and ranking algorithm under single bandwidth processing a single sequence. Local min p-values are corrected by approximation emprically by the distribution of the local minimizers in a long standard normal sequence.
}
\seealso{
\link{SARAp} for processing the screening step using single bandwidth to find local maximizers of the diagnostic statistic
}
