% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuanNorm.R
\name{QuanNorm}
\alias{QuanNorm}
\title{Quantile normalization of the original intentisites}
\usage{
QuanNorm(lrr)
}
\arguments{
\item{lrr}{the matrix of intensities. Each column represents a sequence or subject, each row represents a single marker}
}
\value{
This function generates a vector of signal intensities for a single sequence after quantile normalization
}
\description{
This function runs the quantile normalization procedure for each sequence separately as a preprocessing step.
}
\examples{
# Input the example data of SNP genotyping data from Affymatrix Human SNP Array 6.0 platform
data(example.data.lrr)
lrr.qn <- QuanNorm(example.data.lrr) ## quantile normalization of the intensities
}
