% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNVout.R
\name{CNVout}
\alias{CNVout}
\title{CNVout}
\usage{
CNVout(e_CN, lrr, laf, map, h1 = 5, h2 = 10, h3 = 15, L = 100,
  sigma = NULL, precise = 10000, FINV = NULL, alpha = 0.01, thre = 10,
  dis.thre = 5, outname = NULL)
}
\arguments{
\item{map}{Each line of the map file describes a single marker and must contain exactly 3 columns: chromosome ID; rs# or marker identifier; position (in bp units)}

\item{h1}{the bandwidth 1 for the screening procedure, defaults to 5}

\item{h2}{the bandwidth 2 for the screening procedure, defaults to 10}

\item{h3}{the bandwidth 3 for the screening procedure, defaults to 15}

\item{L}{number of iterations in the EM algorithm for CNV clustering}

\item{alpha}{the significance levels for the test to accept change-points}

\item{thre}{the threshold for CNV length}

\item{dis.thre}{the threshold for distance between CNVs for merging adjacent closely located CNVs}

\item{outname}{name for the output file}

\item{eCN}{the matrix of the eCN intensities. Each column describes a single sample or sequence and each row describes a single marker}
}
\value{
This function generates a text file describing all detected CNVs. In addition, it also returns a list of detected change-points for all samples.

cp a list of position index for the final change-points identified by modSaRa
}
\description{
This function annotates the identified CNV using the reference map file and output the annotation of all identified CNVs. Each line of the output describes one CNV in nine columns: individual ID; chromosome ID; CNV start marker identifier; CNV start location (in base pair units); CNV end marker identifier; CNV end location (in base pair units); length of CNV (in base pair units); length of CNV(number of markers); copy number states (duplication or deletion).
}
\examples{
# Input the example data of SNP genotyping data from Affymatrix Human SNP Array 6.0 platform.
# The map file displays annotation of the markers including the chromosome and location
# information of each SNP or CNV marker.
data(example.data.lrr)
data(example.data.baf)
data(example.data.map)
data(FINV)
# Use LRR and BAF information of ten samples to calculate eCN
eCN.cal <- eCN(lrr=example.data.lrr,baf=example.data.baf)
e_CN <- eCN.cal$e_CN
# This returns a matrix of new signal intensites of copy number estimates
# Use eCN information of ten samples to detect CNVs
cnv.out <- CNVout(e_CN = e_CN, lrr = example.data.lrr, laf = eCN.cal$laf, map = example.data.map, 
	FINV = FINV, alpha = 0.01, outname="out")
# The following file will be generated: "out.csv"
# This file contains CNV output for each individual.
# Each line represents one CNV detected from one sample or sequence.
# For each line, the individual ID, start position, end position, length and state
# (duplication or deletion) of the CNV will be shown.
out.cp <- cnv.out$cp
# This returns a list of vectors containing detected change-points by modSaRa for each
# sample in the marker name.
}
\seealso{
\link{modifiedSaRa} for processing the modified SaRa method
}
