% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_build.R
\name{tree_build}
\alias{tree_build}
\title{Build a tree}
\usage{
tree_build(
  data,
  method = c("entropy", "gini"),
  alpha = 0.01,
  cost = NULL,
  is_prune = TRUE
)
}
\arguments{
\item{data}{The input data for classification tree.
The first column gives the class label and the rest columns are covariates.}

\item{method}{criteria for measuring the impurity of nodes in the tree.}

\item{alpha}{a parameter used for tree construction.}

\item{cost}{a parameter used for making prediction with tree model.}

\item{is_prune}{a binary indicator to indicates whether the tree will be pruned or not.}
}
\value{
A ctree class object containing tree information and the chi-square stat for each node.
}
\description{
This function builds the tree and output the chi-square statistics for each node.
The function depends on an Rcpp wrapper of "cctree" and R function "trim_ctree"
}
\examples{
set.seed(12345 + 987)
n_sample <- 2000
n_var <- 200
maf <- runif(n_var, 0.05, 0.45)
x <- sapply(maf, function(snp.maf){sample(x=c(2,1,0), n_sample, replace=TRUE, 
prob=c(snp.maf^2, 2* snp.maf *(1-snp.maf), (1-snp.maf)^2))})
colnames(x) <- paste0("X_", seq(n_var))

log.odds <- -1 + (x[, 2] > 0)
prob.case <- exp(log.odds) / (1 + exp(log.odds))
Y <- sapply(prob.case, rbinom, n = 1, size = 1)

data <- cbind(Y, x)
test.tree <- tree_build(data, method = "entropy") # build the tree for a data set
test.chi <- test.tree$chi # extract the chi-square stat for each node
}
\author{
Jianchang Hu
}
