% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_var_extract.R
\name{split_var_extract}
\alias{split_var_extract}
\title{Splitting variables}
\usage{
split_var_extract(tree.result)
}
\arguments{
\item{tree.result}{The tree output from cctree.}
}
\value{
A vector of characteristics giving the name of each splitting variable in the tree.
}
\description{
This function extracts the information of split variables from tree output.
}
\examples{
set.seed(12345 + 987)
n_sample <- 2000
n_var <- 200
maf <- runif(n_var, 0.05, 0.45)
x <- sapply(maf, function(snp.maf){sample(x=c(2,1,0), n_sample, replace=TRUE, 
prob=c(snp.maf^2, 2* snp.maf *(1-snp.maf), (1-snp.maf)^2))})
colnames(x) <- paste0("X_", seq(n_var))

log.odds <- -1 + (x[, 2] > 0)
prob.case <- exp(log.odds) / (1 + exp(log.odds))
Y <- sapply(prob.case, rbinom, n = 1, size = 1)

data <- cbind(Y, x)
test.tree <- tree_build(data, method = "entropy") # build the tree for a data set
split.var.name <- split_var_extract(test.tree)
}
\author{
Jianchang Hu
}
