% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/di_cal_parallel.R
\name{di_cal}
\alias{di_cal}
\title{Depth importance measure}
\usage{
di_cal(pheno, geno, num.trees = 1000, num.var.boot = NULL)
}
\arguments{
\item{pheno}{A vector indicates case-control status.}

\item{geno}{A matrix containing SNPs data, each column corresponding to single SNP,
and the column name is the SNP ID}

\item{num.trees}{Number of trees constructed in the random forest, default number is 1000.}

\item{num.var.boot}{Number of variables considered in each tree construction,
default number is one-fifth of the total number of SNPs.}
}
\value{
A numeric vector giving the depth importance measure of each SNP.
}
\description{
This function constructs random forest to calculate depth importance measure of variables.
This function utilizes package snowfall to construct trees in parallel.
}
\examples{
set.seed(12345 + 987)
n_sample <- 2000
n_var <- 200
maf <- runif(n_var, 0.05, 0.45)
x <- sapply(maf, function(snp.maf){sample(x=c(2,1,0), n_sample, replace=TRUE,
prob=c(snp.maf^2, 2* snp.maf *(1-snp.maf), (1-snp.maf)^2))})
colnames(x) <- paste0("X_", seq(n_var))

log.odds <- -1 + (x[, 2] > 0)
prob.case <- exp(log.odds) / (1 + exp(log.odds))
Y <- sapply(prob.case, rbinom, n = 1, size = 1)
table(Y)

\dontrun{
library(diTARV)
di.measure <- di_cal(Y, x)
}
}
\author{
Jianchang Hu
}
